/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class FIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue.Block head;
    private BlockRevQueue.Block tail;

    public FIFORevQueue() {
        super(false);
    }

    FIFORevQueue(boolean firstParent) {
        super(firstParent);
    }

    FIFORevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s);
    }

    @Override
    public void add(RevCommit c) {
        BlockRevQueue.Block b = this.tail;
        if (b == null) {
            b = this.free.newBlock();
            b.add(c);
            this.head = b;
            this.tail = b;
            return;
        }
        if (b.isFull()) {
            this.tail.next = b = this.free.newBlock();
            this.tail = b;
        }
        b.add(c);
    }

    public void unpop(RevCommit c) {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            b = this.free.newBlock();
            b.resetToMiddle();
            b.add(c);
            this.head = b;
            this.tail = b;
            return;
        }
        if (b.canUnpop()) {
            b.unpop(c);
            return;
        }
        b = this.free.newBlock();
        b.resetToEnd();
        b.unpop(c);
        b.next = this.head;
        this.head = b;
    }

    @Override
    public RevCommit next() {
        BlockRevQueue.Block b = this.head;
        if (b == null) {
            return null;
        }
        RevCommit c = b.pop();
        if (b.isEmpty()) {
            this.head = b.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(b);
        }
        return c;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i2 = b.headIndex;
            while (i2 < b.tailIndex) {
                if ((b.commits[i2].flags & f) == 0) {
                    return false;
                }
                ++i2;
            }
            b = b.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int f) {
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i2 = b.headIndex;
            while (i2 < b.tailIndex) {
                if ((b.commits[i2].flags & f) != 0) {
                    return true;
                }
                ++i2;
            }
            b = b.next;
        }
        return false;
    }

    void removeFlag(int f) {
        int not_f = ~f;
        BlockRevQueue.Block b = this.head;
        while (b != null) {
            int i2 = b.headIndex;
            while (i2 < b.tailIndex) {
                b.commits[i2].flags &= not_f;
                ++i2;
            }
            b = b.next;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        BlockRevQueue.Block q = this.head;
        while (q != null) {
            int i2 = q.headIndex;
            while (i2 < q.tailIndex) {
                FIFORevQueue.describe(s, q.commits[i2]);
                ++i2;
            }
            q = q.next;
        }
        return s.toString();
    }
}

