/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.logging.LoggingSystemException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public final class LogbackUtils {
    private static final String DEFAULT_LOGBACK_13_PROGRAMMATIC_CONFIGURATOR = "ch.qos.logback.classic.util.DefaultJoranConfigurator";

    private LogbackUtils() {
    }

    public static void configure(@NonNull ClassLoader classLoader, @NonNull LoggerContext context, @NonNull String logbackXmlLocation) {
        LogbackUtils.configure(context, logbackXmlLocation, () -> {
            URL resource = classLoader.getResource(logbackXmlLocation);
            if (resource != null) {
                return resource;
            }
            File file = new File(logbackXmlLocation);
            if (file.exists()) {
                try {
                    resource = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new LoggingSystemException("Error creating URL for off-classpath resource", e);
                }
            }
            return resource;
        });
    }

    private static void configure(@NonNull LoggerContext context, @NonNull String logbackXmlLocation, Supplier<URL> resourceSupplier) {
        Configurator configurator = LogbackUtils.loadFromServiceLoader();
        if (LogbackUtils.isSupportedConfigurator(context, configurator)) {
            context.getStatusManager().add((Status)new InfoStatus("Using " + configurator.getClass().getName(), (Object)context));
            LogbackUtils.programmaticConfiguration(context, configurator);
        } else {
            URL resource = resourceSupplier.get();
            if (resource != null) {
                try {
                    new ContextInitializer(context).configureByResource(resource);
                }
                catch (JoranException e) {
                    throw new LoggingSystemException("Error while refreshing Logback", e);
                }
            } else {
                throw new LoggingSystemException("Resource " + logbackXmlLocation + " not found");
            }
        }
    }

    private static boolean isSupportedConfigurator(LoggerContext context, Configurator configurator) {
        if (configurator == null) {
            return false;
        }
        if (DEFAULT_LOGBACK_13_PROGRAMMATIC_CONFIGURATOR.equals(configurator.getClass().getName())) {
            context.getStatusManager().add((Status)new InfoStatus("Skipping " + configurator.getClass().getName() + " as it's assumed to be from an unsupported version of Logback", (Object)context));
            return false;
        }
        return true;
    }

    private static void programmaticConfiguration(@NonNull LoggerContext context, @NonNull Configurator configurator) {
        try {
            configurator.setContext((Context)context);
            configurator.configure(context);
        }
        catch (Exception e) {
            throw new LoggingSystemException(String.format("Failed to initialize Configurator: %s using ServiceLoader", configurator.getClass().getCanonicalName()), e);
        }
    }

    @Nullable
    private static Configurator loadFromServiceLoader() {
        Iterator<Configurator> it = ServiceLoader.load(Configurator.class).iterator();
        return it.hasNext() ? it.next() : null;
    }
}

