/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class TeletexTerminalIdentifierSyntaxChecker
extends SyntaxChecker {
    public static final TeletexTerminalIdentifierSyntaxChecker INSTANCE = new TeletexTerminalIdentifierSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.51");

    private TeletexTerminalIdentifierSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String terminalIdentifier;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int dollar = strValue.indexOf(36);
        String string = terminalIdentifier = dollar == -1 ? strValue : strValue.substring(0, dollar);
        if (terminalIdentifier.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (!Strings.isPrintableString(terminalIdentifier)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (dollar == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            }
            return true;
        }
        String[] ttxParams = strValue.substring(dollar + 1).split("\\$");
        if (ttxParams.length == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        for (String ttxParam : ttxParams) {
            int colon = ttxParam.indexOf(58);
            if (colon == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
            String key = ttxParam.substring(0, colon);
            if (key.startsWith("graphic") || key.startsWith("control") || key.startsWith("misc") || key.startsWith("page") || key.startsWith("private")) {
                if (colon + 1 == ttxParam.length()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                boolean hasEsc = false;
                block9: for (byte b : Strings.getBytesUtf8(ttxParam)) {
                    switch (b) {
                        case 36: {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                            }
                            return false;
                        }
                        case 92: {
                            if (hasEsc) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                                }
                                return false;
                            }
                            hasEsc = true;
                            continue block9;
                        }
                        case 50: {
                            continue block9;
                        }
                        case 52: {
                            hasEsc = false;
                            continue block9;
                        }
                        case 53: {
                            continue block9;
                        }
                        case 67: 
                        case 99: {
                            hasEsc = false;
                            continue block9;
                        }
                        default: {
                            if (!hasEsc) continue block9;
                            return false;
                        }
                    }
                }
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<TeletexTerminalIdentifierSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.51");
        }

        @Override
        public TeletexTerminalIdentifierSyntaxChecker build() {
            return new TeletexTerminalIdentifierSyntaxChecker(this.oid);
        }
    }
}

