/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllUnion;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HllArrayTest {
    @Test
    public void checkCompositeEst() {
        HllArrayTest.testComposite(4, TgtHllType.HLL_8, 1000);
        HllArrayTest.testComposite(5, TgtHllType.HLL_8, 1000);
        HllArrayTest.testComposite(6, TgtHllType.HLL_8, 1000);
        HllArrayTest.testComposite(13, TgtHllType.HLL_8, 10000);
    }

    @Test
    public void checkBigHipGetRse() {
        HllSketch sk = new HllSketch(13, TgtHllType.HLL_8);
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
    }

    private static void testComposite(int lgK, TgtHllType tgtHllType, int n) {
        HllUnion u = new HllUnion(lgK);
        HllSketch sk = new HllSketch(lgK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            u.update((long)i);
            sk.update((long)i);
        }
        u.update(sk);
        HllSketch res = u.getResult(TgtHllType.HLL_8);
        res.getCompositeEstimate();
    }

    @Test
    public void toByteArray_Heapify() {
        int lgK = 4;
        int u = 8;
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_4, u, true);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_6, u, false);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_8, u, true);
        lgK = 16;
        u = (1 << lgK - 3) * 3 / 4 + 100;
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_4, u, false);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_6, u, true);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_8, u, false);
        lgK = 21;
        u = (1 << lgK - 3) * 3 / 4 + 1000;
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_4, u, true);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_6, u, false);
        HllArrayTest.toByteArrayHeapify(lgK, TgtHllType.HLL_8, u, true);
    }

    private static void toByteArrayHeapify(int lgK, TgtHllType tgtHllType, int u, boolean direct) {
        HllSketch sk1;
        MemorySegment wseg = null;
        if (direct) {
            int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
            wseg = MemorySegment.ofArray(new byte[bytes]);
            sk1 = new HllSketch(lgK, tgtHllType, wseg);
        } else {
            sk1 = new HllSketch(lgK, tgtHllType);
        }
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        assert (sk1.hllSketchImpl instanceof AbstractHllArray);
        if (sk1.hllSketchImpl instanceof HllArray) {
            Assert.assertFalse((boolean)sk1.hllSketchImpl.hasMemorySegment());
            Assert.assertFalse((boolean)sk1.isSameResource(wseg));
        } else {
            Assert.assertTrue((boolean)sk1.hllSketchImpl.hasMemorySegment());
            Assert.assertTrue((boolean)sk1.isSameResource(wseg));
        }
        double est1 = sk1.getEstimate();
        Assert.assertEquals((double)est1, (double)u, (double)((double)u * 0.03));
        Assert.assertEquals((double)sk1.getHipEstimate(), (double)est1, (double)0.0);
        sk1.hllSketchImpl.putEmptyFlag(false);
        sk1.hllSketchImpl.putRebuildCurMinNumKxQFlag(true);
        sk1.hllSketchImpl.putRebuildCurMinNumKxQFlag(false);
        byte[] byteArray = sk1.toCompactByteArray();
        HllSketch sk2 = HllSketch.heapify((byte[])byteArray);
        double est2 = sk2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        byteArray = sk1.toUpdatableByteArray();
        sk2 = HllSketch.heapify((byte[])byteArray);
        est2 = sk2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
        sk1.reset();
        Assert.assertEquals((double)sk1.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkHll4Exceptions() {
        int lgK = 4;
        int k = 16;
        HllSketch skH4 = new HllSketch(4, TgtHllType.HLL_4);
        for (int i = 0; i < 16; ++i) {
            skH4.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skH4.hllSketchImpl;
        try {
            absHllArr.updateSlotNoKxQ(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkDHll4Exceptions() {
        int lgK = 4;
        int k = 16;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        HllSketch skD4 = new HllSketch(4, TgtHllType.HLL_4, MemorySegment.ofArray(new byte[bytes]));
        for (int i = 0; i < 16; ++i) {
            skD4.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skD4.hllSketchImpl;
        try {
            absHllArr.updateSlotNoKxQ(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkHll6Exceptions() {
        int lgK = 4;
        int k = 16;
        HllSketch skH6 = new HllSketch(4, TgtHllType.HLL_6);
        for (int i = 0; i < 16; ++i) {
            skH6.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skH6.hllSketchImpl;
        try {
            absHllArr.getNibble(0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.putNibble(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.updateSlotNoKxQ(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkDHll6Exceptions() {
        int lgK = 4;
        int k = 16;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_6);
        HllSketch skD6 = new HllSketch(4, TgtHllType.HLL_6, MemorySegment.ofArray(new byte[bytes]));
        for (int i = 0; i < 16; ++i) {
            skD6.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skD6.hllSketchImpl;
        try {
            absHllArr.getNibble(0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.putNibble(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.updateSlotNoKxQ(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkHll8Exceptions() {
        int lgK = 4;
        int k = 16;
        HllSketch skH6 = new HllSketch(4, TgtHllType.HLL_8);
        for (int i = 0; i < 16; ++i) {
            skH6.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skH6.hllSketchImpl;
        try {
            absHllArr.getNibble(0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.putNibble(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkDHll8Exceptions() {
        int lgK = 4;
        int k = 16;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_8);
        HllSketch skD6 = new HllSketch(4, TgtHllType.HLL_8, MemorySegment.ofArray(new byte[bytes]));
        for (int i = 0; i < 16; ++i) {
            skD6.update((long)i);
        }
        AbstractHllArray absHllArr = (AbstractHllArray)skD6.hllSketchImpl;
        try {
            absHllArr.getNibble(0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
        try {
            absHllArr.putNibble(0, 0);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsCompact() {
        HllSketch sk = new HllSketch(4);
        for (int i = 0; i < 8; ++i) {
            sk.update((long)i);
        }
        Assert.assertFalse((boolean)sk.isCompact());
    }

    @Test
    public void printlnTest() {
        HllArrayTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

