/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.AbstractMultiFileConfigurationBuilderTest;
import org.apache.commons.configuration2.builder.combined.ReloadingMultiFileConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestReloadingMultiFileConfigurationBuilder
extends AbstractMultiFileConfigurationBuilderTest {
    @Test
    void testCreateManagedBuilder() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class);
        FileBasedConfigurationBuilder managedBuilder = builder.createManagedBuilder("test.xml", TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters(null).getParameters());
        Assertions.assertInstanceOf(ReloadingFileBasedConfigurationBuilder.class, (Object)managedBuilder);
        Assertions.assertFalse((boolean)managedBuilder.isAllowFailOnInit());
    }

    @Test
    void testCreateManagedBuilderWithAllowFailFlag() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class, null, true);
        FileBasedConfigurationBuilder managedBuilder = builder.createManagedBuilder("test.xml", TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters(null).getParameters());
        Assertions.assertTrue((boolean)managedBuilder.isAllowFailOnInit());
    }

    @Test
    void testInitWithParameters() throws ConfigurationException {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        BasicBuilderParameters params = TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters((BuilderParameters)new XMLBuilderParametersImpl().setExpressionEngine((ExpressionEngine)engine));
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class, params.getParameters());
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assertions.assertSame((Object)engine, (Object)config.getExpressionEngine());
    }

    @Test
    void testReloadingControllerCheck() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(2);
        builder.getConfiguration();
        List<ReloadingController> controllers = builder.getReloadingControllers();
        Assertions.assertEquals((int)2, (int)controllers.size());
        for (ReloadingController c : controllers) {
            Mockito.reset((Object[])new ReloadingController[]{c});
            Mockito.when((Object)c.checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        }
        Assertions.assertFalse((boolean)builder.getReloadingController().checkForReloading((Object)this));
        for (ReloadingController c : controllers) {
            ((ReloadingController)Mockito.verify((Object)c)).checkForReloading(null);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{c});
        }
    }

    @Test
    void testReloadingControllerCheckReloadingRequired() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        for (int i = 1; i <= 3; ++i) {
            TestReloadingMultiFileConfigurationBuilder.switchToConfig(i);
            builder.getConfiguration();
        }
        List<ReloadingController> controllers = builder.getReloadingControllers();
        Mockito.reset((Object[])controllers.toArray());
        Mockito.when((Object)controllers.get(0).checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)controllers.get(1).checkForReloading(null)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)controllers.get(2).checkForReloading(null)).thenReturn((Object)Boolean.FALSE);
        Assertions.assertTrue((boolean)builder.getReloadingController().checkForReloading((Object)this));
        for (ReloadingController c : controllers) {
            ((ReloadingController)Mockito.verify((Object)c)).checkForReloading(null);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{c});
        }
    }

    @Test
    void testReloadingControllerResetReloadingState() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(2);
        builder.getConfiguration();
        List<ReloadingController> controllers = builder.getReloadingControllers();
        Mockito.reset((Object[])controllers.toArray());
        for (ReloadingController c : controllers) {
            Mockito.when((Object)c.checkForReloading(null)).thenReturn((Object)Boolean.TRUE);
        }
        builder.getReloadingController().checkForReloading(null);
        builder.getReloadingController().resetReloadingState();
        for (ReloadingController c : controllers) {
            ((ReloadingController)Mockito.verify((Object)c)).checkForReloading(null);
            ((ReloadingController)Mockito.verify((Object)c)).resetReloadingState();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{c});
        }
    }

    private static final class ReloadingMultiFileConfigurationBuilderTestImpl
    extends ReloadingMultiFileConfigurationBuilder<XMLConfiguration> {
        private final List<ReloadingController> reloadingControllers = new ArrayList<ReloadingController>();

        public ReloadingMultiFileConfigurationBuilderTestImpl() {
            super(XMLConfiguration.class, AbstractMultiFileConfigurationBuilderTest.createTestBuilderParameters(null).getParameters());
        }

        protected FileBasedConfigurationBuilder<XMLConfiguration> createManagedBuilder(String fileName, Map<String, Object> params) throws ConfigurationException {
            final ReloadingController ctrl = (ReloadingController)Mockito.mock(ReloadingController.class);
            this.reloadingControllers.add(ctrl);
            return new ReloadingFileBasedConfigurationBuilder<XMLConfiguration>(this.getResultClass(), params){

                public ReloadingController getReloadingController() {
                    return ctrl;
                }
            };
        }

        public List<ReloadingController> getReloadingControllers() {
            return this.reloadingControllers;
        }
    }
}

