<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

# Partition

Partition is a Beam transform for PCollection objects that store the same data type.  Partition splits a single
PCollection into a fixed number of smaller collections.

Partition divides the elements of a PCollection according to a partitioning function (PartitionFn) that you provide. A
PartitionFn contains the logic that determines how to split up the elements of the input PCollection into
each resulting partition PCollection.

**Kata:** Provide a custom PartitionFn to
[beam.Partition](https://godoc.org/github.com/apache/beam/sdks/go/pkg/beam#Partition)
that splits a PCollection of numbers into two PCollections.  The first PCollection contains numbers greater
than 100, and the second PCollection contains the remaining numbers.

<div class="hint">
    Refer to
    <a href="https://godoc.org/github.com/apache/beam/sdks/go/pkg/beam#Partition">beam.Partition</a>
    to solve this problem.
</div>

<div class="hint">
  Refer to the Beam Programming Guide
  <a href="https://beam.apache.org/documentation/programming-guide/#partition">
    "Partition"</a> section for more information.
</div>
