TextDocs.NewDoc     9v   CWindowsLeft    WindowsRight g  WindowsTop 1   WindowsButtom   Color    Flat  Locked  Controls  Org    BIER           3     Syntax10.Scn.Fnt  /   Oberon10.Scn.Fnt      N         8                     7   !    0               D     (* Copyright (c) 1994 - 2000 Emil J. Zeller *)

MODULE WinMenus; (** non-portable / source: Win32.Plug.WinMenus.Mod *)	(* ejz   *)
	IMPORT SYSTEM, Kernel32, Kernel, FileDir, Files, Modules, Objects, User32, Displays, Display, Strings, Viewers,
		Attributes, Gadgets, Windows, Documents, Desktops, Texts, Oberon, COMDLG32;

	(** This module implements menus using windows pull-down menus. Menu items act like BasicGadgets.Button,
		thus can be stored in a object library like normal document menus. *)

	CONST
		WMDialog = User32.WMUser+8;
		WMContextMenu = User32.WMUser+9;
		Separator = "---";

	TYPE
		Frame* = POINTER TO RECORD (Gadgets.Frame)
			menu: Popup;
			pos: LONGINT
		END;

		(** a menu item with sub-menus (Item or Popup) *)
		Popup* = POINTER TO RECORD (Frame)
			hMenu: User32.HMenu;
			win: Windows.Window;
			n: LONGINT
		END;

		(** a leaf menu item (button) *)
		Item* = POINTER TO RECORD (Frame)
			id: LONGINT;
			cmd: ARRAY 64 OF CHAR
		END;

		LocateMsg = RECORD (Display.FrameMsg)
			id: LONGINT;
			item: Item
		END;

		Dialog* = POINTER TO RECORD (Objects.ObjDesc)
			owner*: Displays.Display;
			hwnd*: User32.HWND;
			context*: PTR;
			cmd*: ARRAY 64 OF CHAR
		END;

		OpenFileNameDialog* = POINTER TO RECORD (Dialog)
			filter*, name*: FileDir.FileName
		END;

		SaveFileNameDialog* = POINTER TO RECORD (Dialog)
			filter*, name*: FileDir.FileName
		END;

		FindTextDialog* = POINTER TO RECORD (Dialog)
			fr: COMDLG32.FindReplace;
			self*: FindTextDialog;
			find*: ARRAY 256 OF CHAR
		END;

		ReplaceTextDialog* = POINTER TO RECORD (Dialog)
			fr: COMDLG32.FindReplace;
			self*: ReplaceTextDialog;
			find*, replace*: ARRAY 256 OF CHAR
		END;

		PrintDialog* = POINTER TO RECORD (Dialog)
			print*: COMDLG32.PRINTDLG;
			done*: BOOLEAN
		END;

		PageSetupDialog* = POINTER TO RECORD (Dialog)
			page*: COMDLG32.PAGESETUPDLG;
			done*: BOOLEAN
		END;
	
	PROCEDURE InitFrame(F: Frame);
	BEGIN
		F.W := 0; F.H := 0;
		F.dsc := NIL; F.next := NIL;
		F.menu := NIL; F.pos := 0
	END InitFrame;

	PROCEDURE *DestroyPopup(F: PTR);
	BEGIN
		WITH F: Popup DO
			IF F.hMenu # Kernel32.NULL THEN
				User32.DestroyMenu(F.hMenu); F.hMenu := Kernel32.NULL
			END
		END
	END DestroyPopup;

	PROCEDURE GetCaption(F: Frame; VAR str: ARRAY OF CHAR);
	BEGIN
		IF F.menu # NIL THEN
			IF User32.GetMenuString(F.menu.hMenu, F.pos, str, LEN(str), {User32.MFByPosition}) = Kernel32.False THEN
				COPY(Separator, str)
			END
		ELSE
			COPY("", str)
		END
	END GetCaption;

	PROCEDURE FilePopup(F: Popup; VAR M: Objects.FileMsg);
		VAR f: Display.Frame; obj: Objects.Object; caption: ARRAY 64 OF CHAR;
	BEGIN
		Gadgets.framehandle(F, M);
		IF M.id = Objects.store THEN
			Files.WriteLInt(M.R, F.pos);
			Files.WriteLInt(M.R, F.n);
			Gadgets.WriteRef(M.R, F.lib, F.menu);
			f := F.dsc;
			WHILE f # NIL DO
				Gadgets.WriteRef(M.R, F.lib, f); f := f.next
			END;
			Gadgets.WriteRef(M.R, F.lib, NIL);
			IF F.menu # NIL THEN
				GetCaption(F, caption);
				Files.WriteString(M.R, caption)
			END
		ELSIF M.id = Objects.load THEN
			Files.ReadLInt(M.R, F.pos);
			Files.ReadLInt(M.R, F.n);
			Gadgets.ReadRef(M.R, F.lib, obj);
			IF obj # NIL THEN F.menu := obj(Popup) END;
			NEW(f); f.next := NIL; F.dsc := f;
			Gadgets.ReadRef(M.R, F.lib, obj);
			WHILE obj # NIL DO
				WITH obj: Frame DO
					f.next := obj; f := obj; f.next := NIL
				END;
				Gadgets.ReadRef(M.R, F.lib, obj)
			END;
			F.dsc := F.dsc.next;
			IF F.menu # NIL THEN
				Files.ReadString(M.R, caption);
				User32.InsertMenu(F.menu.hMenu, 0FFFFFFFFH, {User32.MFPopup, User32.MFByPosition}, F.hMenu, caption)
			END
		END
	END FilePopup;

	PROCEDURE CopyPopup(VAR M: Objects.CopyMsg; from, to: Popup);
		VAR f, last: Display.Frame; caption: ARRAY 64 OF CHAR;
	BEGIN
		Gadgets.CopyFrame(M, from, to);
		to.pos := from.pos; to.n := from.n; to.win := NIL;
		to.hMenu := User32.CreateMenu(); ASSERT(to.hMenu # Kernel32.NULL);
		Kernel.RegisterObject(to, DestroyPopup, FALSE);
		NEW(to.dsc); to.dsc.next := NIL; last := to.dsc;
		f := from.dsc;
		WHILE f # NIL DO
			M.obj := NIL; f.handle(f, M);
			last.next := M.obj(Frame); last := M.obj(Frame); last.next := NIL;
			f := f.next
		END;
		to.dsc := to.dsc.next;
		IF from.menu # NIL THEN
			GetCaption(from, caption);
			M.obj := NIL; from.menu.handle(from.menu, M);
			to.menu := M.obj(Popup);
			User32.InsertMenu(to.menu.hMenu, 0FFFFFFFFH, {User32.MFPopup, User32.MFByPosition}, to.hMenu, caption)
		ELSE
			to.menu := NIL
		END
	END CopyPopup;

	PROCEDURE UpdateMenu(F: Popup);
		VAR M: Desktops.UpdateNameMsg;
	BEGIN
		IF User32.GetMenu(F.win.hWnd) # F.hMenu THEN
			User32.SetMenu(F.win.hWnd, F.hMenu);
			M.F := NIL; M.obj := F.win.viewer.dsc.next;
			Display.Broadcast(M)
		END
	END UpdateMenu;

	PROCEDURE *PopupHandler(F: Objects.Object; VAR M: Objects.ObjMsg);
		VAR F1: Popup; f: Display.Frame;
	BEGIN
		WITH F: Popup DO
			IF M IS Display.FrameMsg THEN
				WITH M: Display.FrameMsg DO
					F.dlink := M.dlink;
					IF M.F = F THEN
						IF (F.menu = NIL) & (M.dlink IS Viewers.Viewer) THEN
							F.win := M.dlink(Viewers.Viewer).win(Windows.Window);
							UpdateMenu(F)
						END;
						F.W := 0; F.H := 0; M.res := 0
					ELSIF (M.F = NIL) OR (M.F IS Frame) THEN
						M.dlink := F;
						f := F.dsc;
						WHILE (f # NIL) & (M.res < 0) DO
							f.handle(f, M); f := f.next
						END;
						M.dlink := F.dlink
					END
				END
			ELSIF M IS Objects.AttrMsg THEN
				WITH M: Objects.AttrMsg DO
					IF M.id = Objects.get THEN
						IF M.name = "Gen" THEN
							M.class := Objects.String; M.s := "WinMenus.NewPopup"; M.res := 0
						ELSIF M.name = "HMENU" THEN
							M.class := Objects.Int; M.i := F.hMenu; M.res := 0
						ELSE
							Gadgets.framehandle(F, M)
						END
					ELSE
						Gadgets.framehandle(F, M)
					END
				END
			ELSIF M IS Objects.CopyMsg THEN
				WITH M: Objects.CopyMsg DO
					IF M.stamp = F.stamp THEN
						M.obj := F.dlink
					ELSE
						NEW(F1); F.stamp := M.stamp; F.dlink := F1;
						CopyPopup(M, F, F1); M.obj := F1
					END
				END
			ELSIF M IS Objects.BindMsg THEN
				WITH M: Objects.BindMsg DO
					Gadgets.BindObj(F, M.lib);
					f := F.dsc;
					WHILE f # NIL DO
						f.handle(f, M); f := f.next
					END
				END
			ELSIF M IS Objects.FileMsg THEN
				FilePopup(F, M(Objects.FileMsg))
			ELSE
				Gadgets.framehandle(F, M)
			END			
		END
	END PopupHandler;

	PROCEDURE InitPopup(F: Popup);
	BEGIN
		InitFrame(F); F.n := 0; F.win := NIL;
		F.hMenu := User32.CreateMenu(); ASSERT(F.hMenu # Kernel32.NULL);
		Kernel.RegisterObject(F, DestroyPopup, FALSE);
		F.handle := PopupHandler
	END InitPopup;

	PROCEDURE NewPopup*;
		VAR F: Popup;
	BEGIN
		NEW(F); InitPopup(F);
		Objects.NewObj := F	
	END NewPopup;

	PROCEDURE SetItemCaption(F: Item; str: ARRAY OF CHAR);
		VAR info: User32.MenuItemInfo;
	BEGIN
		info.cbSize := SIZE(User32.MenuItemInfo);
		info.fMask := {User32.MIIMType};
		info.fType := User32.MFString;
		info.fState := {};
		info.wID := F.id;
		info.hSubMenu := Kernel32.NULL;
		info.hbmpChecked := Kernel32.NULL;
		info.hbmpUnchecked := Kernel32.NULL;
		info.dwItemData := 0;
		info.dwTypeData := SYSTEM.ADR(str[0]);
		info.cch := Strings.Length(str);
		User32.SetMenuItemInfo(F.menu.hMenu, F.id, Kernel32.False, info)
	END SetItemCaption;

	PROCEDURE RestoreItem(F: Item);
		VAR popup: Popup;
	BEGIN
		popup := F.menu;
		WHILE (popup # NIL) & (popup.win = NIL) DO
			popup := popup.menu
		END;
		IF popup # NIL THEN
			User32.DrawMenuBar(popup.win.hWnd)
		END
	END RestoreItem;

	PROCEDURE FileItem(F: Item; VAR M: Objects.FileMsg);
		VAR obj: Objects.Object; caption: ARRAY 64 OF CHAR;
	BEGIN
		Gadgets.framehandle(F, M);
		IF M.id = Objects.store THEN
			Files.WriteLInt(M.R, F.pos);
			Files.WriteLInt(M.R, F.id);
			Gadgets.WriteRef(M.R, F.lib, F.menu);
			Files.WriteString(M.R, F.cmd);
			GetCaption(F, caption);
			Files.WriteString(M.R, caption)
		ELSIF M.id = Objects.load THEN
			Files.ReadLInt(M.R, F.pos);
			Files.ReadLInt(M.R, F.id);
			Gadgets.ReadRef(M.R, F.lib, obj);
			F.menu := obj(Popup);
			Files.ReadString(M.R, F.cmd);
			Files.ReadString(M.R, caption);
			IF caption = Separator THEN
				User32.InsertMenu(F.menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition, User32.MFSeparator}, F.id, NIL)
			ELSE
				User32.InsertMenu(F.menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition}, F.id, caption)
			END
		END
	END FileItem;

	PROCEDURE CopyItem(VAR M: Objects.CopyMsg; from, to: Item);
		VAR caption: ARRAY 64 OF CHAR;
	BEGIN
		Gadgets.CopyFrame(M, from, to);
		to.pos := from.pos; to.id := from.id;
		COPY(from.cmd, to.cmd);
		GetCaption(from, caption);
		M.obj := NIL; from.menu.handle(from.menu, M);
		to.menu := M.obj(Popup);
		IF caption = Separator THEN
			User32.InsertMenu(to.menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition, User32.MFSeparator}, to.id, NIL)
		ELSE
			User32.InsertMenu(to.menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition}, to.id, caption)
		END
	END CopyItem;

	PROCEDURE *ItemHandler(F: Objects.Object; VAR M: Objects.ObjMsg);
		VAR F1: Item;
	BEGIN
		WITH F: Item DO
			IF M IS Display.FrameMsg THEN
				WITH M: Display.FrameMsg DO
					IF (M.F = NIL) OR (M.F = F) THEN
						F.dlink := M.dlink; F.W := 0; F.H := 0;
						IF M IS LocateMsg THEN
							WITH M: LocateMsg DO
								IF M.id = F.id THEN M.item := F; M.res := 0 END
							END
						ELSIF M.F = F THEN
							IF M IS Display.DisplayMsg THEN
								RestoreItem(F)
							END;
							M.res := 0
						END
					END
				END
			ELSIF M IS Objects.AttrMsg THEN
				WITH M: Objects.AttrMsg DO
					IF M.id = Objects.get THEN
						IF M.name = "Gen" THEN
							M.class := Objects.String; M.s := "WinMenus.NewItem"; M.res := 0
						ELSIF M.name = "Caption" THEN
							M.class := Objects.String; GetCaption(F, M.s); M.res := 0
						ELSIF M.name = "Cmd" THEN
							M.class := Objects.String; COPY(F.cmd, M.s); M.res := 0
						ELSE
							Gadgets.framehandle(F, M)
						END
					ELSIF M.id = Objects.set THEN
						IF M.name = "Caption" THEN
							IF M.class = Objects.String THEN
								SetItemCaption(F, M.s); M.res := 0
							END
						ELSIF M.name = "Cmd" THEN
							IF M.class = Objects.String THEN
								COPY(M.s, F.cmd); M.res := 0
							END
						ELSE
							Gadgets.framehandle(F, M)
						END
					ELSIF M.id = Objects.enum THEN
						M.Enum("Caption"); M.Enum("Cmd"); Gadgets.framehandle(F, M)
					END
				END
			ELSIF M IS Objects.CopyMsg THEN
				WITH M: Objects.CopyMsg DO
					IF M.stamp = F.stamp THEN
						M.obj := F.dlink
					ELSE
						NEW(F1); F.stamp := M.stamp; F.dlink := F1;
						CopyItem(M, F, F1); M.obj := F1
					END
				END
			ELSIF M IS Objects.FileMsg THEN
				FileItem(F, M(Objects.FileMsg))
			ELSE
				Gadgets.framehandle(F, M)
			END
		END
	END ItemHandler;

	PROCEDURE InitItem(F: Item);
	BEGIN
		InitFrame(F); F.id := -1; F.cmd := "";
		F.handle := ItemHandler
	END InitItem;

	PROCEDURE NewItem*;
		VAR F: Item;
	BEGIN
		NEW(F); InitItem(F);
		Objects.NewObj := F	
	END NewItem;

	PROCEDURE [WINAPI] *WindowHandler(win: Windows.Window; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR
			hMenu: User32.HMenu; pos: User32.Point; menu: Objects.Object; L: LocateMsg; dialog: Dialog;
			done: BOOLEAN;
	BEGIN
		IF uMsg = User32.WMCommand THEN
			IF (ASH(wParam, -16) = 0) & (win.viewer # NIL) THEN
				L.id := wParam MOD ASH(1, 16);
				L.item := NIL; L.F := NIL; L.res := -1;
				win.viewer.handle(win.viewer, L);
				IF (L.res = 0) & (L.item # NIL) & (L.item.cmd # "") THEN
					done := Displays.PutCmd(win, L.item, L.item.cmd, 0)
				END
			END
		ELSIF uMsg = WMContextMenu THEN
			menu := SYSTEM.VAL(Popup, wParam);
			Attributes.GetInt(menu, "HMENU", hMenu);
			User32.GetCursorPos(pos);
			L.id := User32.TrackPopupMenu(hMenu, {User32.TPMNoNotify, User32.TPMReturnCmd}, pos.x, pos.y, 0, win.hWnd, NIL);
			L.F := NIL; L.item := NIL; L.res := -1;
			menu.handle(menu, L);
			IF (L.res = 0) & (L.item # NIL) THEN
				IF L.item.cmd # "" THEN
					done := Displays.PutCmd(win, win.viewer.dsc, L.item.cmd, 0)
				END;
				RETURN SYSTEM.VAL(User32.LResult, L.item)
			END
		ELSIF uMsg = WMDialog THEN
			dialog := SYSTEM.VAL(Dialog, wParam);
			IF dialog # NIL THEN
				Invoke(dialog, win)
			END
		ELSIF uMsg = COMDLG32.WMFindText THEN
			SYSTEM.GET(lParam+SIZE(COMDLG32.FindReplace), dialog);
			IF dialog # NIL THEN
				IF dialog IS FindTextDialog THEN
					DialogFindText(win, dialog(FindTextDialog))
				ELSIF dialog IS ReplaceTextDialog THEN
					DialogReplaceText(win, dialog(ReplaceTextDialog))
				END
			END
		ELSIF uMsg = User32.WMClose THEN
			IF (win.viewer # NIL) & (win.viewer.dsc # NIL) & (win.viewer.dsc IS Popup) THEN
				User32.SetMenu(win.hWnd, Kernel32.NULL)
			END
		END;
		RETURN 0
	END WindowHandler;

	PROCEDURE ShowPrintDialog(dialog: PrintDialog);
	BEGIN
		IF dialog.owner = NIL THEN
			dialog.print.hwndOwner := User32.HWNDDesktop
		ELSE
			dialog.print.hwndOwner := dialog.owner.hWnd
		END;
		dialog.done := COMDLG32.PrintDlg(dialog.print) # Kernel32.False
	END ShowPrintDialog;

	PROCEDURE ShowPageSetupDialog(dialog: PageSetupDialog);
	BEGIN
		IF dialog.owner = NIL THEN
			dialog.page.hwndOwner := User32.HWNDDesktop
		ELSE
			dialog.page.hwndOwner := dialog.owner.hWnd
		END;
		dialog.done := COMDLG32.PageSetupDlg(dialog.page) # Kernel32.False
	END ShowPageSetupDialog;

	PROCEDURE EmptyFilter*(VAR filter: ARRAY OF CHAR);
	BEGIN
		filter[0] := 0X; filter[1] := 0X
	END EmptyFilter;

	PROCEDURE AddFilter*(VAR filter: ARRAY OF CHAR; desc, pat: ARRAY OF CHAR);
		VAR i, j: LONGINT;
	BEGIN
		i := 0;
		WHILE (filter[i] # 0X) OR (filter[i+1] # 0X) DO
			INC(i)
		END;
		IF i > 0 THEN INC(i) END;
		j := 0;
		WHILE desc[j] # 0X DO
			filter[i] := desc[j]; INC(i); INC(j)
		END;
		filter[i] := 0X; INC(i);
		j := 0;
		WHILE pat[j] # 0X DO
			filter[i] := pat[j]; INC(i); INC(j)
		END;
		filter[i] := 0X; INC(i);
		filter[i] := 0X
	END AddFilter;

	PROCEDURE Invoke(dialog: Dialog; win: Displays.Display);
		VAR done: BOOLEAN;
	BEGIN
		IF dialog IS OpenFileNameDialog THEN
			ShowOpenFileNameDialog(dialog(OpenFileNameDialog))
		ELSIF dialog IS SaveFileNameDialog THEN
			ShowSaveFileNameDialog(dialog(SaveFileNameDialog))
		ELSIF dialog IS FindTextDialog THEN
			ShowFindTextDialog(dialog(FindTextDialog))
		ELSIF dialog IS ReplaceTextDialog THEN
			ShowReplaceTextDialog(dialog(ReplaceTextDialog))
		ELSIF dialog IS PrintDialog THEN
			ShowPrintDialog(dialog(PrintDialog))
		ELSIF dialog IS PageSetupDialog THEN
			ShowPageSetupDialog(dialog(PageSetupDialog))
		END;
		IF dialog.cmd # "" THEN
			done := Displays.PutCmd(win, dialog, dialog.cmd, 0)
		END
	END Invoke;

	PROCEDURE ShowDialog*(dialog: Dialog; block: BOOLEAN);
	BEGIN
		IF dialog.owner = NIL THEN
		(*
			IF block & (dialog.owner = NIL) THEN
				Invoke(dialog, Displays.desktop); RETURN
			ELSIF (Display.cur # NIL) & (Display.cur IS Windows.Window) THEN
				dialog.owner := Display.cur(Windows.Window)
			END
		*)
			IF (Display.cur # NIL) & (Display.cur IS Windows.Window) THEN
				dialog.owner := Display.cur(Windows.Window)
			ELSIF block & (dialog.owner = NIL) THEN
				Invoke(dialog, Displays.desktop); RETURN
			END
		END;
		IF block THEN
			User32.SendMessage(dialog.owner.hWnd, WMDialog, SYSTEM.VAL(User32.WParam, dialog), 0)
		ELSE
			User32.PostMessage(dialog.owner.hWnd, WMDialog, SYSTEM.VAL(User32.WParam, dialog), 0)
		END
	END ShowDialog;

	PROCEDURE CloseDialog*(dialog: Dialog);
	BEGIN
		ASSERT(dialog.hwnd # Kernel32.NULL);
		User32.DestroyWindow(dialog.hwnd);
		dialog.hwnd := Kernel32.NULL	
	END CloseDialog;

	PROCEDURE ShowOpenFileNameDialog(dialog: OpenFileNameDialog);
		VAR open: COMDLG32.OpenFileName; work: FileDir.FileName;
	BEGIN
		FileDir.ConvertChar(dialog.name, FileDir.PathChar, "\");
		open.lStructSize := SIZE(COMDLG32.OpenFileName);
		open.hwndOwner := dialog.owner.hWndParent;
		open.hInstance := Kernel32.NULL;
		open.lpstrFilter := SYSTEM.ADR(dialog.filter[0]);
		open.lpstrCustomFilter := Kernel32.NULL;
		open.nMaxCustFilter := 0;
		open.nFilterIndex := 0;
		open.lpstrFile := SYSTEM.ADR(dialog.name[0]);
		open.nMaxFile := LEN(dialog.name);
		open.lpstrFileTitle := Kernel32.NULL;
		open.nMaxFileTitle := 0;
		open.lpstrInitialDir := Kernel32.NULL;
		open.lpstrTitle := Kernel32.NULL;
		open.Flags := {};
		open.nFileOffset := 0;
		open.nFileExtension := 0;
		open.lpstrDefExt := Kernel32.NULL;
		open.lCustData := 0;
		open.lpfnHook := Kernel32.NULL;
		open.lpTemplateName := Kernel32.NULL;
		Kernel32.GetCurrentDirectory(LEN(work), work);
		IF COMDLG32.GetOpenFileName(open) # Kernel32.False THEN
			FileDir.ConvertChar(dialog.name, "\", FileDir.PathChar)
		ELSE
			COPY("", dialog.name)
		END;
		Kernel32.SetCurrentDirectory(work)
	END ShowOpenFileNameDialog;

	PROCEDURE DialogOpen*;
		VAR D, new: Documents.Document; dialog: OpenFileNameDialog;
	BEGIN
		IF (Oberon.Par.obj # NIL) & (Oberon.Par.obj IS OpenFileNameDialog) THEN
			dialog := Oberon.Par.obj(OpenFileNameDialog);
			IF dialog.name # "" THEN
				D := Desktops.CurDoc(Gadgets.context);
				new := Documents.Open(dialog.name);
				IF (new # NIL) & (new.dsc # NIL) THEN
					IF (D # NIL) & (D = SYSTEM.VAL(Documents.Document, dialog.context)) THEN
						Desktops.ReplaceCurrentDoc(new)
					ELSE
						Desktops.ShowDoc(new)
					END
				END
			END
		END
	END DialogOpen;

	(** Uses the "Open" standard dialog to replace the current document by a new one. *)
	PROCEDURE Open*;
		VAR D: Documents.Document; dialog: OpenFileNameDialog;
	BEGIN
		D := Desktops.CurDoc(Gadgets.context);
		IF D # NIL THEN
			NEW(dialog); dialog.context := D; dialog.owner := NIL;
			dialog.cmd := "WinMenus.DialogOpen";
			COPY(D.name, dialog.name);
			EmptyFilter(dialog.filter); AddFilter(dialog.filter, "ETHOberon Document", "*.*");
			ShowDialog(dialog, FALSE)
		END
	END Open;

	PROCEDURE ShowSaveFileNameDialog(dialog: SaveFileNameDialog);
		VAR open: COMDLG32.OpenFileName; work: FileDir.FileName;
	BEGIN
		IF FileDir.CheckName(dialog.name) THEN		
			FileDir.ConvertChar(dialog.name, FileDir.PathChar, "\")
		ELSE
			dialog.name := ""
		END;
		EmptyFilter(dialog.filter); AddFilter(dialog.filter, "ETHOberon Document", "*.*");
		open.lStructSize := SIZE(COMDLG32.OpenFileName);
		open.hwndOwner := dialog.owner.hWnd;
		open.hInstance := Kernel32.NULL;
		open.lpstrFilter := SYSTEM.ADR(dialog.filter[0]);
		open.lpstrCustomFilter := Kernel32.NULL;
		open.nMaxCustFilter := 0;
		open.nFilterIndex := 0;
		open.lpstrFile := SYSTEM.ADR(dialog.name[0]);
		open.nMaxFile := LEN(dialog.name);
		open.lpstrFileTitle := Kernel32.NULL;
		open.nMaxFileTitle := 0;
		open.lpstrInitialDir := Kernel32.NULL;
		open.lpstrTitle := Kernel32.NULL;
		open.Flags := {};
		open.nFileOffset := 0;
		open.nFileExtension := 0;
		open.lpstrDefExt := Kernel32.NULL;
		open.lCustData := 0;
		open.lpfnHook := Kernel32.NULL;
		open.lpTemplateName := Kernel32.NULL;
		Kernel32.GetCurrentDirectory(LEN(work), work);
		IF COMDLG32.GetSaveFileName(open) # Kernel32.False THEN
			FileDir.ConvertChar(dialog.name, "\", FileDir.PathChar)
		ELSE
			dialog.name := ""
		END;
		Kernel32.SetCurrentDirectory(work)
	END ShowSaveFileNameDialog;

	PROCEDURE DialogSaveAs*;
		VAR D: Documents.Document; dialog: SaveFileNameDialog; M: Desktops.UpdateNameMsg;
	BEGIN
		IF (Oberon.Par.obj # NIL) & (Oberon.Par.obj IS SaveFileNameDialog) THEN
			dialog := Oberon.Par.obj(SaveFileNameDialog);
			IF dialog.name # ""  THEN
				D := dialog.context(Documents.Document);
				COPY(dialog.name, D.name);
				M.F := NIL; M.obj := D; Display.Broadcast(M);
				Desktops.StoreThisDoc(D)
			END
		END
	END DialogSaveAs;

	(** Uses the "Save As" standard dialog to store the current document under a new name. *)
	PROCEDURE SaveAs*;
		VAR D: Documents.Document; dialog: SaveFileNameDialog;
	BEGIN
		D := Desktops.CurDoc(Gadgets.context);
		IF D # NIL THEN
			NEW(dialog); dialog.context := D; dialog.owner := NIL;
			dialog.cmd := "WinMenus.DialogSaveAs";
			COPY(D.name, dialog.name);
			ShowDialog(dialog, FALSE)
		END
	END SaveAs;

	PROCEDURE ShowFindTextDialog(dialog: FindTextDialog);
	BEGIN
		dialog.fr.lStructSize := SIZE(COMDLG32.FindReplace);
		dialog.fr.hwndOwner := dialog.owner.hWnd;
		dialog.fr.hInstance := Kernel32.NULL;
		dialog.fr.Flags := {COMDLG32.FRHideUpDown, COMDLG32.FRHideMatchCase, COMDLG32.FRHideWholeWord};
		dialog.fr.lpstrFindWhat := SYSTEM.ADR(dialog.find[0]);
		dialog.fr.lpstrReplaceWith := Kernel32.NULL;
		dialog.fr.wFindWhatLen := LEN(dialog.find);
		dialog.fr.wReplaceWithLen := 0;
		dialog.fr.lCustData := 0;
		dialog.fr.lpfnHook := Kernel32.NULL;
		dialog.fr.lpTemplateName := Kernel32.NULL;
		dialog.hwnd := COMDLG32.FindText(dialog.fr)
	END ShowFindTextDialog;

	PROCEDURE ShowReplaceTextDialog(dialog: ReplaceTextDialog);
	BEGIN
		dialog.fr.lStructSize := SIZE(COMDLG32.FindReplace);
		dialog.fr.hwndOwner := dialog.owner.hWnd;
		dialog.fr.hInstance := Kernel32.NULL;
		dialog.fr.Flags := {COMDLG32.FRHideUpDown, COMDLG32.FRHideMatchCase, COMDLG32.FRHideWholeWord};
		dialog.fr.lpstrFindWhat := SYSTEM.ADR(dialog.find[0]);
		dialog.fr.lpstrReplaceWith := SYSTEM.ADR(dialog.replace[0]);
		dialog.fr.wFindWhatLen := LEN(dialog.find);
		dialog.fr.wReplaceWithLen := LEN(dialog.replace);
		dialog.fr.lCustData := 0;
		dialog.fr.lpfnHook := Kernel32.NULL;
		dialog.fr.lpTemplateName := Kernel32.NULL;
		dialog.hwnd := COMDLG32.ReplaceText(dialog.fr)
	END ShowReplaceTextDialog;

	PROCEDURE DialogFindText(win: Displays.Display; dialog: FindTextDialog);
		VAR cmd: ARRAY 300 OF CHAR; F: Display.Frame;
	BEGIN
		IF COMDLG32.FRFindNext IN dialog.fr.Flags THEN
			Kernel32.CopyString(dialog.fr.lpstrFindWhat, dialog.find);
			IF dialog.find # "" THEN
				cmd := "TextDocs.Search '"; Strings.Append(cmd, dialog.find); Strings.AppendCh(cmd, "'");
				F := dialog.context(Display.Frame); Oberon.execute(F, cmd)
			END
		END
	END DialogFindText;

	PROCEDURE FindText*;
		VAR dialog: FindTextDialog;
	BEGIN
		NEW(dialog); dialog.context := Gadgets.executorObj; dialog.owner := NIL;
		dialog.self := dialog; dialog.cmd := ""; dialog.find := "";
		ShowDialog(dialog, FALSE)
	END FindText;

	PROCEDURE DialogReplaceText(win: Displays.Display; dialog: ReplaceTextDialog);
		VAR cmd: ARRAY 600 OF CHAR; F: Display.Frame;
	BEGIN
		IF ({COMDLG32.FRReplace, COMDLG32.FRReplaceAll} * dialog.fr.Flags) # {} THEN
			Kernel32.CopyString(dialog.fr.lpstrFindWhat, dialog.find);
			Kernel32.CopyString(dialog.fr.lpstrReplaceWith, dialog.replace);
			IF dialog.find # "" THEN
				IF COMDLG32.FRReplaceAll IN dialog.fr.Flags THEN
					cmd := "TextDocs.ReplaceAll '"
				ELSE
					cmd := "TextDocs.Replace '"
				END;
				Strings.Append(cmd, dialog.find); Strings.Append(cmd, "' '");
				Strings.Append(cmd, dialog.replace); Strings.AppendCh(cmd, "'");
				F := dialog.context(Display.Frame); Oberon.execute(F, cmd)
			END
		ELSIF COMDLG32.FRFindNext IN dialog.fr.Flags THEN
			Kernel32.CopyString(dialog.fr.lpstrFindWhat, dialog.find);
			IF dialog.find # "" THEN
				cmd := "TextDocs.Search '"; Strings.Append(cmd, dialog.find); Strings.AppendCh(cmd, "'");
				F := dialog.context(Display.Frame); Oberon.execute(F, cmd)
			END
		END
	END DialogReplaceText;

	PROCEDURE ReplaceText*;
		VAR dialog: ReplaceTextDialog;
	BEGIN
		NEW(dialog); dialog.context := Gadgets.executorObj; dialog.owner := NIL;
		dialog.self := dialog; dialog.cmd := ""; dialog.find := ""; dialog.replace := "";
		ShowDialog(dialog, FALSE)
	END ReplaceText;

	(** Command used by the control windows context menu. *)
	PROCEDURE Select*;
		VAR M: Display.SelectMsg; F: Objects.Object;
	BEGIN
		F := Gadgets.executorObj;
		WITH F: Display.Frame DO
			M.F := F; M.id := Display.set; M.time := -1;
			M.sel := NIL; M.obj := NIL;
			Display.Broadcast(M); Gadgets.Update(F)
		END
	END Select;

	(** Command used by the control windows context menu. *)
	PROCEDURE Inspect*;
		VAR M: Display.SelectMsg; F: Objects.Object; sel: BOOLEAN;
	BEGIN
		F := Gadgets.executorObj;
		WITH F: Gadgets.Frame DO
			sel := Gadgets.selected IN F.state;
			IF ~sel THEN
				M.F := F; M.id := Display.set; M.time := -1;
				M.sel := NIL; M.obj := NIL
			END;
			Display.Broadcast(M);
			Gadgets.Execute("Columbus.Inspect", F, F.dlink, NIL, NIL);
			IF ~sel THEN
				M.F := F; M.id := Display.reset;
				Display.Broadcast(M)
			END
		END
	END Inspect;

	(** Command used to log a documents name. *)
	PROCEDURE DocName*;
		VAR doc: Documents.Document; W: Texts.Writer;
	BEGIN
		doc := Desktops.CurDoc(Gadgets.context);
		IF doc # NIL THEN
			Texts.OpenWriter(W);
			Texts.Write(W, 022X); Texts.WriteString(W, doc.name); Texts.Write(W, 022X);
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
		END
	END DocName;

	(** Displays a context menu. *)
	PROCEDURE ContextMenu*(win: Windows.Window; menu: Objects.Object): Objects.Object;
		VAR ret: User32.LResult;
	BEGIN
		ret := User32.SendMessage(win.hWnd, WMContextMenu, SYSTEM.VAL(User32.WParam, menu), 0);
		RETURN SYSTEM.VAL(Objects.Object, ret)
	END ContextMenu;

(** create a new empty menu bar *)
PROCEDURE NewMenu*(): Popup;
	VAR F: Popup;
BEGIN
	NEW(F); InitPopup(F);
	RETURN F
END NewMenu;

PROCEDURE AppendFrame(menu: Popup; F: Frame);
	VAR f: Display.Frame;
BEGIN
	f := menu.dsc;
	WHILE (f # NIL) & (f.next # NIL) DO
		f := f.next
	END;
	IF f # NIL THEN
		f.next := F; F.pos := f(Frame).pos+1
	ELSE
		menu.dsc := F; F.pos := 0
	END
END AppendFrame;

(** append a a sub-menu to menu *)
PROCEDURE AppendMenu*(menu: Popup; caption: ARRAY OF CHAR): Popup;
	VAR F: Popup; f: Popup;
BEGIN
	NEW(F); InitPopup(F); F.menu := menu;
	f := menu;
	WHILE f # NIL DO
		INC(f.n); f := f.menu
	END;
	User32.InsertMenu(menu.hMenu, 0FFFFFFFFH, {User32.MFPopup, User32.MFByPosition}, F.hMenu, caption);
	AppendFrame(menu, F);
	RETURN F
END AppendMenu;

(** append a new leaf item to menu *)
PROCEDURE AppendItem*(menu: Popup; caption, cmd: ARRAY OF CHAR);
	VAR F: Item; f: Popup;
BEGIN
	NEW(F); InitItem(F); F.menu := menu;
	COPY(cmd, F.cmd);
	f := menu;
	WHILE f # NIL DO
		INC(f.n); F.id := Windows.IDFirstMenuCmd+f.n; f := f.menu
	END;
	IF caption = Separator THEN
		User32.InsertMenu(menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition, User32.MFSeparator}, F.id, NIL)
	ELSE
		User32.InsertMenu(menu.hMenu, 0FFFFFFFFH, {User32.MFByPosition}, F.id, caption)
	END;
	AppendFrame(menu, F)
END AppendItem;

PROCEDURE DocMenu(menu: Popup; store: BOOLEAN);
	VAR subMenu, subSubMenu: Popup;
BEGIN
	subMenu := AppendMenu(menu, "&File");
	subSubMenu := AppendMenu(subMenu, "&New");
	AppendItem(subSubMenu, "Text", "Desktops.OpenDoc (TextDocs.NewDoc)");
	AppendItem(subSubMenu, "Panel", "Desktops.OpenDoc (PanelDocs.NewDoc)");
	AppendItem(subSubMenu, "Pict", "Desktops.OpenDoc (RembrandtDocs.NewDoc)");
	AppendItem(subSubMenu, "Log", "Desktops.OpenDoc (TextDocs.NewLog)");
	AppendItem(subSubMenu, "Columbus", "Desktops.OpenDoc (Columbus.NewDoc)");
	AppendItem(subMenu, "&Open...", "WinMenus.Open");
	IF store THEN
		AppendItem(subMenu, "&Save", "Desktops.StoreDoc");
		AppendItem(subMenu, "Save &As...", "WinMenus.SaveAs")
	END;
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Page Set&up...", "WinPrinter.Setup");
	AppendItem(subMenu, "&Print...", "Desktops.PrintDoc Default");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Copy", "Desktops.Copy");
	AppendItem(subMenu, "Name", "WinMenus.DocName");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Close", "Desktops.CloseDoc")
END DocMenu;

PROCEDURE TextEdit(menu: Popup);
	VAR subMenu: Popup;
BEGIN
	subMenu := AppendMenu(menu, "&Edit");
	AppendItem(subMenu, "Recall", "TextDocs.Recall");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Cu&t", "Clipboard.Cut");
	AppendItem(subMenu, "&Copy", "Clipboard.Copy");
	AppendItem(subMenu, "&Paste", "Clipboard.Paste");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Find...", "WinMenus.FindText");
	AppendItem(subMenu, "Find && Replace...", "WinMenus.ReplaceText");
	AppendItem(subMenu, "---", "");
	(* AppendItem(subMenu, "Select &All", "EditTools.SelectAll"); *)
	AppendItem(subMenu, "Left", "TextDocs.Left");
	AppendItem(subMenu, "Right", "TextDocs.Right");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Search", "TextDocs.Search");
	AppendItem(subMenu, "Search Diff", "TextDocs.SearchDiff");
	AppendItem(subMenu, "Replace", "TextDocs.Replace");
	AppendItem(subMenu, "Replace All", "TextDocs.ReplaceAll");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Controls", "TextDocs.Controls")
END TextEdit;

PROCEDURE TextFormat(menu: Popup);
	VAR subMenu, subSubMenu: Popup;
BEGIN
	subMenu := AppendMenu(menu, "&F&ormat");
	AppendItem(subMenu, "Show", "EditTools.ShowAttrs");
	subSubMenu := AppendMenu(subMenu, "Family");
	AppendItem(subSubMenu, "Courier", "EditTools.ChangeFamily ? => Courier");
	AppendItem(subSubMenu, "Default", "EditTools.ChangeFamily ? => Default");
	AppendItem(subSubMenu, "Greek", "EditTools.ChangeFamily ? => Greek");
	AppendItem(subSubMenu, "Math", "EditTools.ChangeFamily ? => Math");
	AppendItem(subSubMenu, "Oberon", "EditTools.ChangeFamily ? => Oberon");
	AppendItem(subSubMenu, "Syntax", "EditTools.ChangeFamily ? => Syntax");
	(* AppendItem(subSubMenu, "True Type...", "choose font dialog"); *)
	subSubMenu := AppendMenu(subMenu, "Style");
	AppendItem(subSubMenu, "Normal", "EditTools.ChangeStyle ?  => .");
	AppendItem(subSubMenu, "Italic", "EditTools.ChangeStyle ?  => i");
	AppendItem(subSubMenu, "Medium", "EditTools.ChangeStyle ?  => m");
	AppendItem(subSubMenu, "Bold", "EditTools.ChangeStyle ?  => b");
	subSubMenu := AppendMenu(subMenu, "Size");
	AppendItem(subSubMenu, "8", "EditTools.ChangeSize ?  => 8");
	AppendItem(subSubMenu, "10", "EditTools.ChangeSize ?  => 10");
	AppendItem(subSubMenu, "12", "EditTools.ChangeSize ?  => 12");
	AppendItem(subSubMenu, "14", "EditTools.ChangeSize ?  => 14");
	AppendItem(subSubMenu, "16", "EditTools.ChangeSize ?  => 16");
	AppendItem(subSubMenu, "20", "EditTools.ChangeSize ?  => 20");
	AppendItem(subSubMenu, "24", "EditTools.ChangeSize ?  => 24");
	AppendItem(subSubMenu, "---", "");
	AppendItem(subSubMenu, "Size + 2", "EditTools.IncSize 2");
	AppendItem(subSubMenu, "Size - 2", "EditTools.IncSize -2");
	(* AppendItem(subMenu, "Color...", "choose color dialog"); *)
	subSubMenu := AppendMenu(subMenu, "Offset");
	AppendItem(subSubMenu, "-4", "EditTools.ChangeVoff ?  => -4");
	AppendItem(subSubMenu, "-3", "EditTools.ChangeVoff ?  => -3");
	AppendItem(subSubMenu, "-2", "EditTools.ChangeVoff ?  => -2");
	AppendItem(subSubMenu, "-1", "EditTools.ChangeVoff ?  => -1");
	AppendItem(subSubMenu, "0", "EditTools.ChangeVoff ?  => 0");
	AppendItem(subSubMenu, "1", "EditTools.ChangeVoff ?  => 1");
	AppendItem(subSubMenu, "2", "EditTools.ChangeVoff ?  => 2");
	AppendItem(subSubMenu, "3", "EditTools.ChangeVoff ?  => 3");
	AppendItem(subSubMenu, "4", "EditTools.ChangeVoff ?  => 4");
	AppendItem(subSubMenu, "---", "");
	AppendItem(subSubMenu, "Voff + 1", "EditTools.IncVoff 1");
	AppendItem(subSubMenu, "Voff - 1", "EditTools.IncVoff -1");
	subSubMenu := AppendMenu(subMenu, "Case");
	AppendItem(subSubMenu, "Upper", "EditTools.Upper");
	AppendItem(subSubMenu, "Lower", "EditTools.Lower");
	AppendItem(subSubMenu, "Flip", "EditTools.FlipCase")
END TextFormat;

(** Create the standard menus for:
	TextDocs.NewDoc, TextDocs.NewLog, PanelDocs.NewDoc, RembrandtDocs.NewDoc,
	Columbus.NewDoc, Watson.NewDoc, Compress.NewDoc, TelnetGadgets.NewDoc,
	HTMLDocs, ContextMenu *)
PROCEDURE CreateStdMenus*;
	VAR
		menu, subMenu: Popup;
		F: Files.File;
		L: Objects.Library;
		B: Objects.BindMsg;
		len: LONGINT;
BEGIN
	F := Files.New("WinMenus.Lib");
	NEW(L); Objects.OpenLibrary(L);
(* TextDocs.NewDoc*)
	menu := NewMenu(); DocMenu(menu, TRUE);
	TextEdit(menu);
	TextFormat(menu);
	subMenu := AppendMenu(menu, "Ascii");
	AppendItem(subMenu, "Store Ascii", "EditTools.StoreAscii");
	AppendItem(subMenu, "Store Unicode", "EditTools.StoreUnicode");
	AppendItem(subMenu, "Store Unix", "EditTools.StoreUnix");
	AppendItem(subMenu, "Store Mac", "EditTools.StoreMac");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "TextDocs.NewDoc");
	Objects.PutName(L.dict, menu.ref, "TextDocs.NewDoc");
(* TextDocs.NewLog *)
	menu := NewMenu(); DocMenu(menu, TRUE);
	TextEdit(menu);
	subMenu := AppendMenu(menu, "Log");
	AppendItem(subMenu, "Clear", "System.Clear");
	AppendItem(subMenu, "Locate", "TextDocs.Locate");
	AppendItem(subMenu, "Locate Line", "EditTools.LocateLine");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "TextDocs.NewLog");
	Objects.PutName(L.dict, menu.ref, "TextDocs.NewLog");
(* PanelDocs.NewDoc *)
	menu := NewMenu(); DocMenu(menu, TRUE);
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "PanelDocs.NewDoc");
	Objects.PutName(L.dict, menu.ref, "PanelDocs.NewDoc");
(* RembrandtDocs.NewDoc *)
	menu := NewMenu(); DocMenu(menu, TRUE);
	AppendItem(menu, "Zoom In", "RembrandtDocs.Inc");
	AppendItem(menu, "Zoom Out", "RembrandtDocs.Dec");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "RembrandtDocs.NewDoc");
	Objects.PutName(L.dict, menu.ref, "RembrandtDocs.NewDoc");
(* Columbus.NewDoc *)
	menu := NewMenu(); DocMenu(menu, FALSE);
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "Columbus.NewDoc");
	Objects.PutName(L.dict, menu.ref, "Columbus.NewDoc");
(* Watson.NewDoc *)
	menu := NewMenu(); DocMenu(menu, FALSE);
	subMenu := AppendMenu(menu, "&Edit");
	AppendItem(subMenu, "&Copy", "Clipboard.Copy");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "&Find", "TextDocs.Search");
	AppendItem(menu, "Back", "Watson.Back");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "Watson.NewDoc");
	Objects.PutName(L.dict, menu.ref, "Watson.NewDoc");
(* Compress.NewDoc *)
	menu := NewMenu(); DocMenu(menu, FALSE);
	subMenu := AppendMenu(menu, "&Edit");
	AppendItem(subMenu, "&Copy", "Clipboard.Copy");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "&Find", "TextDocs.Search");
	subMenu := AppendMenu(menu, "Compress");
	AppendItem(subMenu, "Open", "Compress.Open");
	AppendItem(subMenu, "Add", "Compress.Add");
	AppendItem(subMenu, "Extract", "Compress.Extract");
	AppendItem(subMenu, "Delete", "Compress.Delete");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "Compress.NewDoc");
	Objects.PutName(L.dict, menu.ref, "Compress.NewDoc");
(* TelnetGadgets.NewDoc *)
	menu := NewMenu(); DocMenu(menu, FALSE);
	subMenu := AppendMenu(menu, "&Edit");
	AppendItem(subMenu, "&Copy", "Clipboard.Copy");
	subMenu := AppendMenu(menu, "Telnet");
	AppendItem(subMenu, "Disconnect", "TelnetGadgets.CloseCon");
	AppendItem(subMenu, "Log", "TelnetGadgets.OpenLog");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "TelnetGadgets.NewDoc");
	Objects.PutName(L.dict, menu.ref, "TelnetGadgets.NewDoc");
(* HTMLDocs.NewDoc*)
	menu := NewMenu(); DocMenu(menu, TRUE);
	TextEdit(menu);
	AppendItem(menu, "Back", "HyperDocs.Back");
	AppendItem(menu, "Reload", "HyperDocs.Reload");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(menu, "TextDocs.NewDoc");
	Objects.PutName(L.dict, menu.ref, "HTMLDocs.NewDoc");
(* ContextMenu *)
	menu := NewMenu(); subMenu := AppendMenu(menu, "");
	AppendItem(subMenu, "Select", "WinMenus.Select");
	AppendItem(subMenu, "Neutralize", "Oberon.Neutralize");
	AppendItem(subMenu, "Refresh", "Oberon.RefreshDisplay");
	AppendItem(subMenu, "Inspect", "WinMenus.Inspect");
	AppendItem(subMenu, "Oberon.Log", "System.OpenLog");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(subMenu, "ContextMenu");
	Objects.PutName(L.dict, subMenu.ref, "ContextMenu");
(* DropMenu *)
	menu := NewMenu(); subMenu := AppendMenu(menu, "");
	AppendItem(subMenu, "Copy", "");
	AppendItem(subMenu, "Move", "");
	AppendItem(subMenu, "Data", "");
	AppendItem(subMenu, "Link", "");
	AppendItem(subMenu, "Cancel", "");
	B.lib := L; menu.handle(menu, B);
	Gadgets.NameObj(subMenu, "DropMenu");
	Objects.PutName(L.dict, subMenu.ref, "DropMenu");
	Objects.StoreLibrary(L, F, 0, len);
	Files.Register(F)
END CreateStdMenus;

PROCEDURE NewDocMenu*(menubar: ARRAY OF CHAR): Display.Frame;
	VAR cmd, title: ARRAY 64 OF CHAR; i: LONGINT; menu: Popup;
	PROCEDURE GetString(VAR s: ARRAY OF CHAR);
		VAR term: CHAR; j: LONGINT;
	BEGIN
		WHILE menubar[i] = " " DO INC(i) END;
		IF menubar[i] = "'" THEN
			INC(i); term := "'"
		ELSIF menubar[i] = "[" THEN
			INC(i); term := "]"
		ELSE
			term := 0X
		END;
		j := 0;
		IF term = 0X THEN
			WHILE (menubar[i] # 0X) & (menubar[i] # " ") & (menubar[i] # "[") & (menubar[i] # "'") DO
				s[j] := menubar[i]; INC(i); INC(j)
			END;
			WHILE menubar[i] = " " DO INC(i) END;
			IF menubar[i] = "^" THEN
				s[j] := " "; INC(j); s[j] := "^"; INC(j); INC(i)
			END
		ELSE
			WHILE (menubar[i] # 0X) & (menubar[i] # term) DO
				s[j] := menubar[i]; INC(i); INC(j)
			END;
			IF menubar[i] = term THEN INC(i) END
		END;
		s[j] := 0X
	END GetString;

	PROCEDURE GenTitle(VAR cmd, title: ARRAY OF CHAR);
		VAR j, k: LONGINT;
	BEGIN
		j := 0; WHILE (cmd[j] # ".") & (cmd[j] # 0X) & (cmd[j] # " ") DO INC(j) END;
		IF cmd[j] = "." THEN
			k := 0; INC(j);
			WHILE (cmd[j] # 0X) & (cmd[j] # " ") DO title[k] := cmd[j]; INC(k); INC(j) END;
			title[k] := 0X
		ELSE
			COPY(cmd, title)
		END
	END GenTitle;

BEGIN
	menu := NewMenu(); (*DocMenu(menu, TRUE);*)
	i := 0;
	WHILE menubar[i] # 0X DO
		GetString(cmd);
		IF menubar[i] = "[" THEN
			GetString(title)
		ELSE
			GenTitle(cmd, title)
		END;
		AppendItem(menu, title, cmd)
	END;
	RETURN menu
END NewDocMenu;

	PROCEDURE Init();
	BEGIN
		Windows.RegisterWindowHandler(WindowHandler, User32.WMCommand);
		Windows.RegisterWindowHandler(WindowHandler, WMContextMenu);
		Windows.RegisterWindowHandler(WindowHandler, WMDialog);
		Windows.RegisterWindowHandler(WindowHandler, COMDLG32.WMFindText);
		Desktops.newWinMenu := NewDocMenu
	END Init;

	PROCEDURE *Term();
	BEGIN
		Windows.UnregisterWindowHandler(WindowHandler)
	END Term;

BEGIN
	Init(); Modules.InstallTermHandler(Term)
END WinMenus.

(** Example:
	VAR menu, subMenu, subSubMenu: Popup;
BEGIN
	menu := NewMenu();
	subMenu := AppendMenu(menu, "&File");
	subSubMenu := AppendMenu(subMenu, "&New");
	AppendItem(subSubMenu, "Text", "Desktops.OpenDoc (TextDocs.NewDoc)");
	AppendItem(subSubMenu, "Panel", "Desktops.OpenDoc (PanelDocs.NewDoc)");
	AppendItem(subSubMenu, "Pict", "Desktops.OpenDoc (RembrandtDocs.NewDoc)");
	AppendItem(subSubMenu, "Log", "Desktops.OpenDoc (TextDocs.NewLog)");
	AppendItem(subSubMenu, "Columbus", "Desktops.OpenDoc (Columbus.NewDoc)");
	AppendItem(subMenu, "&Open...", "WinMenus.Open");
	AppendItem(subMenu, "&Save", "Desktops.StoreDoc");
	AppendItem(subMenu, "Save &As...", "WinMenus.SaveAs");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Page Set&up...", "WinPrinter.Setup");
	AppendItem(subMenu, "&Print...", "Desktops.PrintDoc Default");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Copy", "Desktops.Copy");
	AppendItem(subMenu, "Name", "WinMenus.DocName");
	AppendItem(subMenu, "---", "");
	AppendItem(subMenu, "Close", "Desktops.CloseDoc") *)

WinMenus.CreateStdMenus

System.RenameFiles WinMenus.Lib => ../System/WinMenus.Lib ~
BIER     E    <       g 
     C  Syntax10.Scn.Fnt 30.07.2004  19:41:48  TimeStamps.New  