TextDocs.NewDoc     &   CWindowsLeft i  WindowsRight d  WindowsTop !   WindowsButtom   Color    Flat  Locked  Controls Org  =   BIER           3  L  Syntax10.Scn.Fnt  /   Oberon10.Scn.Fnt      G         	       5          !        9                                                %                   w                             G               9     (* Copyright (c) 1994 - 2000 Emil J. Zeller *)

MODULE Windows; (** non-portable / source: Win32.Windows.Mod *)	(* ejz   *)
	IMPORT SYSTEM, Kernel32, Kernel, Registry, FileDir, Modules, Objects, User32, Displays, Display, Threads,
		Viewers, Input, Strings, Exceptions;

	(** This module implements Displays working in Windows document or control windows. *)

	CONST
		WMSetup = User32.WMUser+1; WMCreateWindow = User32.WMUser+2;
		(* Windows, WinMenus: User32.WMUser .. User32.WMUser+9
			NetSystem: User32.WMUser+10 .. User32.WMUser+19
			NPPlugIns: User32.WMUser+20 .. User32.WMUser+29
			OLE*: User32.WMUser+30 .. User32.WMUser+39 *)
		IDFirstAccelCmd = 0; (* addAccel *)
		IDFirstMenuCmd* = 64; (** first ID to be used by menus (see: WinMenus) *)
		Insert = 0A0X; Delete = 0A1X; Backspace = 07FX;
		Home = 0A8X; End = 0A9X;
		PageUp = 0A2X; PageDown = 0A3X;
		Up = 0C1X; Down = 0C2X; Right = 0C3X; Left = 0C4X; (* cursor keys *)
		F1 = 0A4X; F2 = 0A5X; F3 = 0A6X; F4 = 0A7X; F5 = 0F5X;
		F6 = 0F6X; F7 = 0F7X; F8 = 0F8X; F9 = 0F9X; F10 = 0FAX;
		F11 = 0FBX; F12 = 0FCX;
		update = 0; dummy = 1; minimized = 2; external = 3; control = 4;
		MaxAccel = 32; MaxCmd = 128;
		ML = 2; MM = 1; MR = 0; MX = 3;
		GWLWindow* = 0; GWLControl* = 4;

	TYPE
		Window* = POINTER TO RECORD (Viewers.Window)
			defWindowProc*: User32.WndProc;	(** default window procedure for all messages not handled here *)
			windowRect: User32.Rect;
			state: SET (* update, dummy, minimized, external, control *)
		END;

		CreateStruct = POINTER TO RECORD
			win: Window;
			event: Threads.Event;
			className: ARRAY 32 OF CHAR;
			exstyle, style: SET;
			x, y, w, h: LONGINT;
			hMenu: User32.HMenu
		END;

		(** handler called for registered window messages *)
		WindowHandlerProc* = PROCEDURE [WINAPI] (win: Window; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;

		WindowHandlerList = POINTER TO RECORD
			uMsg: LONGINT; handler: WindowHandlerProc;
			next: WindowHandlerList
		END;

	VAR
		dummyClass, windowClass, controlClass: User32.WndClassEx;
		dummyClassName, windowClassName, controlClassName: ARRAY 32 OF CHAR;
		nWindows: LONGINT; aControlWinClass: LONGINT;
		winMain: Threads.Thread; createWin: CreateStruct;
		fixedFrameX, fixedFrameY, frameX, frameY, captionY, menuY: LONGINT;
		windowHandlers: WindowHandlerList;
		(* table of accelerator keys (also known as shortcut keys) *)
		accel: ARRAY MaxAccel OF RECORD
											ch: CHAR; state: SET; id: LONGINT;
											cmd: ARRAY MaxCmd OF CHAR
										END;
		nAccel: LONGINT;
		hCurrentCursor: User32.HCursor;
		capture, mouse: Window;
		kioskmode*: BOOLEAN;
		dummyWin*: Window;

	PROCEDURE CreateHWND(create: CreateStruct);
	BEGIN
		create.win.hWnd := User32.CreateWindowEx(create.exstyle, create.className, "", create.style,
			create.x, create.y, create.w, create.h, create.win.hWndParent, create.hMenu, Kernel.hInstance,
			SYSTEM.VAL(User32.LParam, create));
		IF User32.WSMaximize IN create.style THEN
			User32.ShowWindow(create.win.hWnd, User32.SWShowMaximized)
		ELSIF User32.WSVisible IN create.style THEN
			User32.ShowWindow(create.win.hWnd, User32.SWShow)
		END;
		IF create.win.hWndParent = Kernel32.NULL THEN
			create.win.hWndParent := create.win.hWnd
		END
	END CreateHWND;

	(* Common base handler for all variants of windows provided by this module. *)
	PROCEDURE *DummyHandler(win: Window; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR res: User32.LResult; w: WindowHandlerList; disp: Displays.Display; handled: BOOLEAN;
	BEGIN
		IF (uMsg = User32.WMDestroy) & ~(external IN win.state) THEN
			EXCL(win.state, update); DEC(nWindows);
			IF (nWindows = 1) & (dummyWin # NIL) THEN (* only dummyWin left *)
				IF win = dummyWin THEN dummyWin := NIL END;
				disp := Displays.root; res := 0;
				WHILE disp # NIL DO
					IF disp IS Window THEN INC(res) END;
					disp := disp.link
				END;
				IF res > 1 THEN RETURN 0 END
			ELSIF nWindows >= 1 THEN (* other windows left *)
				RETURN 0
			END;
			User32.PostQuitMessage(0)
		ELSIF uMsg = User32.WMClose THEN
			EXCL(win.state, update);
			IF mouse = win THEN mouse := NIL END;
			IF capture = win THEN
				User32.ReleaseCapture(); capture := NIL
			END;
			w := windowHandlers;
			WHILE w # NIL DO
				w.handler(win, User32.WMClose, wParam, lParam); w := w.next
			END;
			Displays.Remove(win, dummy IN win.state);
			win.getDC := Displays.GetDC; win.releaseDC := Displays.ReleaseDC;
win.hDC := -1; (* ??? *)
			IF ~(external IN win.state) THEN
				User32.DestroyWindow(win.hWnd); win.hWnd := Kernel32.NULL
			END
		ELSIF uMsg = WMCreateWindow THEN
			CreateHWND(SYSTEM.VAL(CreateStruct, lParam))
		ELSE
			handled := FALSE; w := windowHandlers;
			WHILE w # NIL DO
				IF w.uMsg = uMsg THEN
					res := w.handler(win, uMsg, wParam, lParam); handled := TRUE
				END;
				w := w.next
			END;
			IF ~handled THEN
				RETURN win.defWindowProc(win.hWnd, uMsg, wParam, lParam)
			ELSE
				RETURN res
			END
		END;
		RETURN 0
	END DummyHandler;

	PROCEDURE TranslateKey(wParam: User32.WParam; chars: BOOLEAN): CHAR;
		VAR ch: CHAR;
	BEGIN
		CASE wParam OF
			User32.VKPrior: ch := PageUp
			|User32.VKNext: ch := PageDown
			|User32.VKEnd: ch := End
			|User32.VKHome: ch := Home
			|User32.VKLeft: ch := Left
			|User32.VKUp: ch := Up
			|User32.VKRight: ch := Right
			|User32.VKDown: ch := Down
			|User32.VKInsert: ch := Insert
			|User32.VKDelete: ch := Delete
			|User32.VKF1: ch := F1
			|User32.VKF2: ch := F2
			|User32.VKF3: ch := F3
			|User32.VKF4: ch := F4
			|User32.VKF5: ch := F5
			|User32.VKF6: ch := F6
			|User32.VKF7: ch := F7
			|User32.VKF8: ch := F8
			|User32.VKF9: ch := F9
			|User32.VKF10: ch := F10
			|User32.VKF11: ch := F11
			|User32.VKF12: ch := F12
		ELSE
			IF chars THEN
				IF wParam = User32.VKBack THEN
					IF User32.GetAsyncKeyState(User32.VKControl) < 0 THEN
						ch := 08X
					ELSE
						ch := Backspace
					END
				ELSE
					ch := Strings.ISOToOberon[wParam]
				END
			ELSE
				ch := 0X
			END
		END;
		RETURN ch
	END TranslateKey;

	PROCEDURE TranslateAccelerator(win: Window; wParam: User32.WParam): BOOLEAN;
		VAR ch: CHAR; state: SET; i: LONGINT;
	BEGIN
		ch := TranslateKey(wParam, TRUE);
		state := {};
		IF User32.GetAsyncKeyState(User32.VKControl) < 0 THEN
			INCL(state, Input.CTRL)
		END;
		IF User32.GetAsyncKeyState(User32.VKShift) < 0 THEN
			INCL(state, Input.SHIFT)
		END;
		IF User32.GetAsyncKeyState(User32.VKMenu) < 0 THEN
			INCL(state, Input.ALT)
		END;
		i := 0;
		WHILE i < nAccel DO
			IF (accel[i].ch = ch) & (accel[i].state = state) THEN
				User32.SendMessage(win.hWnd, User32.WMCommand, accel[i].id, 0);
				RETURN TRUE
			END;
			INC(i)
		END;
		RETURN FALSE
	END TranslateAccelerator;

	PROCEDURE HandleFocus(win: Window; uMsg: LONGINT; wParam: User32.WParam);
		VAR disp: Displays.Display; done: BOOLEAN;
	BEGIN
		IF uMsg = User32.WMSetFocus THEN
		ELSIF uMsg = User32.WMKillFocus THEN
			IF wParam # Kernel32.NULL THEN
				disp := Displays.root;
				WHILE disp # NIL DO
					IF disp IS Window THEN
						IF disp(Window).hWnd = wParam THEN RETURN END
					END;
					disp := disp.link
				END
			END;
			done := Displays.PutEvent(NIL, win, Displays.defocus, 0)
		END
	END HandleFocus;

	PROCEDURE SetupWin(win: Window);
		VAR rect: User32.Rect; w: WindowHandlerList;
	BEGIN
		User32.GetWindowRect(win.hWnd, win.windowRect);
		User32.GetClientRect(win.hWnd, rect);
		win.width := rect.right - rect.left; win.height := rect.bottom - rect.top;
		Displays.Add(win, FALSE);
		IF User32.GetFocus() = win.hWnd THEN
			HandleFocus(win, User32.WMSetFocus, 0)
		END;
		w := windowHandlers;
		WHILE w # NIL DO
			w.handler(win, User32.WMCreate, 0, 0); w := w.next
		END
	END SetupWin;

	PROCEDURE [WINAPI] *DummyProc(hwnd: User32.HWND; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR win: Window; create: CreateStruct;
	BEGIN
		win := SYSTEM.VAL(Window, User32.GetWindowLong(hwnd, GWLWindow));
		IF win # NIL THEN
			RETURN DummyHandler(win, uMsg, wParam, lParam)
		ELSIF uMsg = User32.WMCreate THEN
			SYSTEM.GET(lParam, create);
			wParam := SYSTEM.VAL(User32.WParam, create);
			lParam := SYSTEM.VAL(User32.LParam, create.win);
			User32.PostMessage(hwnd, WMSetup, wParam, lParam)
		ELSIF uMsg = WMSetup THEN
			win := SYSTEM.VAL(Window, lParam);
			User32.SetWindowLong(hwnd, GWLWindow, lParam);
			create := SYSTEM.VAL(CreateStruct, wParam);
			IF ~(dummy IN win.state) THEN
				SetupWin(win)
			ELSE
				Displays.Add(win, TRUE)
			END;
			IF ~(external IN win.state) THEN INC(nWindows) END;
			Threads.Set(create.event)
		END;
		RETURN User32.DefWindowProc(hwnd, uMsg, wParam, lParam)
	END DummyProc;

	PROCEDURE ChangeCursor();
		VAR point: User32.Point;
	BEGIN
		User32.GetCursorPos(point);
		User32.SetCursor(hCurrentCursor);
		IF hCurrentCursor = Kernel32.NULL THEN
			REPEAT UNTIL User32.ShowCursor(Kernel32.False) < 0
		ELSIF hCurrentCursor # Kernel32.NULL THEN
			REPEAT UNTIL User32.ShowCursor(Kernel32.True) >= 0
		END;
		INC(point.x); INC(point.y);
		User32.SetCursorPos(point.x, point.y);
		DEC(point.x); DEC(point.y);
		User32.SetCursorPos(point.x, point.y)
	END ChangeCursor;

	PROCEDURE SetCursor*(hCursor: User32.HCursor);
	BEGIN
		IF hCurrentCursor # hCursor THEN
			hCurrentCursor := hCursor;
			ChangeCursor()
		END
	END SetCursor;

	PROCEDURE HandleMouse(win: Window; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam);
		VAR keys: SET; wheel: Displays.InputEvent; done: BOOLEAN;
	BEGIN
		mouse := win;
		User32.SetCursor(hCurrentCursor);
		IF uMsg # User32.WMMouseWheel THEN
			win.track.X := SHORT(lParam MOD ASH(1, 16));
			win.track.Y := SHORT(win.height-ASH(lParam, -16)-1)
		END;
		keys := win.track.keys;
		CASE uMsg OF
			User32.WMLButtonDown: INCL(keys, ML)
			|User32.WMLButtonUp: EXCL(keys, ML)
			|User32.WMMButtonDown: INCL(keys, MM)
			|User32.WMMButtonUp: EXCL(keys, MM)
			|User32.WMRButtonDown: INCL(keys, MR)
			|User32.WMRButtonUp: EXCL(keys, MR)
			|User32.WMXButtonDown: INCL(keys, MX)
			|User32.WMXButtonUp: EXCL(keys, MX)
			|User32.WMMouseWheel: NEW(wheel); wheel^ := win.track^;
				wheel.zDelta := SHORT(ASH(wParam, -16));
				done := Displays.PutEvent(wheel, win, Displays.wheel, 0)
		ELSE (* move *)
		END;
		IF kioskmode THEN
			IF (SYSTEM.VAL(SET, wParam) * {User32.MKLButton, User32.MKMButton, User32.MKRButton}) # {} THEN
				keys := {MM}
			ELSE
				keys := {}
			END
		END;
		IF (keys # {}) & (capture # win) THEN
			User32.SetCapture(win.hWnd); capture := win
		ELSIF (keys = {}) & (capture # NIL) THEN
			User32.ReleaseCapture(); capture := NIL
		END;
		win.track.keys := keys;
		done := Displays.PutEvent(win.track, win, Displays.track, 0)
	END HandleMouse;

	(* default handler for WMChar messages *)
	PROCEDURE HandleChar(win: Window; wParam: User32.WParam; lParam: User32.LParam);
		VAR ch: CHAR;
	BEGIN
		IF wParam = User32.VKBack THEN
			IF User32.GetAsyncKeyState(User32.VKControl) < 0 THEN
				ch := 08X
			ELSE
				ch := Backspace
			END
		ELSE
			ch := Strings.ISOToOberon[wParam]
		END;
		lParam := lParam MOD ASH(1, 16);
		WHILE lParam > 0 DO
			Displays.WriteChar(win, ch); DEC(lParam)
		END
	END HandleChar;

	(* default handler for WMKeyDown or WMKeyUp messages *)
	PROCEDURE HandleKey(win: Window; wParam: User32.WParam; lParam: User32.LParam): BOOLEAN;
		VAR ch: CHAR;
	BEGIN
		IF wParam = User32.VKCancel THEN
			Threads.Break(Threads.oberonLoop);
			RETURN TRUE
		ELSIF ~TranslateAccelerator(win, wParam) THEN
			ch := TranslateKey(wParam, FALSE);
			IF ch # 0X THEN
				lParam := lParam MOD ASH(1, 16);
				WHILE lParam > 0 DO
					Displays.WriteChar(win, ch); DEC(lParam)
				END;
				RETURN TRUE
			END
		END;
		RETURN FALSE
	END HandleKey;

	PROCEDURE SetDocRect(win: Window; resize: BOOLEAN);
		VAR A: Objects.AttrMsg; f: Display.Frame; rect: User32.Rect;
	BEGIN
		IF ~(minimized IN win.state) & (win.viewer # NIL) & (win.viewer.dsc # NIL) THEN
			IF resize THEN
				User32.GetWindowRect(win.hWnd, win.windowRect)
			ELSE
				User32.GetWindowRect(win.hWnd, rect);
				win.windowRect.right := rect.left + (win.windowRect.right - win.windowRect.left);
				win.windowRect.left := rect.left;
				win.windowRect.bottom := rect.top + (win.windowRect.bottom - win.windowRect.top);
				win.windowRect.top := rect.top
			END;
			f := win.viewer.dsc.next;
			IF f # NIL THEN
				A.id := Objects.set; A.class := Objects.Int;
				A.name := "WindowsLeft"; A.i := win.windowRect.left;
				f.handle(f, A);
				A.name := "WindowsTop"; A.i := win.windowRect.top;
				f.handle(f, A)
			END
		END
	END SetDocRect;

	PROCEDURE UpdateDisplay(win: Window; id: LONGINT; lParam: User32.LParam);
		VAR done: BOOLEAN;
	BEGIN
		IF ~(minimized IN win.state) THEN
			IF id = Displays.resize THEN
				win.width := lParam MOD ASH(1, 16); win.height := lParam DIV ASH(1, 16);
				SetDocRect(win, TRUE)
			END;
			User32.ValidateRect(win.hWnd, NIL);
			done := Displays.PutEvent(NIL, win, id, 0)
		END
	END UpdateDisplay;

	PROCEDURE LockedSize(win: Window): BOOLEAN;
		VAR A: Objects.AttrMsg;
	BEGIN
		A.id := Objects.get; A.name := "LockedSize"; A.class := Objects.Inval; A.res := -1;
		win.viewer.handle(win.viewer, A);
		RETURN (A.res = 0) & (A.class = Objects.Bool) & A.b
	END LockedSize;

	PROCEDURE UpdateBorder(win: Window; locked: BOOLEAN);
		VAR style, newstyle: SET; rect, newrect: User32.Rect; dw, dh: LONGINT;
	BEGIN
		style := SYSTEM.VAL(SET, User32.GetWindowLong(win.hWnd, User32.GWLStyle));
		IF locked THEN
			newstyle := style-{User32.WSThickFrame}
		ELSE
			newstyle := style+{User32.WSThickFrame}
		END;
		IF style # newstyle THEN
			User32.GetClientRect(win.hWnd, rect);
			User32.SetWindowLong(win.hWnd, User32.GWLStyle, SYSTEM.VAL(LONGINT, newstyle));
			User32.SetWindowPos(win.hWnd, Kernel32.NULL, 0, 0, 0, 0, {User32.SWPFrameChanged});
			User32.GetWindowRect(win.hWnd, win.windowRect);
			User32.GetClientRect(win.hWnd, newrect);
			dw := (newrect.right-newrect.left)-(rect.right-rect.left);
			dh := (newrect.bottom-newrect.top)-(rect.bottom-rect.top);
			User32.SetWindowPos(win.hWnd, Kernel32.NULL, 0, 0,
				win.windowRect.right-win.windowRect.left+dw, win.windowRect.bottom-win.windowRect.top+dh,
				{User32.SWPNoMove})
		END
	END UpdateBorder;

	PROCEDURE GetMinMaxInfo(win: Window; lParam: User32.LParam): BOOLEAN;
		VAR mm: User32.MinMaxInfo; locked: BOOLEAN;
	BEGIN
		locked := LockedSize(win);
		UpdateBorder(win, locked);
		IF locked THEN
			SYSTEM.MOVE(lParam, SYSTEM.ADR(mm), SIZE(User32.MinMaxInfo));
			mm.ptMaxSize.x := win.windowRect.right-win.windowRect.left;
			mm.ptMaxSize.y := win.windowRect.bottom-win.windowRect.top;
			mm.ptMinTrackSize := mm.ptMaxSize; mm.ptMaxTrackSize := mm.ptMaxSize;
			SYSTEM.MOVE(SYSTEM.ADR(mm), lParam, SIZE(User32.MinMaxInfo))
		END;
		RETURN locked
	END GetMinMaxInfo;

	PROCEDURE Minimize(win: Window);
		VAR done: BOOLEAN;
	BEGIN
		INCL(win.state, minimized);
		IF win.viewer.state > 0 THEN
			done := Displays.PutEvent(NIL, win, Displays.defocus, 0);
			done := Displays.PutEvent(NIL, win, Displays.suspend, 0)
		END
	END Minimize;

	PROCEDURE Restore(win: Window);
		VAR done: BOOLEAN;
	BEGIN
		EXCL(win.state, minimized);
		IF win.viewer.state < 0 THEN
			done := Displays.PutEvent(NIL, win, Displays.restore, 0)
		END
	END Restore;

	PROCEDURE PosChanging(win: Window; lParam: User32.LParam);
		VAR pos: User32.WindowPos;
	BEGIN
		SYSTEM.MOVE(lParam, SYSTEM.ADR(pos), SIZE(User32.WindowPos));
		IF ~(User32.SWPNoMove IN pos.flags) THEN
			IF (pos.x < -Display.Width) & (pos.y < -Display.Height) THEN
				Minimize(win)
			ELSIF (pos.x >= 0) & (pos.y >= 0) THEN
				Restore(win)
			END
		END;
		Viewers.sorted := FALSE
	END PosChanging;

	(** Common base handler for all visual windows (document or control) provided by this module. *)
	PROCEDURE WindowHandler*(win: Window; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR id: LONGINT; paint: User32.PaintStruct; handled, done: BOOLEAN;
	BEGIN
		IF update IN win.state THEN
			handled := TRUE;
			IF uMsg < User32.WMMouseFirst THEN
				CASE uMsg OF
					User32.WMMove: SetDocRect(win, FALSE)
					|User32.WMSize: IF wParam # User32.SizeMinimized THEN
													IF minimized IN win.state THEN
														Restore(win)
													END;
													UpdateDisplay(win, Displays.resize, lParam)
												ELSIF ~(minimized IN win.state) THEN
													Minimize(win)
												END
					|User32.WMPaint:
						User32.BeginPaint(win.hWnd, paint);
						UpdateDisplay(win, Displays.redraw, lParam);
						User32.EndPaint(win.hWnd, paint)
					(*|User32.WMMouseActivate:
						IF (lParam MOD 65536) # (User32.HTClient) THEN
							User32.SetFocus(win.hWnd)
						END;
						RETURN User32.MANoActivate*)
					|User32.WMGetMinMaxInfo: handled := GetMinMaxInfo(win, lParam)
					|User32.WMWindowPosChanging: PosChanging(win, lParam); handled := FALSE
					|User32.WMKeyDown: IF ~HandleKey(win, wParam, lParam) THEN
															IF wParam = User32.VKApps THEN
																IF mouse = NIL THEN mouse := win END;
																IF capture = NIL THEN
																	User32.SetCapture(mouse.hWnd); capture := mouse
																END;
																INCL(mouse.track.keys, MM);
																done := Displays.PutEvent(mouse.track, mouse, Displays.track, 0)
															END
														END
					|User32.WMKeyUp: IF (wParam = User32.VKApps) & (mouse # NIL) THEN
																EXCL(mouse.track.keys, MM);
																done := Displays.PutEvent(mouse.track, mouse, Displays.track, 0);
																IF (mouse.track.keys = {}) & (capture # NIL) THEN
																	User32.ReleaseCapture(); capture := NIL
																END
															END
					|User32.WMChar: HandleChar(win, wParam, lParam)
					|User32.WMCommand: id := wParam MOD ASH(1, 16);
														IF (id >= IDFirstAccelCmd) & (id < (IDFirstAccelCmd+nAccel)) THEN
															done := Displays.PutCmd(win, win, accel[id-IDFirstAccelCmd].cmd, 0)
														ELSE
															handled := FALSE
														END
					|User32.WMSetFocus, User32.WMKillFocus: HandleFocus(win, uMsg, wParam)
				ELSE
					handled := FALSE
				END
			ELSIF (uMsg >= User32.WMMouseFirst) & (uMsg <= User32.WMMouseLast) THEN
				HandleMouse(win, uMsg, wParam, lParam)
			ELSE
				handled := FALSE
			END
		ELSE
			handled := FALSE
		END;
		IF ~handled THEN
			RETURN DummyHandler(win, uMsg, wParam, lParam)
		ELSE
			RETURN 0
		END
	END WindowHandler;

	(** Common base handler for all visual windows (document or control) provided by this module. *)
	PROCEDURE WindowObjectHandler*(win: Objects.Object; VAR M: Objects.ObjMsg);
		VAR wndpl: User32.WindowPlacement;
	BEGIN
		WITH win: Window DO
			IF M IS Display.ModifyMsg THEN
				WITH M: Display.ModifyMsg DO
					IF (*(update IN win.state) & *) ~(minimized IN win.state) THEN
						User32.GetWindowRect(win.hWnd, win.windowRect);
						User32.MoveWindow(win.hWnd, win.windowRect.left, win.windowRect.top, win.windowRect.right-win.windowRect.left+M.dW,win.windowRect.bottom-win.windowRect.top+M.dH, Kernel32.True);
						User32.GetWindowRect(win.hWnd, win.windowRect);
						M.res := 0
					END
				END
			ELSIF M IS Display.ControlMsg THEN
				WITH M: Display.ControlMsg DO
					IF M.id = Display.remove THEN
						User32.PostMessage(win.hWnd, User32.WMClose, 0, 0); M.res := 0
					END
				END
			ELSIF M IS Objects.AttrMsg THEN
				WITH M: Objects.AttrMsg DO
					IF M.id = Objects.get THEN
						IF M.name = "Update" THEN
							M.class := Objects.Bool; M.b := update IN win.state; M.res := 0
						ELSIF ~(control IN win.state) THEN
							IF M.name = "Title" THEN
								User32.GetWindowText(win.hWnd, M.s, LEN(M.s));
								M.class := Objects.String; M.res := 0
							ELSIF M.name = "ShowWindow" THEN
								wndpl.length := SIZE(User32.WindowPlacement);
								wndpl.flags := {}; wndpl.showCmd := User32.SWNormal;
								IF User32.GetWindowPlacement(win.hWnd, wndpl) # Kernel32.False THEN
									CASE wndpl.showCmd OF
										User32.SWMaximize: M.s := "Maximized"
										|User32.SWMinimize: M.s := "Minimized"
									ELSE
										M.s := "Normal"
									END;
									M.class := Objects.String; M.res := 0
								END
							END
						END
					ELSIF M.id = Objects.set THEN
						IF M.class = Objects.Bool THEN
							IF M.name = "Update" THEN
								IF M.b THEN
									INCL(win.state, update)
								ELSE
									EXCL(win.state, update)
								END;
								M.res := 0
							END
						ELSIF ~(control IN win.state) & (M.class = Objects.String) THEN
							IF M.name = "Title" THEN
								IF User32.SetWindowText(win.hWnd, M.s) # Kernel32.False THEN M.res := 0 END
							ELSIF M.name = "ShowWindow" THEN
								IF (CAP(M.s[0]) = "M") & (CAP(M.s[1]) = "A") THEN
									IF User32.ShowWindowAsync(win.hWnd, User32.SWMaximize) # Kernel32.False THEN M.res := 0 END
								ELSIF (CAP(M.s[0]) = "M") & (CAP(M.s[1]) = "I") THEN
									IF User32.ShowWindowAsync(win.hWnd, User32.SWMinimize) # Kernel32.False THEN M.res := 0 END
								ELSE
									IF User32.ShowWindowAsync(win.hWnd, User32.SWNormal) # Kernel32.False THEN M.res := 0 END
								END
							ELSIF M.name = "Icon" THEN
								User32.SendMessage(win.hWnd, User32.WMSetIcon, User32.IconBig, User32.LoadIcon(Kernel.hInstance, M.s));
								Strings.Append(M.s, ".Small");
								User32.SendMessage(win.hWnd, User32.WMSetIcon, User32.IconSmall, User32.LoadIcon(Kernel.hInstance, M.s));
								M.res := 0
							END
						END
					ELSIF M.id = Objects.enum THEN
						M.Enum("Update");
						IF ~(control IN win.state) THEN
							M.Enum("Title"); M.Enum("Icon"); M.Enum("ShowWindow")
						END;
						M.res := 0
					END
				END
			END
		END
	END WindowObjectHandler;

	PROCEDURE [WINAPI] WindowProc*(hwnd: User32.HWND; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR win: Window;
	BEGIN
		win := SYSTEM.VAL(Window, User32.GetWindowLong(hwnd, GWLWindow));
		IF win # NIL THEN
			RETURN WindowHandler(win, uMsg, wParam, lParam)
		ELSE
			RETURN DummyProc(hwnd, uMsg, wParam, lParam)
		END
	END WindowProc;

	(** Implementation of GetDC for all visual windows (document or control) provided by this module. *)
	PROCEDURE GetDC*(disp: Displays.Display);
	BEGIN
		Displays.GetDC(disp);
		IF disp(Window).hWnd # Kernel32.NULL THEN
			disp.hDC := User32.GetDC(disp(Window).hWnd)
		ELSE
			disp.hDC := Kernel32.NULL
		END;
		Displays.BeginClip(disp)
	END GetDC;

	(** Implementation of ReleaseDC for all visual windows (document or control) provided by this module. *)
	PROCEDURE ReleaseDC*(disp: Displays.Display);
	BEGIN
		Displays.ReleaseDC(disp);
		IF disp.hDC # Kernel32.NULL THEN
			User32.ReleaseDC(disp(Window).hWnd, disp.hDC);
			disp.hDC := Kernel32.NULL
		END
	END ReleaseDC;

	(** Install a externaly created window in the display space.
		You must already have set up the fields:
		handle, getDC, releaseDC, hWnd and defWindowProc *)
	PROCEDURE Install*(win: Window; ctrl: BOOLEAN);
		VAR h: User32.HWND;
	BEGIN
		INCL(win.state, external);
		IF ctrl THEN INCL(win.state, control) END;
		h := win.hWnd;
		WHILE h # Kernel32.NULL DO
			win.hWndParent := h;
			h := User32.GetParent(h)
		END;
		SetupWin(win)
	END Install;

	(** Initialize the fields of a new Window instance with default values.
		You must call this procedure whenever you alloc a new Window instance
		or an extension of it. *)
	PROCEDURE Init*(win: Window);
	BEGIN
		Viewers.InitWindow(win);
		win.viewer := NIL;
		win.getDC := Displays.GetDC; win.releaseDC := Displays.ReleaseDC;
		win.defWindowProc := User32.DefWindowProc;
		win.windowRect.left := 0; win.windowRect.right := 0;
		win.windowRect.top := 0; win.windowRect.bottom := 0;
		win.state := {}
	END Init;

	PROCEDURE RegisterClasses();
	BEGIN
		dummyClass.cbSize := SIZE(User32.WndClassEx);
		dummyClass.style := {};
		dummyClass.lpfnWndProc := DummyProc;
		dummyClass.cbClsExtra := 0;
		dummyClass.cbWndExtra := 4;
		dummyClass.hInstance := Kernel.hInstance;
		dummyClass.hIcon := Kernel32.NULL;
		dummyClass.hIconSm := Kernel32.NULL;
		dummyClass.hCursor := Kernel32.NULL;
		dummyClass.hbrBackground := Kernel32.NULL;
		dummyClass.lpszMenuName := Kernel32.NULL;
		dummyClass.lpszClassName := SYSTEM.VAL(Kernel32.LPSTR, SYSTEM.ADR(dummyClassName));
		User32.RegisterClassEx(dummyClass);

		windowClass.cbSize := SIZE(User32.WndClassEx);
		windowClass.style := {};
		windowClass.lpfnWndProc := WindowProc;
		windowClass.cbClsExtra := 0;
		windowClass.cbWndExtra := 4;
		windowClass.hInstance := Kernel.hInstance;
		windowClass.hIcon := User32.LoadIcon(Kernel.hInstance, "Oberon");
		windowClass.hIconSm := User32.LoadIcon(Kernel.hInstance, "Oberon.Small");
		windowClass.hCursor := Kernel32.NULL;
		windowClass.hbrBackground := Kernel32.NULL;
		windowClass.lpszMenuName := Kernel32.NULL;
		windowClass.lpszClassName := SYSTEM.VAL(Kernel32.LPSTR, SYSTEM.ADR(windowClassName));
		User32.RegisterClassEx(windowClass)
	END RegisterClasses;

	PROCEDURE UnregisterClasses();
	BEGIN
		User32.UnregisterClass(dummyClassName, Kernel.hInstance);
		User32.UnregisterClass(windowClassName, Kernel.hInstance)
	END UnregisterClasses;

	PROCEDURE MsgLoop();
		VAR msg: User32.Msg; i: LONGINT;
	BEGIN
		LOOP
			i := User32.GetMessage(msg, 0, 0, 0);
			IF i = 0 THEN
				EXIT
			ELSIF i # -1 THEN
				User32.TranslateMessage(msg);
				User32.DispatchMessage(msg)
			END
		END
	END MsgLoop;

	PROCEDURE *WinMain();
		VAR context: Exceptions.Context;
		PROCEDURE *Handler(VAR e: Exceptions.Exception): LONGINT;
		BEGIN
			RETURN Exceptions.ReturnFail(context)
		END Handler;
	BEGIN
		RegisterClasses();
		CreateHWND(createWin); createWin := NIL;
		LOOP
			IF ~Exceptions.Failed(context) THEN
				MsgLoop(); EXIT
			ELSE
				Kernel32.Str("Exception in WinMain"); Kernel32.Ln()
			END
		END;
		UnregisterClasses();
		winMain := NIL;
		IF Kernel.isEXE & Kernel.CanShutdown() THEN
			Kernel.Shutdown(0)
		END
	END WinMain;

	PROCEDURE FirstWindow(): Window;
		VAR disp: Displays.Display; w: Window;
	BEGIN
		w := NIL; disp := Displays.root;
		WHILE (w = NIL) & (disp # NIL) DO
			IF disp IS Window THEN
				w := disp(Window);
				IF (w.hWnd = Kernel32.NULL) OR (~(update IN w.state) & ~(dummy IN w.state)) OR (external IN w.state) THEN
					w := NIL
				END
			END;
			disp := disp.link
		END;
		RETURN w
	END FirstWindow;

	PROCEDURE CreateWin(create: CreateStruct);
		VAR theWin: Window; done: BOOLEAN;
	BEGIN
		IF nWindows <= 0 THEN
			NEW(winMain); winMain.name := "Windows.WinMain"; winMain.safe := FALSE;
			createWin := create; Threads.Start(winMain, WinMain, 0)
		ELSE
			theWin := FirstWindow();
			User32.PostMessage(theWin.hWnd, WMCreateWindow, 0, SYSTEM.VAL(User32.LParam, create))
		END;
		done := Threads.Wait(create.event, Threads.Infinite)
	END CreateWin;

	(** Create a new document window.
		You must already have set up the fields:
		handle *)
	PROCEDURE CreateWindow*(win: Window; hMenu: User32.HMenu; x, y, w, h: LONGINT);
		VAR create: CreateStruct;
	BEGIN
		win.getDC := GetDC; win.releaseDC := ReleaseDC;
		NEW(create); create.win := win; create.hMenu := hMenu;
		NEW(create.event); Threads.Create(create.event);
		create.style := {User32.WSMinimizeBox, User32.WSMaximizeBox, User32.WSSysMenu, User32.WSBorder,
			User32.WSThickFrame, User32.WSVisible};
		create.exstyle := {};
		IF LockedSize(win) THEN EXCL(create.style, User32.WSThickFrame) END;
		IF (w < MAX(INTEGER)) & (h < MAX(INTEGER)) THEN
			IF x < 0 THEN x := User32.CWUseDefault END;
			IF y < 0 THEN y := User32.CWUseDefault END;
			IF w <= 0 THEN w := User32.CWUseDefault END;
			IF h <= 0 THEN h := User32.CWUseDefault END
		ELSIF (w <= MAX(INTEGER)) & (h <= MAX(INTEGER)) THEN
			x := User32.CWUseDefault; y := User32.CWUseDefault;
			w := User32.CWUseDefault; h := User32.CWUseDefault;
			create.style := create.style + {User32.WSMaximize}
		ELSE
			x := 0; y := 0; w := Displays.desktop.width; h := Displays.desktop.height;
			create.style := {User32.WSVisible, User32.WSPopup}; create.exstyle := {User32.WSExTopMost}
		END;
		create.x := x; create.y := y; create.w := w; create.h := h;
		COPY(windowClassName, create.className);
		CreateWin(create)
	END CreateWindow;

	PROCEDURE [WINAPI] *ControlWindowProc(hwnd: User32.HWND; uMsg: LONGINT; wParam: User32.WParam; lParam: User32.LParam): User32.LResult;
		VAR win: Window;
	BEGIN
		win := SYSTEM.VAL(Window, User32.GetWindowLong(hwnd, GWLWindow));
		IF win # NIL THEN
			RETURN WindowHandler(win, uMsg, wParam, lParam)
		ELSIF uMsg = User32.WMCreate THEN
			SYSTEM.GET(lParam, win); win.hWnd := hwnd;
			User32.SetWindowLong(hwnd, GWLWindow, SYSTEM.VAL(LONGINT, win));
			Install(win, TRUE);
			RETURN 0 
		ELSE
			RETURN User32.DefWindowProc(hwnd, uMsg, wParam, lParam)
		END
	END ControlWindowProc;

	PROCEDURE [WINAPI] RegisterControlWinClass();
	BEGIN
		IF aControlWinClass = Kernel32.NULL THEN
			controlClass.cbSize := SIZE(User32.WndClassEx);
			controlClass.style := {User32.CSGlobalClass};
			controlClass.lpfnWndProc := ControlWindowProc;
			controlClass.cbClsExtra := 0;
			controlClass.cbWndExtra := 8; (* 0: hwnd to Window, 4: used by control impl. *)
			controlClass.hInstance := Kernel32.NULL; (* -> calling thread *)
			controlClass.hIcon := User32.LoadIcon(Kernel.hInstance, "Oberon");
			controlClass.hIconSm := User32.LoadIcon(Kernel.hInstance, "Oberon.Small");
			controlClass.hCursor := Kernel32.NULL;
			controlClass.hbrBackground := Kernel32.NULL;
			controlClass.lpszMenuName := Kernel32.NULL;
			controlClass.lpszClassName := SYSTEM.VAL(Kernel32.LPSTR, SYSTEM.ADR(controlClassName));
			aControlWinClass := User32.RegisterClassEx(controlClass)
		END
	END RegisterControlWinClass;

	PROCEDURE [WINAPI] UnregisterControlWinClass();
	BEGIN
		IF aControlWinClass # Kernel32.NULL THEN
			User32.UnregisterClass(controlClassName, Kernel.hInstance);
			aControlWinClass := Kernel32.NULL
		END
	END UnregisterControlWinClass;

	(** Create a new control window.
		You must already have set up the fields:
		handle, getDC, releaseDC, hWndParent *)
	PROCEDURE CreateControl*(win: Window; x, y, w, h: LONGINT);
	BEGIN
		RegisterControlWinClass(); INCL(win.state, control);
		win.hWnd := User32.CreateWindowEx({}, controlClassName, "", {User32.WSChild, User32.WSVisible},
			x, y, w, h, win.hWndParent, Kernel32.NULL, Kernel32.NULL, SYSTEM.VAL(LONGINT, win))
	END CreateControl;

	(** Registers a message handler for uMsg. If a window is closed, the handler is called
		with uMsg = User32.WMClose. *)
	PROCEDURE RegisterWindowHandler*(handler: WindowHandlerProc; uMsg: LONGINT);
		VAR w: WindowHandlerList;
	BEGIN
		NEW(w); w.next := windowHandlers; windowHandlers := w;
		w.uMsg := uMsg; w.handler := handler
	END RegisterWindowHandler;

	(** Removes a message handler previously registered with RegisterWindowHandler. *)
	PROCEDURE UnregisterWindowHandler*(handler: WindowHandlerProc);
		VAR p, w: WindowHandlerList;
	BEGIN
		p := NIL; w := windowHandlers;
		WHILE w # NIL DO
			IF w.handler = handler THEN
				IF p # NIL THEN
					p.next := w.next
				ELSE
					windowHandlers := w.next
				END
			ELSE
				p := w
			END;
			w := w.next
		END
	END UnregisterWindowHandler;

	PROCEDURE OpenViewer*(V: Viewers.Viewer; w, h: LONGINT);
		VAR
			win: Window; hMenu: User32.HMenu;
			A: Objects.AttrMsg; f: Display.Frame;
			x, y, fX, fY: LONGINT;
	BEGIN
		NEW(win); Init(win); win.handle := WindowObjectHandler;
		win.viewer := V; V.win := win; hMenu := Kernel32.NULL;
		IF LockedSize(win) THEN
			fX := fixedFrameX; fY := fixedFrameY
		ELSE
			fX := frameX; fY := frameY
		END;
		x := -1; y := -1;
		IF w > 0 THEN INC(w, 2*fX) END;
		IF h > 0 THEN INC(h, 2*fY+captionY) END;
		IF (V # NIL) & (V.dsc # NIL) & (V.dsc.next # NIL) THEN
			A.id := Objects.get; A.name := "HMENU"; A.class := Objects.Inval; A.res := -1;
			V.dsc.handle(V.dsc, A);
			IF (A.res = 0) & (A.class = Objects.Int) THEN
				hMenu := A.i; INC(h, menuY)
			END;
			A.id := Objects.get; A.name := "WindowsLeft"; A.class := Objects.Inval; A.res := -1;
			f := V.dsc.next; f.handle(f, A);
			IF (A.res = 0) & (A.class = Objects.Int) THEN
				x := A.i; A.name := "WindowsTop"; f.handle(f, A); y := A.i
			END
		END;
		IF w >= (Displays.desktop.width-2*fX) THEN
			w := MAX(INTEGER)
		END;
		IF h >= (Displays.desktop.height-2*fY-captionY-menuY) THEN
			h := MAX(INTEGER)
		END;
		IF x > (Displays.desktop.width+captionY) THEN
			x := Displays.desktop.width-captionY
		END;
		IF y > (Displays.desktop.height+captionY) THEN
			y := Displays.desktop.height-captionY
		END;
		CreateWindow(win, hMenu, x, y, w, h)
	END OpenViewer;

	(* define a key combination for cmd *)
	PROCEDURE AddAccel(ch: CHAR; state: SET; cmd: ARRAY OF CHAR);
	BEGIN
		accel[nAccel].ch := ch;
		accel[nAccel].state := state;
		accel[nAccel].id := IDFirstAccelCmd+nAccel;
		COPY(cmd, accel[nAccel].cmd);
		INC(nAccel)
	END AddAccel;

	(* define a key (F1 .. F12) combination for cmd *)
	PROCEDURE AddFAccel(F: LONGINT; state: SET; cmd: ARRAY OF CHAR);
		VAR ch: CHAR;
	BEGIN
		CASE F OF
			1: ch := F1
			|2: ch := F2
			|3: ch := F3
			|4: ch := F4
			|5: ch := F5
			|6: ch := F6
			|7: ch := F7
			|8: ch := F8
			|9: ch := F9
			|10: ch := F10
			|11: ch := F11
			|12: ch := F12
		END;
		AddAccel(ch, state, cmd)
	END AddFAccel;

	PROCEDURE *AddRegHotKeys(cmd, keys: ARRAY OF CHAR);
		VAR
			i, j, F: LONGINT;
			str: ARRAY 16 OF CHAR;
			state: SET;
			key, ch: CHAR;
	BEGIN
		state := {}; key := 0X; F := 0; i := 0;
		WHILE keys[i] # 0X DO
			ch := keys[i];
			IF ch = "," THEN
				IF key # 0X THEN
					AddAccel(key, state, cmd)
				ELSIF F > 0 THEN
					AddFAccel(F, state, cmd)
				END;
				state := {}; key := 0X; F := 0; INC(i)
			ELSIF ch > " " THEN
				j := 0;
				WHILE (ch > " ") & (ch # ",") DO
					str[j] := ch; INC(i); INC(j);
					ch := keys[i]
				END;
				str[j] := 0X; Strings.Upper(str, str);
				IF str = "CTRL" THEN
					INCL(state, Input.CTRL)
				ELSIF str = "SHIFT" THEN
					INCL(state, Input.SHIFT)
				ELSIF str = "ALT" THEN
					INCL(state, Input.ALT)
				ELSIF str = "PAGEUP" THEN
					key := PageUp
				ELSIF str = "PAGEDOWN" THEN
					key := PageDown
				ELSIF str = "END" THEN
					key := End
				ELSIF str = "HOME" THEN
					key := Home
				ELSIF str = "LEFT" THEN
					key := Left
				ELSIF str = "UP" THEN
					key := Up
				ELSIF str = "RIGHT" THEN
					key := Right
				ELSIF str = "DOWN" THEN
					key := Down
				ELSIF str = "INSERT" THEN
					key := Insert
				ELSIF str = "DELETE" THEN
					key := Delete
				ELSIF (str[0] = "F") & (str[1] >= "1") & (str[1] <= "9") THEN
					F := ORD(str[1])-ORD("0");
					IF (str[2] >= "0") & (str[2] <= "2") THEN
						F := 10*F + ORD(str[2])-ORD("0")
					END
				ELSIF j = 1 THEN
					key := str[0]
				ELSE
					(* ??? *)
				END
			ELSE
				INC(i)
			END
		END;
		IF key # 0X THEN
			AddAccel(key, state, cmd)
		ELSIF F > 0 THEN
			AddFAccel(F, state, cmd)
		END
	END AddRegHotKeys;

	PROCEDURE UseDummyWin*();
		VAR create: CreateStruct;
	BEGIN
		IF dummyWin = NIL THEN
			NEW(dummyWin); Init(dummyWin);
			INCL(dummyWin.state, dummy);
			NEW(create); create.win := dummyWin; create.hMenu := Kernel32.NULL;
			NEW(create.event); Threads.Create(create.event);
			create.x := 0; create.y := 0; create.w := 0; create.h := 0; create.style := {};
			COPY(dummyClassName, create.className);
			CreateWin(create)
		END
	END UseDummyWin;

	PROCEDURE InitMod();
		VAR path: FileDir.FileName;
	BEGIN
		fixedFrameX := User32.GetSystemMetrics(User32.SMCXFixedFrame);
		fixedFrameY := User32.GetSystemMetrics(User32.SMCYFixedFrame);
		frameX := User32.GetSystemMetrics(User32.SMCXFrame);
		frameY := User32.GetSystemMetrics(User32.SMCYFrame);
		captionY := User32.GetSystemMetrics(User32.SMCYCaption);
		menuY := User32.GetSystemMetrics(User32.SMCYMenu);
		capture := NIL; mouse := NIL;
		winMain := NIL; nWindows := 0;
		hCurrentCursor := Kernel32.NULL;
		dummyClassName := "Oberon.Dummy.Class";
		windowClassName := "Oberon.Window.Class";
		controlClassName := "Oberon.ControlWindow.Class";
		windowHandlers := NIL; aControlWinClass := Kernel32.NULL;
		Registry.GetKeyValue(Registry.CurrentUser, Registry.oberonSystem, "KioskMode", path);
		IF Registry.res = Registry.Done THEN
			Strings.StrToBool(path, kioskmode)
		ELSE
			kioskmode := FALSE
		END;
		nAccel := 0; Registry.OberonPath("HotKeys", path);
		Registry.EnumerateKeyValue(Registry.CurrentUser, path, AddRegHotKeys);
		dummyWin := NIL
	END InitMod;

	PROCEDURE *Shutdown();
		VAR disp: Displays.Display;
	BEGIN
		disp := Displays.root;
		WHILE disp # NIL DO
			IF disp IS Window THEN
				WITH disp: Window DO
					IF disp.hWnd # Kernel32.NULL THEN
						User32.PostMessage(disp.hWnd, User32.WMClose, 0, 0)
					END
				END
			END;
			disp := disp.link
		END;
		IF dummyWin # NIL THEN
			User32.PostMessage(dummyWin.hWnd, User32.WMClose, 0, 0)
		END;
		UnregisterControlWinClass()
	END Shutdown;

	PROCEDURE ShowAll*;
		VAR disp: Displays.Display; win: Window;
	BEGIN
		disp := Displays.root;
		WHILE disp # NIL DO
			IF disp IS Window THEN
				win := disp(Window);
				IF (update IN win.state) & ~(dummy IN win.state) & ~(control IN win.state) THEN
					IF ~(minimized IN win.state) THEN
						User32.BringWindowToTop(win.hWnd)
					END
				END
			END;
			disp := disp.link
		END;
		disp := Displays.root;
		WHILE disp # NIL DO
			IF disp IS Window THEN
				win := disp(Window);
				IF (update IN win.state) & ~(dummy IN win.state) & ~(control IN win.state) THEN
					IF minimized IN win.state THEN
						User32.ShowWindow(win.hWnd, User32.SWRestore);
						User32.BringWindowToTop(win.hWnd)
					END
				END
			END;
			disp := disp.link
		END
	END ShowAll;

	PROCEDURE HideAll*;
		VAR disp: Displays.Display; win: Window;
	BEGIN
		disp := Displays.root;
		WHILE disp # NIL DO
			IF disp IS Window THEN
				win := disp(Window);
				IF (update IN win.state) & ~(dummy IN win.state) & ~(control IN win.state) THEN
					IF ~(minimized IN win.state) THEN
						User32.ShowWindow(win.hWnd, User32.SWMinimize)
					END
				END
			END;
			disp := disp.link
		END
	END HideAll;

BEGIN
	InitMod(); Modules.InstallTermHandler(Shutdown)
END Windows.
BIER         <       g 
     C  Syntax10.Scn.Fnt 03.02.2009  16:47:47  TimeStamps.New  