TextDocs.NewDoc     =g   CWindowsLeft    WindowsTop    Color    Flat  Locked  Controls  Org [n   BIER           3  z   Syntax10.Scn.Fnt  /   Oberon10.Scn.Fnt      M            C    ~   +    /   {    z   n  (* Copyright (c) 1994 - 2000 Emil J. Zeller *)

MODULE WinPrinter; (** non-portable / source: Win32.WinPrinter.Mod *)	(* ejz   *)
	IMPORT SYSTEM, Kernel32, Kernel, Registry, User32, GDI32, COMDLG32, Displays, FileDir, Objects, Display, Fonts,
		Pictures, Printers := Printer, Strings, Texts, Oberon, WinFonts, WinMenus;

(** Installable printer (see: Printer) for Windows GDI printing. *)

	TYPE
		Printer* = POINTER TO PrinterDesc;
		PrinterDesc* = RECORD (Printers.PrinterDesc)
			hDC, hdcMem: User32.HDC;
			dpi, mode: LONGINT;
			color, bkColor, textColor: GDI32.ColorRef;
			textX, textY: LONGINT;
			pageW, pageH: LONGINT;
			offsX, offsY: LONGINT;
			page, from, to: LONGINT;
			newPage, showPage: BOOLEAN
		END;

		ExtPrinter = POINTER TO ExtPrinterDesc;
		ExtPrinterDesc = RECORD (PrinterDesc)
			oldP: Printers.Printer; nSavedDC: LONGINT
		END;

		DocPrinter = POINTER TO DocPrinterDesc;
		DocPrinterDesc = RECORD (PrinterDesc)
			job: LONGINT;
			hDevMode, hDevNames: Kernel32.HGLOBAL;
			margin: User32.Rect;
			psdUnit: LONGINT;
			setup: BOOLEAN
		END;

	VAR
		W: Texts.Writer;

	PROCEDURE PrintDlg(P: DocPrinter; flags: SET): WinMenus.PrintDialog;
		VAR dialog: WinMenus.PrintDialog; i: LONGINT;
	BEGIN
		NEW(dialog); dialog.context := P;
		dialog.print.lStructSize := 66 (*SIZE(COMDLG32.PRINTDLG)*);
		IF P # NIL THEN
			dialog.print.hDevNames := P.hDevNames; dialog.print.hDevMode := P.hDevMode
		ELSE
			dialog.print.hDevNames := Kernel32.NULL; dialog.print.hDevMode := Kernel32.NULL
		END;
		dialog.print.hDC := Kernel32.NULL; dialog.print.Flags := flags;
		dialog.print.nFromPage := 1; dialog.print.nToPage := 1;
		dialog.print.nMinPage := 1; dialog.print.nMaxPage := MAX(INTEGER);
		SYSTEM.PUT(SYSTEM.ADR(dialog.print.fill[0]), LONG(1)); (* dialog.print.nCopies *)
		SYSTEM.PUT(SYSTEM.ADR(dialog.print.fill[2]), Kernel.hInstance); (* dialog.print.hInstance *)
		FOR i := 6 TO 8*4-1 DO dialog.print.fill[i] := 0X END;
		WinMenus.ShowDialog(dialog, TRUE);
		IF dialog.done THEN
			RETURN dialog
		ELSE
			RETURN NIL
		END
	END PrintDlg;

	PROCEDURE PrinterDC(P: DocPrinter): User32.HDC;
		VAR
			adrNames: Kernel32.ADDRESS;
			hDC: User32.HDC;
			device, driver: FileDir.FileName;
			dialog: WinMenus.PrintDialog; offs: INTEGER;
	BEGIN
		IF (P # NIL) & (P.hDevNames # Kernel32.NULL) THEN
			adrNames := Kernel32.GlobalLock(P.hDevNames);
			SYSTEM.GET(adrNames, offs);
			Kernel32.CopyString(adrNames+offs, driver);
			SYSTEM.GET(adrNames+2, offs);
			Kernel32.CopyString(adrNames+offs, device);
			hDC := GDI32.CreateDC(driver, device, NIL, SYSTEM.VAL(PTR, Kernel32.GlobalLock(P.hDevMode)));
			Kernel32.GlobalUnlock(P.hDevMode); Kernel32.GlobalUnlock(P.hDevNames);
			RETURN hDC
		ELSE
			dialog := PrintDlg(P, {COMDLG32.PDReturnDC, COMDLG32.PDReturnDefault});
			IF dialog # NIL THEN RETURN dialog.print.hDC END
		END;
		RETURN Kernel32.NULL
	END PrinterDC;

	PROCEDURE SetupDocFrame(P: DocPrinter);
	BEGIN
		IF P.margin.left < P.offsX THEN
			P.margin.left := P.offsX
		END;
		P.FrameX := SHORT(P.margin.left);
		IF P.margin.bottom < P.offsY THEN
			P.margin.bottom := P.offsY
		END;
		P.FrameY := SHORT(P.margin.bottom);
		P.FrameW := SHORT(P.Width-P.margin.left-P.margin.right);
		IF (P.FrameX+P.FrameW) > (P.offsX+P.pageW) THEN
			P.margin.right := P.Width-P.pageW-P.margin.left;
			P.FrameW := SHORT(P.Width-P.margin.left-P.margin.right)
		END;
		P.FrameH := SHORT(P.Height-P.margin.top-P.margin.bottom);
		IF (P.FrameY+P.FrameH) > (P.offsY+P.pageH) THEN
			P.margin.top := P.Height-P.pageH-P.margin.bottom;
			P.FrameH := SHORT(P.Height-P.margin.top-P.margin.bottom)
		END
	END SetupDocFrame;

	PROCEDURE InitDocMetrics*(P: Printers.Printer);
		VAR
			M: Display.ControlMsg; N: Oberon.ControlMsg;
			str: ARRAY 8 OF CHAR; def: BOOLEAN;
	BEGIN
		WITH P: DocPrinter DO
			IF P.hDC = Kernel32.NULL THEN
				P.hDC := PrinterDC(P); def := P.hDC # Kernel32.NULL
			ELSE
				def := FALSE
			END;
			IF P.hDC # Kernel32.NULL THEN
				P.Width := SHORT(GDI32.GetDeviceCaps(P.hDC, GDI32.PhysicalWidth));
				P.Height := SHORT(GDI32.GetDeviceCaps(P.hDC, GDI32.PhysicalHeight));
				P.pageW := GDI32.GetDeviceCaps(P.hDC, GDI32.HorzRes);
				P.pageH := GDI32.GetDeviceCaps(P.hDC, GDI32.VertRes);
				P.offsX := GDI32.GetDeviceCaps(P.hDC, GDI32.PhysicalOffsetX);
				P.offsY := GDI32.GetDeviceCaps(P.hDC, GDI32.PhysicalOffsetY);
				P.offsY := P.Height-P.offsY-P.pageH;
				IF P.mode = GDI32.MMText THEN
					P.dpi := GDI32.GetDeviceCaps(P.hDC, GDI32.LogPixelsX)
				END;
				P.Depth := SHORT(GDI32.GetDeviceCaps(P.hDC, GDI32.BitsPixel))
			ELSE
				P.Width := 2480; P.Height := 3508;
				P.pageW := P.Width; P.pageH := P.Height;
				P.offsX := 0; P.offsY := 0;
				P.dpi := 300; P.Depth := 24
			END;
			P.Unit := 914400 DIV P.dpi;
			SetupDocFrame(P);
			IF def THEN
				GDI32.DeleteDC(P.hDC); P.hDC := Kernel32.NULL
			END;
			str := "Md?.Fnt";
			str[2] := CHR(ORD("0") + ((P.dpi+50) DIV 100) MOD 10);
			IF P.dpi >= 1000 THEN
				str[1] := CHR(ORD("0") + ((P.dpi+500) DIV 1000) MOD 10)
			END;
			Objects.Register(str, WinFonts.NewFont); (* e.g. Md3.Fnt *)
			str[0] := "P"; IF P.dpi < 1000 THEN str[1] := "r" END;
			Objects.Register(str, WinFonts.NewFont); (* e.g. Pr3.Fnt *)
			N.id := Oberon.neutralize; M.F := NIL; Display.Broadcast(N);
			M.id := Display.newprinter; M.F := NIL; Display.Broadcast(M);
			M.id := Display.suspend; M.F := NIL; Display.Broadcast(M);
			M.id := Display.restore; M.F := NIL; Display.Broadcast(M)
		END
	END InitDocMetrics;

	PROCEDURE InitMetrics*(P: Printers.Printer);
		VAR
			M: Display.ControlMsg; N: Oberon.ControlMsg;
			str: ARRAY 8 OF CHAR;
	BEGIN
		WITH P: Printer DO
			P.Depth := SHORT(GDI32.GetDeviceCaps(P.hDC, GDI32.BitsPixel));
			IF P.mode = GDI32.MMText THEN
				P.dpi := GDI32.GetDeviceCaps(P.hDC, GDI32.LogPixelsX)
			END;
			P.Unit := 914400 DIV P.dpi;
			IF (Printers.current # P) OR (Printers.Unit # P.Unit) OR (Printers.Depth # P.Depth) THEN
				str := "Md?.Fnt";
				str[2] := CHR(ORD("0") + ((P.dpi+50) DIV 100) MOD 10);
				IF P.dpi >= 1000 THEN
					str[1] := CHR(ORD("0") + ((P.dpi+500) DIV 1000) MOD 10)
				END;
				Objects.Register(str, WinFonts.NewFont); (* e.g. Md3.Fnt *)
				str[0] := "P"; IF P.dpi < 1000 THEN str[1] := "r" END;
				Objects.Register(str, WinFonts.NewFont); (* e.g. Pr3.Fnt *)
				N.id := Oberon.neutralize; M.F := NIL; Display.Broadcast(N);
				M.id := Display.newprinter; M.F := NIL; Display.Broadcast(M);
				M.id := Display.suspend; M.F := NIL; Display.Broadcast(M);
				M.id := Display.restore; M.F := NIL; Display.Broadcast(M)
			END
		END
	END InitMetrics;

	PROCEDURE ToPixel(P: DocPrinter; value: LONGINT): LONGINT;
	BEGIN
		IF P.psdUnit = COMDLG32.PSDInThousandthsOfInches THEN
			RETURN ENTIER(0.5 + value*P.dpi / 1000)
		ELSIF P.psdUnit = COMDLG32.PSDInHundredthsOfMillimeters THEN
			RETURN ENTIER(0.5 + value*P.dpi / 2540)
		END
	END ToPixel;

	PROCEDURE FromPixel(P: DocPrinter; value: LONGINT): LONGINT;
	BEGIN
		IF P.psdUnit = COMDLG32.PSDInThousandthsOfInches THEN
			RETURN ENTIER(0.5 + value*1000 / P.dpi)
		ELSIF P.psdUnit = COMDLG32.PSDInHundredthsOfMillimeters THEN
			RETURN ENTIER(0.5 + value*2540 / P.dpi)
		END
	END FromPixel;

	PROCEDURE LoadConfig(P: DocPrinter);
		VAR
			path, str: FileDir.FileName;
			adr: Kernel32.ADDRESS; offs: INTEGER;
	BEGIN
		Registry.OberonPath("Printer\WinPrinter", path);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Driver", str);
		IF Registry.res # Registry.Done THEN RETURN END;
		P.hDevNames := Kernel32.GlobalAlloc({Kernel32.GMemMoveable, Kernel32.GMemDDEShare}, 1024);
		adr := Kernel32.GlobalLock(P.hDevNames);
		SYSTEM.MOVE(SYSTEM.ADR(str), adr+8, 256);
		offs := 8; SYSTEM.PUT(adr, offs);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Device", str);
		SYSTEM.MOVE(SYSTEM.ADR(str), adr+8+256, 256);
		offs := 8+256; SYSTEM.PUT(adr+2, offs);
		offs := 0; SYSTEM.PUT(adr+4, offs);
		offs := 0; SYSTEM.PUT(adr+6, offs);
		Kernel32.GlobalUnlock(P.hDevNames);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Unit", str);
		IF str = "ThousendthsOfInches" THEN
			P.psdUnit := COMDLG32.PSDInThousandthsOfInches
		ELSIF str = "HundredthsOfMillimeters" THEN
			P.psdUnit := COMDLG32.PSDInHundredthsOfMillimeters
		ELSE
			HALT(99)
		END;
(* P.devMode := Kernel32.GlobalAlloc(Kernel32.GMemMoveable, ... *)
		P.InitMetrics(P);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Left", str);
		Strings.StrToInt(str, adr); P.margin.left := ToPixel(P, adr);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Right", str);
		Strings.StrToInt(str, adr); P.margin.right := ToPixel(P, adr);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Top", str);
		Strings.StrToInt(str, adr); P.margin.top := ToPixel(P, adr);
		Registry.GetKeyValue(Registry.CurrentUser, path, "Bottom", str);
		Strings.StrToInt(str, adr); P.margin.bottom := ToPixel(P, adr)
	END LoadConfig;

	PROCEDURE StoreConfig(P: DocPrinter);
		VAR
			path, str: FileDir.FileName;
			adr: Kernel32.ADDRESS; offs: INTEGER;
	BEGIN
		Registry.OberonPath("Printer\WinPrinter", path);
		adr := Kernel32.GlobalLock(P.hDevNames);
		SYSTEM.GET(adr, offs);
		Kernel32.CopyString(adr+offs, str);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Driver", str);
		SYSTEM.GET(adr+2, offs);
		Kernel32.CopyString(adr+offs, str);
		Kernel32.GlobalUnlock(P.hDevNames);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Device", str);
		IF P.psdUnit = COMDLG32.PSDInThousandthsOfInches THEN
			Registry.SetKeyValue(Registry.CurrentUser, path, "Unit", "ThousendthsOfInches")
		ELSIF P.psdUnit = COMDLG32.PSDInHundredthsOfMillimeters THEN
			Registry.SetKeyValue(Registry.CurrentUser, path, "Unit", "HundredthsOfMillimeters")
		ELSE
			HALT(99)
		END;
		adr := FromPixel(P, P.margin.left); Strings.IntToStr(adr, str);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Left", str);
		adr := FromPixel(P, P.margin.right); Strings.IntToStr(adr, str);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Right", str);
		adr := FromPixel(P, P.margin.top); Strings.IntToStr(adr, str);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Top", str);
		adr := FromPixel(P, P.margin.bottom); Strings.IntToStr(adr, str);
		Registry.SetKeyValue(Registry.CurrentUser, path, "Bottom", str)
(* adr := Kernel32.GlobalLock(P.devMode) *)
	END StoreConfig;

	PROCEDURE setupPrinter(P: DocPrinter; dialog: WinMenus.PageSetupDialog);
	BEGIN
		IF dialog.done THEN
			P.hDevNames := dialog.page.hDevNames; P.hDevMode := dialog.page.hDevMode;
			InitDocMetrics(P); P.setup := TRUE;
			IF COMDLG32.PSDInThousandthsOfInches IN dialog.page.Flags THEN
				P.psdUnit := COMDLG32.PSDInThousandthsOfInches
			ELSIF COMDLG32.PSDInHundredthsOfMillimeters IN dialog.page.Flags THEN
				P.psdUnit := COMDLG32.PSDInHundredthsOfMillimeters
			ELSE
				HALT(99)
			END;
			P.margin.left := ToPixel(P, dialog.page.rtMargin.left);
			P.margin.right := ToPixel(P, dialog.page.rtMargin.right);
			P.margin.top := ToPixel(P, dialog.page.rtMargin.top);
			P.margin.bottom := ToPixel(P, dialog.page.rtMargin.bottom);
			StoreConfig(P); Printers.Install(P)
		END
	END setupPrinter;

	PROCEDURE SetupPrinter*;
		VAR dialog: WinMenus.PageSetupDialog; P: DocPrinter;
	BEGIN
		IF (Oberon.Par.obj # NIL) & (Oberon.Par.obj IS WinMenus.PageSetupDialog) THEN
			dialog := Oberon.Par.obj(WinMenus.PageSetupDialog); P := dialog.context(DocPrinter);
			setupPrinter(P, dialog)
		END
	END SetupPrinter;

	PROCEDURE PageSetupDlg(P: DocPrinter; block: BOOLEAN): WinMenus.PageSetupDialog;
		VAR dialog: WinMenus.PageSetupDialog;
	BEGIN
		NEW(dialog); dialog.context := P; dialog.done := TRUE;
		IF ~block THEN dialog.cmd := "WinPrinter.SetupPrinter" END;
		dialog.page.lStructSize := SIZE(COMDLG32.PAGESETUPDLG);
		IF P # NIL THEN
			dialog.page.hDevNames := P.hDevNames; dialog.page.hDevMode := P.hDevMode
		ELSE
			dialog.page.hDevNames := Kernel32.NULL; dialog.page.hDevMode := Kernel32.NULL
		END;
		dialog.page.ptPaperSize.x := 0; dialog.page.ptPaperSize.y := 0;
		dialog.page.rtMinMargin.left := 0; dialog.page.rtMinMargin.right := 0;
		dialog.page.rtMinMargin.top := 0; dialog.page.rtMinMargin.bottom := 0;
		IF (P # NIL) & (P.psdUnit # 0) THEN
			dialog.page.Flags := {P.psdUnit, COMDLG32.PSDMargins};
			dialog.page.rtMargin.left := FromPixel(P, P.margin.left);
			dialog.page.rtMargin.right := FromPixel(P, P.margin.right);
			dialog.page.rtMargin.top := FromPixel(P, P.margin.top);
			dialog.page.rtMargin.bottom := FromPixel(P, P.margin.bottom)
		ELSE
			dialog.page.Flags := {};
			dialog.page.rtMargin.left := 0; dialog.page.rtMargin.right := 0;
			dialog.page.rtMargin.top := 0; dialog.page.rtMargin.bottom := 0
		END;
		dialog.page.hInstance := Kernel.hInstance; dialog.page.lCustData := 0;
		dialog.page.lpfnPageSetupHook := 0;
		dialog.page.lpfnPagePaintHook := 0;
		dialog.page.lpPageSetupTemplateName := 0;
		dialog.page.hPageSetupTemplate := 0;
		WinMenus.ShowDialog(dialog, block);
		IF dialog.done THEN
			IF block THEN setupPrinter(P, dialog) END;
			RETURN dialog
		ELSE
			RETURN NIL
		END
	END PageSetupDlg;

	PROCEDURE setupDoc(P: DocPrinter; block: BOOLEAN);
		VAR dialog: WinMenus.PageSetupDialog;
	BEGIN
		dialog := PageSetupDlg(P, block)
	END setupDoc;

	PROCEDURE OpenDoc*(P: Printers.Printer; printer, options: ARRAY OF CHAR);
		VAR
			i, j: LONGINT;
			docname: FileDir.FileName;
			doc: GDI32.DocInfo;
			dialog: WinMenus.PrintDialog;
	BEGIN
		WITH P: DocPrinter DO
			P.res := 1; (* no such printer *)
			IF ~P.setup & (Printers.current = P) THEN
				setupDoc(P, TRUE); IF ~P.setup THEN RETURN END
			END;
			dialog := PrintDlg(P, {COMDLG32.PDReturnDC});
			IF (dialog # NIL) & (dialog.print.hDC # Kernel32.NULL) THEN
				P.hDC := dialog.print.hDC;
				i := 0; j := -1;
				WHILE options[i] # 0X DO
					IF options[i] = Oberon.OptionChar THEN
						j := i
					END;
					INC(i)
				END;
				IF j >= 0 THEN
					INC(j); i := 0;
					WHILE options[j] # 0X DO
						docname[i] := options[j]; INC(i); INC(j)
					END;
					docname[i] := 0X
				ELSE
					docname := "Oberon Document"
				END;
				doc.cbSize := SIZE(GDI32.DocInfo); doc.lpszOutput := Kernel32.NULL;
				doc.lpszDatatype := 0; doc.fwType := 0;
				doc.lpszDocName := SYSTEM.ADR(docname);
				P.job := GDI32.StartDoc(P.hDC, doc);
				IF P.job > 0 THEN
					P.hDevNames := dialog.print.hDevNames; P.hDevMode := dialog.print.hDevMode;
					InitDocMetrics(P);
					P.newPage := TRUE; P.showPage := FALSE;
					P.color := 0; P.bkColor := 0FFFFFFH; P.textColor := 0; P.page := 0;
					IF COMDLG32.PDPageNums IN dialog.print.Flags THEN
						P.from := dialog.print.nFromPage; P.to := dialog.print.nToPage
					ELSE
						P.from := 0; P.to := MAX(INTEGER)
					END;
					P.hdcMem := GDI32.CreateCompatibleDC(P.hDC);
					P.res := 0 (* done *)
				END
			END
		END
	END OpenDoc;

	PROCEDURE CloseDoc*(P: Printers.Printer);
	BEGIN
		WITH P: DocPrinter DO
			IF P.hdcMem # Kernel32.NULL THEN
				GDI32.DeleteDC(P.hdcMem); P.hdcMem := Kernel32.NULL
			END;
			IF P.hDC # Kernel32.NULL THEN
				IF P.job > 0 THEN GDI32.EndDoc(P.hDC) END;
				GDI32.DeleteDC(P.hDC); P.hDC := Kernel32.NULL
			END;
			P.res := Printers.res
		END
	END CloseDoc;

	PROCEDURE NewPage(P: Printer);
	BEGIN
		INC(P.page);
		IF (P.page >= P.from) & (P.page <= P.to) THEN
			IF P IS DocPrinter THEN GDI32.StartPage(P.hDC) END;
			IF P.mode = GDI32.MMText THEN GDI32.SetMapMode(P.hDC, GDI32.MMText) END;
			GDI32.SetTextAlign(P.hDC, GDI32.TABaseline + GDI32.TALeft);
			GDI32.SetBkMode(P.hDC, GDI32.Transparent);
			GDI32.SetBkColor(P.hDC, P.bkColor); GDI32.SetTextColor(P.hDC, P.textColor);
			P.textX := P.FrameX; P.textY := P.FrameY;
			P.showPage := TRUE
		ELSE
			P.showPage := FALSE
		END;
		P.newPage := FALSE
	END NewPage;

	PROCEDURE Page*(P: Printers.Printer; nofcopies: INTEGER);
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage & (P IS DocPrinter) THEN GDI32.EndPage(P.hDC) END;
			P.newPage := TRUE
		END
	END Page;

	PROCEDURE ReplConst*(P: Printers.Printer; x, y, w, h: INTEGER);
		VAR hBr, hOldBr: GDI32.HBrush; px, py: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px := x; py := y;
				DEC(px, P.offsX); DEC(py, P.offsY);
				hBr := GDI32.CreateSolidBrush(P.color);
				hOldBr := GDI32.SelectObject(P.hDC, hBr);
				GDI32.PatBlt(P.hDC, px, P.pageH-py-h, w, h, GDI32.PatCopy);
				GDI32.SelectObject(P.hDC, hOldBr);
				GDI32.DeleteObject(hBr)
			END
		END
	END ReplConst;

	PROCEDURE SetTextColor(P: Printers.Printer; bkColor, textColor: LONGINT);
	BEGIN
		WITH P: Printer DO
			IF bkColor # P.bkColor THEN
				GDI32.SetBkColor(P.hDC, bkColor); P.bkColor := bkColor
			END;
			IF textColor # P.textColor THEN
				GDI32.SetTextColor(P.hDC, textColor); P.textColor := textColor
			END
		END
	END SetTextColor;

	PROCEDURE ReplPattern*(P: Printers.Printer; x, y, w, h, patno: INTEGER);
		VAR hPat, hOldPat: GDI32.HBrush; px, py: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px := x; py := y;
				DEC(px, P.offsX); DEC(py, P.offsY);
				SetTextColor(P, 0FFFFFFH, P.color);
				CASE patno OF
					2: hPat := GDI32.GetStockObject(1);
					|3: hPat := GDI32.GetStockObject(2);
					|4: hPat := GDI32.GetStockObject(3);
					|5: hPat := GDI32.GetStockObject(4);
					|6: hPat := GDI32.CreateHatchBrush(3, 0);
					|7: hPat := GDI32.CreateHatchBrush(2, 0);
					|8: hPat := GDI32.CreateHatchBrush(1, 0);
					|9: hPat := GDI32.CreateHatchBrush(0, 0);
				ELSE
					hPat := GDI32.GetStockObject(0);
				END;
				hOldPat := GDI32.SelectObject(P.hDC, hPat);
				GDI32.PatBlt(P.hDC, px, P.pageH-py-h, w, h, GDI32.PatCopy);
				GDI32.SelectObject(P.hDC, hOldPat);
				GDI32.DeleteObject(hPat)
			END
		END
	END ReplPattern;

	PROCEDURE Line*(P: Printers.Printer; x0, y0, x1, y1: INTEGER);
		VAR hPen, hOldPen: GDI32.HPen; px0, py0, px1, py1: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px0 := x0; py0 := y0; px1:= x1; py1 := y1;
				DEC(px0, P.offsX); DEC(py0, P.offsY);
				DEC(px1, P.offsX); DEC(py1, P.offsY);
				hPen := GDI32.CreatePen(GDI32.PSSolid, 0, P.color);
				hOldPen := GDI32.SelectObject(P.hDC, hPen);
				GDI32.MoveToEx(P.hDC, px0, P.pageH-py0, NIL);
				GDI32.LineTo(P.hDC, px1, P.pageH-py1);
				GDI32.SelectObject(P.hDC, hOldPen);
				GDI32.DeleteObject(hPen)
			END
		END
	END Line;

	PROCEDURE Circle*(P: Printers.Printer; x0, y0, r: INTEGER);
		VAR hBr, hOldBr: GDI32.HBrush; hPen, hOldPen: GDI32.HPen; px0, py0: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px0 := x0; py0 := y0;
				DEC(px0, P.offsX); DEC(py0, P.offsY);
				hPen := GDI32.CreatePen(GDI32.PSSolid, 0, P.color);
				hBr := GDI32.GetStockObject(GDI32.NullBrush);
				hOldPen := GDI32.SelectObject(P.hDC, hPen);
				hOldBr := GDI32.SelectObject(P.hDC, hBr);
				GDI32.Ellipse(P.hDC, px0-r, P.pageH-(py0+r), px0+r, P.pageH-(py0-r));
				GDI32.SelectObject(P.hDC, hOldBr);
				GDI32.SelectObject(P.hDC, hOldPen);
				GDI32.DeleteObject(hPen);
				GDI32.DeleteObject(hBr)
			END
		END
	END Circle;

	PROCEDURE Ellipse*(P: Printers.Printer; x0, y0, a, b: INTEGER);
		VAR hBr, hOldBr: GDI32.HBrush; hPen, hOldPen: GDI32.HPen; px0, py0: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px0 := x0; py0 := y0;
				DEC(px0, P.offsX); DEC(py0, P.offsY);
				hPen := GDI32.CreatePen(GDI32.PSSolid, 0, P.color);
				hBr := GDI32.GetStockObject(GDI32.NullBrush);
				hOldPen := GDI32.SelectObject(P.hDC, hPen);
				hOldBr := GDI32.SelectObject(P.hDC, hBr);
				GDI32.Ellipse(P.hDC, px0-a, P.pageH-(py0+b), px0+a, P.pageH-(py0-b));
				GDI32.SelectObject(P.hDC, hOldBr);
				GDI32.SelectObject(P.hDC, hOldPen);
				GDI32.DeleteObject(hPen);
				GDI32.DeleteObject(hBr)
			END
		END
	END Ellipse;

	PROCEDURE Spline*(P: Printers.Printer; x0, y0, n, open: INTEGER; VAR X, Y: ARRAY OF INTEGER);
	BEGIN
HALT(99)
	END Spline;

	PROCEDURE Picture*(P: Printers.Printer; pict: Pictures.Picture; sx, sy, sw, sh, dx, dy, dw, dh, mode: INTEGER);
		VAR pdx, pdy: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				pdx := dx; pdy := dy;
				DEC(pdx, P.offsX); DEC(pdy, P.offsY);
				GDI32.StretchDIBits(P.hDC, pdx, P.pageH-(pdy+dh), dw, dh, sx, sy, sw, sh, pict.bits, pict.bmi, GDI32.DIBRGBColors, GDI32.SrcCopy)
			END
		END
	END Picture;

	PROCEDURE UseListFont*(P: Printers.Printer; name: ARRAY OF CHAR);
	BEGIN
HALT(99)
	END UseListFont;

	PROCEDURE *printerDC(class: ARRAY OF CHAR): User32.HDC;
		VAR P: Printer; hDC: User32.HDC;
	BEGIN
		WinFonts.keepDC := FALSE; WinFonts.unit := -1;
		IF (Printers.current # NIL) & (Printers.current IS Printer) THEN
			P := Printers.current(Printer);
			IF P IS DocPrinter THEN
				hDC := PrinterDC(P(DocPrinter))
			ELSE
				hDC := P.hDC; WinFonts.unit := P.dpi;
				WinFonts.keepDC := TRUE
			END
		END;
		IF hDC = Kernel32.NULL THEN
			hDC := PrinterDC(NIL); WinFonts.keepDC := FALSE
		END;
		IF WinFonts.unit <= 0 THEN
			WinFonts.unit := GDI32.GetDeviceCaps(hDC, GDI32.LogPixelsY)
		END;
		RETURN hDC
	END printerDC;

	PROCEDURE PrintString(P: Printer; F: Fonts.Font; VAR s: ARRAY OF CHAR);
		VAR
			family, tmp: FileDir.FileName;
			class: ARRAY 8 OF CHAR;
			i: LONGINT;
			style: SET; size: User32.Size;
			font: Displays.Font;
			hOldFont: GDI32.HFont; hOldBm: GDI32.HBitmap;
			pat: Display.Pattern; p: Displays.Pattern;
			dx, x, y, w, h: INTEGER;
	BEGIN
		WinFonts.ParseName(F.name, family, i, style, class);
		class := "Pr?";
		class[2] := CHR(ORD("0") + ((P.dpi+50) DIV 100) MOD 10);
		IF P.dpi >= 1000 THEN
			class[1] := CHR(ORD("0") + ((P.dpi+500) DIV 1000) MOD 10)
		END;
		WinFonts.BuildName(tmp, family, i, style, class);
		F := Fonts.This(tmp);
		font := SYSTEM.VAL(Displays.Font, F.ind);
		IF font.hFont # Kernel32.NULL THEN
			i := 0;
			WHILE s[i] # 0X DO
				s[i] := Strings.OberonToISO[ORD(s[i])]; INC(i)
			END;
			hOldFont := GDI32.SelectObject(P.hDC, font.hFont);
			SetTextColor(P, 0FFFFFFH, P.color);
			GDI32.TextOut(P.hDC, P.textX, P.textY, s, i);
			GDI32.GetTextExtentPoint(P.hDC, s, i, size);
			GDI32.SelectObject(P.hDC, hOldFont);
			INC(P.textX, size.cx)
		ELSIF font IS Displays.RasterFont THEN
			WITH font: Displays.RasterFont DO
				i := 0;
				WHILE s[i] # 0X DO
					Fonts.GetChar(F, s[i], dx, x, y, w, h, pat);
					ASSERT((pat < 0) OR (pat >= Display.FirstPattern));
					p := SYSTEM.VAL(Displays.Pattern, pat);
					hOldBm := GDI32.SelectObject(P.hdcMem, p.hBm);
SetTextColor(P, 0FFFFFFH, P.color);
GDI32.BitBlt(P.hDC, P.textX+x, P.textY-y-p.h, w, h, P.hdcMem, p.x, p.y, GDI32.SrcAnd);
					GDI32.SelectObject(P.hdcMem, hOldBm);
					INC(i); INC(P.textX, LONG(dx))
				END
			END
		ELSE
			HALT(99)
		END
	END PrintString;

	PROCEDURE ContString*(P: Printers.Printer; s: ARRAY OF CHAR; fnt: Fonts.Font);
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				PrintString(P, fnt, s)
			END
		END
	END ContString;

	PROCEDURE String*(P: Printers.Printer; x, y: INTEGER; s: ARRAY OF CHAR; fnt: Fonts.Font);
		VAR px, py: LONGINT;
	BEGIN
		WITH P: Printer DO
			IF P.newPage THEN NewPage(P) END;
			IF P.showPage THEN
				px := x; py := y;
				DEC(px, P.offsX); DEC(py, P.offsY);
				P.textX := px; P.textY := P.pageH-py;
				PrintString(P, fnt, s)
			END
		END
	END String;

	PROCEDURE UseColor*(P: Printers.Printer; red, green, blue: INTEGER);
	BEGIN
		WITH P: Printer DO
			P.color := GDI32.RGB(red, green, blue)
		END
	END UseColor;

	PROCEDURE GetMetric*(P: Printers.Printer; fnt: Fonts.Font): Fonts.Font;
		VAR
			name: FileDir.FileName;
			metric: Fonts.Font;
			i: LONGINT;
	BEGIN
		WITH P: Printer DO
			COPY(fnt.name, name);
			i := 0; WHILE (name[i] # ".") & (name[i] # 0X) DO INC(i) END;
			name[i] := "."; name[i+1] := "M";
			IF P.dpi >= 1000 THEN
				name[i+2] := CHR(ORD("0") + ((P.dpi+500) DIV 1000) MOD 10)
			ELSE
				name[i+2] := "d"
			END;
			name[i+3] := CHR(ORD("0") + ((P.dpi+50) DIV 100) MOD 10);
			name[i+4] := "."; name[i+5] := "F"; name[i+6] := "n"; name[i+7] := "t";
			name[i+8] := 0X;
			metric := Fonts.This(name);
			IF metric.type = Fonts.substitute THEN metric := NIL END
		END;
		RETURN metric
	END GetMetric;

	PROCEDURE Init*(P: Printer);
	BEGIN
		P.gen := ""; P.Unit := 0;
		P.InitMetrics := InitMetrics;
		P.Open := NIL;
		P.Close := NIL;
		P.Page := Page;
		P.ReplConst := ReplConst; 
		P.ReplPattern := ReplPattern;
		P.Line := Line;
		P.Circle := Circle;
		P.Ellipse := Ellipse;
		P.Spline := Spline;
		P.Picture := Picture;
		P.UseListFont := UseListFont;
		P.String := String;
		P.ContString := ContString;
		P.UseColor := UseColor;
		P.GetMetric := GetMetric;
		P.hDC := Kernel32.NULL; P.hdcMem := Kernel32.NULL;
		P.dpi := 0; P.color := 0; P.mode := GDI32.MMText;
		P.color := 0; P.bkColor := 0FFFFFFH; P.textColor := 0;
		P.textX := 0; P.textY := 0;
		P.pageW := 0; P.pageH := 0;
		P.offsX := 0; P.offsY := 0;
		P.page := 0; P.from := 0; P.to := MAX(INTEGER);
		P.newPage := FALSE; P.showPage := FALSE
	END Init;

	PROCEDURE InitDoc*(P: DocPrinter);
	BEGIN
		Init(P); P.gen := "WinPrinter.Install";
		P.InitMetrics := InitDocMetrics;
		P.Open := OpenDoc;
		P.Close := CloseDoc;
		P.job := 0; P.psdUnit := 0;
		P.hDevMode := Kernel32.NULL; P.hDevNames := Kernel32.NULL;
		P.margin.left := 0; P.margin.right := 0;
		P.margin.top := 0; P.margin.bottom := 0;
		P.setup := FALSE; LoadConfig(P)
	END InitDoc;

	PROCEDURE Install*;
		VAR P: DocPrinter;
	BEGIN
		NEW(P); InitDoc(P);
		Printers.Install(P);
		WinFonts.printerDC := printerDC
	END Install;

	(** Open the printers page setup dialog *)
	PROCEDURE Setup*;
	BEGIN
		IF (Printers.current = NIL) OR ~(Printers.current IS DocPrinter) THEN
			Install()
		END;
		IF (Printers.current # NIL) & (Printers.current IS DocPrinter) THEN
			setupDoc(Printers.current(DocPrinter), FALSE)
		END
	END Setup;

	(** Reset stored printer settings and choose a new printer *)
	PROCEDURE Reset*;
		VAR path: FileDir.FileName;
	BEGIN
		IF (Printers.current # NIL) & (Printers.current IS DocPrinter) THEN
			Registry.OberonPath("Printer\WinPrinter", path);
			Registry.DeletePath(Registry.CurrentUser, path);
			setupDoc(Printers.current(DocPrinter), FALSE)
		END
	END Reset;

	PROCEDURE [WINAPI] *WinFontEnum(lpelf: GDI32.EnumLogFont; lpntm: GDI32.TextMetric; FontType: SET; lParam: User32.LParam): LONGINT;
		VAR name: FileDir.FileName;
	BEGIN
		IF GDI32.TrueTypeFontType IN FontType THEN
			COPY(lpelf.elfFullName, name);
			Texts.WriteString(W, name); Texts.WriteLn(W)
		END;
		RETURN 1
	END WinFontEnum;

	(** list available font families *)
	PROCEDURE ListFonts*;
		VAR hDC: User32.HDC;
	BEGIN
		hDC := PrinterDC(NIL);
		GDI32.EnumFontFamilies(hDC, NIL, WinFontEnum, 0);
		ASSERT(GDI32.DeleteDC(hDC) # Kernel32.False, 32);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END ListFonts;

	(** Start printing using a device context given by an external application. *)
	PROCEDURE StartPrint*(hDC: User32.HDC; Unit, X, Y, W, H: LONGINT): Printer;
		VAR P: ExtPrinter;
	BEGIN
		WinFonts.printerDC := printerDC;
		NEW(P); Init(P); P.hDC := hDC;
		P.oldP := Printers.current;
		P.nSavedDC := GDI32.SaveDC(P.hDC);
		P.mode := GDI32.GetMapMode(P.hDC);
		P.pageW := X+W; P.pageH := Y+H;
		P.Width := SHORT(P.pageW); P.Height := SHORT(P.pageH);
		P.offsX := 0; P.offsY := 0;
		P.FrameX := SHORT(X); P.FrameY := 0;
		P.FrameW := SHORT(W); P.FrameH := SHORT(H);
		P.Unit := Unit; (* V.dsc.W*Display.Unit DIV print.W *)
		P.dpi := 914400 DIV P.Unit;
		P.newPage := TRUE; P.showPage := FALSE;
		P.color := 0; P.bkColor := 0FFFFFFH; P.textColor := 0;
		P.hdcMem := GDI32.CreateCompatibleDC(P.hDC);
		Printers.current := P; Printers.Install(P);
		P.res := 0; RETURN P
	END StartPrint;

	(** End printing started with StartPrint. IF p.res = -1 then no print commands were called. *)
	PROCEDURE EndPrint*(P: Printer);
	BEGIN
		WITH P: ExtPrinter DO
			IF P.hdcMem # Kernel32.NULL THEN
				GDI32.DeleteDC(P.hdcMem); P.hdcMem := Kernel32.NULL
			END;
			GDI32.GdiFlush();
			GDI32.RestoreDC(P.hDC, P.nSavedDC);
			Printers.Install(P.oldP);
			IF P.page # 1 THEN P.res := -1 END
		END
	END EndPrint;

BEGIN
	Texts.OpenWriter(W)
END WinPrinter.

PrinterInfo.Panel

WinPrinter.Install
WinPrinter.Setup
WinPrinter.ListFonts

System.Set Fonts Syntax := Tahoma ~
System.Set Fonts Oberon := Arial ~
System.Set Fonts Courier := "Courier New" ~
BIER$p  5p   o    <       g 
     C  Syntax10.Scn.Fnt 30.07.2004  20:15:02  TimeStamps.New  