TextDocs.NewDoc     )Yg   CWindowsLeft r   WindowsTop    Color    Flat  Locked  Controls  Org ,   BIER           3  z   Syntax10.Scn.Fnt          [  Oberon10.Scn.Fnt                           	   '  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE V24; (** portable / source: Win32.V24.Mod *)	(* ejz   *)
	IMPORT S := SYSTEM, Kernel32, Modules;

(** V24/RS232 serial communications interface. *)

	CONST
		(** Port aliases (check with NumberOfPorts) *)
		COM1* = 0; COM2* = 1; COM3* = 2; COM4* = 3;
		COM5* = 4;  COM6* = 5;  COM7* = 6;  COM8* = 7;

		(** Parity *)
		ParNo* = 0; ParOdd* = 1; ParEven* = 2; ParMark* = 3; ParSpace* = 4;

		(** Stop bits *)
		Stop1* = 1; Stop2* = 2; Stop1dot5* = 3;

		(** Modem control lines *)
		DTR* = 0; RTS* = 1; (** output *)
		Break* = 2; (** input/output *)
		DSR* = 3; CTS* = 4; RI* = 5; DCD* = 6; (** input *)

		Ok* = 0; PortInUse* = 1; NoSuchPort* = 2;
		WrongBPS* = 3; WrongData* = 4; WrongParity* = 5; WrongStop* = 6; Failed* = MAX(INTEGER);

		NPorts = 255; (* COM1 .. COM255 *)

	TYPE
		Handle = POINTER TO RECORD (Kernel32.Object)
			port: LONGINT
		END;

	VAR
		ports: ARRAY NPorts OF Handle;

(** NumberOfPorts - Return maximum number of ports available.
	Use GetDeviceName to check if a given port exists. *)
	PROCEDURE NumberOfPorts*(): LONGINT;
	BEGIN
		RETURN NPorts
	END NumberOfPorts;

(** Returns the DOS device name (COMx).
	Will return a device name for any port number from 0 .. NumberOfPorts()-1 *)
	PROCEDURE DosDeviceName(port: LONGINT; long: BOOLEAN; VAR dev: ARRAY OF CHAR; VAR res: LONGINT);
		VAR i: LONGINT;
	BEGIN
		IF (port >= 0) OR (port < NPorts) THEN
			res := Ok; INC(port);
			IF port < 10 THEN
				COPY("COM", dev); i := 3
			ELSE
				IF long THEN
					COPY("\\.\COM", dev); i := 7
				ELSE
					COPY("COM", dev); i := 3
				END;
				IF port >= 100 THEN
					dev[i] := CHR((port DIV 100) + ORD("0")); INC(i);
					dev[i] := CHR(((port MOD 100) DIV 10) + ORD("0")); INC(i)
				ELSE
					dev[i] := CHR((port DIV 10) + ORD("0")); INC(i)
				END
			END;
			dev[i] := CHR((port MOD 10) + ORD("0")); INC(i);
			dev[i] := 0X
		ELSE
			res := NoSuchPort; COPY("", dev)
		END
	END DosDeviceName;

(** Returns the Windows device name e.g. \device\serial0.
	Will return a device name only if the port exists. *)
	PROCEDURE GetDeviceName*(port: LONGINT; VAR dev: ARRAY OF CHAR; VAR res: LONGINT);
		VAR ret: LONGINT;
	BEGIN
		DosDeviceName(port, FALSE, dev, res);
		IF res = Ok THEN
			ret := Kernel32.QueryDosDevice(dev, dev, LEN(dev));
			IF ret # 0 THEN
				res := Ok
			ELSE
				res := NoSuchPort; COPY("", dev)
			END
		END
	END GetDeviceName;

	PROCEDURE *Finalize(handle: Handle);
		VAR res: Kernel32.BOOL;
	BEGIN
		IF handle.handle # Kernel32.InvalidHandleValue THEN
			res := Kernel32.CloseHandle(handle.handle);
			handle.handle := Kernel32.InvalidHandleValue
		END;
		IF handle.port >= 0 THEN
			ports[handle.port] := NIL; handle.port := -1
		END
	END Finalize;

(** Start - Open a serial port (numbered from 0) connection.  bps is the required bits per second.
	data is the number of bits per communication unit.  parity is the parity mode (Par values above). 
	stop is the number of stop bits (Stop values above).
	res: Ok, PortInUse, NoSuchPort, WrongBPS, WrongData, WrongParity, WrongStop, Failed *)
	PROCEDURE Start*(port, bps, data, parity, stop: LONGINT; VAR res: LONGINT);
		VAR
			dev: ARRAY 16 OF CHAR; hFile: Kernel32.HANDLE; handle: Handle;
			dcb: Kernel32.DCB; ret: Kernel32.BOOL; err: LONGINT;
	BEGIN
		IF (port < 0) OR (port >= NPorts) THEN
			res := NoSuchPort
		ELSIF ports[port] # NIL THEN
			res := PortInUse
		ELSE
			DosDeviceName(port, TRUE, dev, res)
		END;
		IF res # Ok THEN RETURN END;
		hFile := Kernel32.CreateFile(dev, {Kernel32.GenericRead, Kernel32.GenericWrite}, {}, NIL, Kernel32.OpenExisting, {}, Kernel32.NULL);
		IF hFile # Kernel32.InvalidHandleValue THEN
			ret := Kernel32.GetCommState(hFile, dcb);
			IF ret # Kernel32.False THEN
				dcb.BaudRate := bps;
				IF (data >= 4) & (data <= 8) THEN
					dcb.ByteSize := CHR(data)
				ELSE
					res := WrongData
				END;
				CASE stop OF
					Stop1: dcb.StopBits := Kernel32.OneStopBit
					|Stop1dot5: dcb.StopBits := Kernel32.One5StopBits
					|Stop2: dcb.StopBits := Kernel32.TwoStopBits
				ELSE
					res := WrongStop
				END;
				CASE parity OF
					ParNo: dcb.Parity := Kernel32.NoParity
					|ParOdd: dcb.Parity := Kernel32.OddParity
					|ParEven: dcb.Parity := Kernel32.EvenParity
					|ParMark: dcb.Parity := Kernel32.MarkParity
					|ParSpace: dcb.Parity := Kernel32.SpaceParity
				ELSE
					res := WrongParity
				END;
				IF res = Ok THEN
					ret := Kernel32.SetCommState(hFile, dcb);
					IF ret # Kernel32.False THEN
						ret := Kernel32.PurgeComm(hFile, {Kernel32.PurgeTXClear, Kernel32.PurgeRXClear});
						ret := Kernel32.SetupComm(hFile, 800H, 800H);
						NEW(handle); handle.port := port; handle.handle := hFile;
						ports[port] := handle;
						RETURN
					END
				END
			END;
			ret := Kernel32.CloseHandle(hFile)
		END;
		IF res = Ok THEN
			err := Kernel32.GetLastError();
			CASE err OF
				Kernel32.ErrorFileNotFound: res := NoSuchPort
				|Kernel32.ErrorAccessDenied: res := PortInUse
				|Kernel32.ErrorInvalidParameter: res := WrongBPS
			ELSE
				res := Failed
			END
		END
	END Start;

(** Stop - Close the connection of the specified port. *)
	PROCEDURE Stop*(port: LONGINT);
		VAR handle: Handle;
	BEGIN
		handle := S.VAL(Handle, ports[port]);
		IF handle # NIL THEN Finalize(handle) END
	END Stop;

(** Available - Return the number of bytes available in the specified port's buffer. *)
	PROCEDURE Available*(port: LONGINT): LONGINT;
		VAR handle: Handle; errors: SET; stat: Kernel32.ComStat; res: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]);
		IF handle # NIL THEN
			res := Kernel32.ClearCommError(handle.handle, errors, stat);
			IF res # Kernel32.False THEN RETURN stat.cbInQue END
		END;
		RETURN 0
	END Available;

(** Send - Send a byte to the specified port. Waits until buffer space is available.
	res = Ok iff ok. *)
	PROCEDURE Send*(port: LONGINT; x: S.BYTE; VAR res: LONGINT);
		VAR handle: Handle; written: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]); res := Failed;
		IF handle # NIL THEN
			ret := Kernel32.WriteFile(handle.handle, x, 1, written, NIL);
			IF (ret # Kernel32.False) & (written = 1) THEN res := Ok END
		END
	END Send;

(** SendBytes - Send n bytes to the specified port. Waits until buffer space is available.
	res = Ok iff all ok. *)
	PROCEDURE SendBytes*(port: LONGINT; VAR x: ARRAY OF S.BYTE; n: LONGINT; VAR res: LONGINT);
		VAR handle: Handle; written: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		ASSERT(LEN(x) >= n);
		handle := S.VAL(Handle, ports[port]); res := Failed;
		IF handle # NIL THEN
			ret := Kernel32.WriteFile(handle.handle, x, n, written, NIL);
			IF (ret # Kernel32.False) & (written = n) THEN res := Ok END
		END
	END SendBytes;

(** Receive - Read one byte from the specified port. Waits until a byte is available.
	res = Ok iff ok. *)
	PROCEDURE Receive*(port: LONGINT; VAR x: S.BYTE; VAR res: LONGINT);
		VAR handle: Handle; read: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]); res := Failed;
		IF handle # NIL THEN
			ret := Kernel32.ReadFile(handle.handle, x, 1, read, NIL);
			IF (ret # Kernel32.False) & (read = 1) THEN res := Ok END
		END
	END Receive;

(** ReceiveBytes - Read n bytes from the specified port. Waits until n bytes are available.
	res = Ok iff ok. *)
	PROCEDURE ReceiveBytes*(port: LONGINT; VAR x: ARRAY OF S.BYTE; n: LONGINT; VAR res: LONGINT);
		VAR handle: Handle; read: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		ASSERT(LEN(x) >= n);
		handle := S.VAL(Handle, ports[port]); res := Failed;
		IF handle # NIL THEN
			ret := Kernel32.ReadFile(handle.handle, x, n, read, NIL);
			IF (ret # Kernel32.False) & (read = n) THEN res := Ok END
		END
	END ReceiveBytes;

(** ClearMC - Clear the specified modem control lines. s may contain DTR, RTS & Break. *)
	PROCEDURE ClearMC*(port: LONGINT; s: SET);
		VAR handle: Handle; res: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]);
		IF handle # NIL THEN
			IF Break IN s THEN
				res := Kernel32.ClearCommBreak(handle.handle)
			END;
			IF DTR IN s THEN
				res := Kernel32.EscapeCommFunction(handle.handle, Kernel32.CLRDTR)
			END;
			IF RTS IN s THEN
				res := Kernel32.EscapeCommFunction(handle.handle, Kernel32.CLRRTS)
			END
		END
	END ClearMC;

(** GetMC - Return the state of the specified modem control lines. s contains the current state
		of DSR, CTS, RI, DCD & Break. *)
	PROCEDURE GetMC*(port: LONGINT; VAR s: SET);
		VAR handle: Handle; state: SET; res: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]); s := {};
		IF handle # NIL THEN
			res := Kernel32.GetCommModemStatus(handle.handle, state);
			IF Kernel32.MSCTSOn IN state THEN
				INCL(s, CTS)
			END;
			IF Kernel32.MSDSROn IN state THEN
				INCL(s, DSR)
			END;
			IF Kernel32.MSRingOn IN state THEN
				INCL(s, RI)
			END;
			IF Kernel32.MSRLSDOn IN state THEN
				INCL(s, DCD)
			END
		END
	END GetMC;

(** SetMC - Set the specified modem control lines. s may contain DTR, RTS & Break. *)
	PROCEDURE SetMC*(port: LONGINT; s: SET);
		VAR handle: Handle; res: Kernel32.BOOL;
	BEGIN
		handle := S.VAL(Handle, ports[port]);
		IF handle # NIL THEN
			IF Break IN s THEN
				res := Kernel32.SetCommBreak(handle.handle)
			END;
			IF DTR IN s THEN
				res := Kernel32.EscapeCommFunction(handle.handle, Kernel32.SETDTR)
			END;
			IF RTS IN s THEN
				res := Kernel32.EscapeCommFunction(handle.handle, Kernel32.SETRTS)
			END
		END	
	END SetMC;

	PROCEDURE *TermMod();
		VAR handle: Handle; i: LONGINT;
	BEGIN
		i := 0;
		WHILE i < NPorts DO
			handle := S.VAL(Handle, ports[i]);
			IF handle # NIL THEN Finalize(handle) END;
			INC(i)
		END
	END TermMod;

	PROCEDURE Init();
		VAR i: LONGINT;
	BEGIN
		i := 0;
		WHILE i < NPorts DO
			ports[i] := NIL; INC(i)
		END;
		Modules.InstallTermHandler(TermMod)
	END Init;

BEGIN
	Init()
END V24.
BIER](  n(   (    <       g 
     C  Syntax10.Scn.Fnt 07.09.2006  08:40:49  TimeStamps.New  