TextDocs.NewDoc     Gg   CColor    Flat  Locked  Controls  Org 	  WindowsLeft E  WindowsTop <    BIER           3     Oberon10.Scn.Fnt     Syntax10.Scn.Fnt                      _   7   n        %        S        %                %        S        %                %           @  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE V24Log; (** portable *)	(* ejz,   *)
	IMPORT FileDir, Modules, V24, Input, Strings, Texts, Oberon;

	CONST
		CR = 0DX; LF = 0AX; Tab = 09X;

	VAR
		W: Texts.Writer;
		T: Oberon.Task;
		res: LONGINT;
		last: CHAR;
		Port: LONGINT;

	PROCEDURE *Poller(me: Oberon.Task);
		VAR
			avail: LONGINT;
			ch: CHAR;
	BEGIN
		avail := V24.Available(Port);
		IF avail > 0 THEN
			WHILE avail > 0 DO
				V24.Receive(Port, ch, res);
				IF ch >= " " THEN
					Texts.Write(W, ch)
				ELSIF (ch = LF) & (last # CR) THEN
					Texts.WriteLn(W)
				ELSIF (ch = CR) OR (ch = Tab) THEN
					Texts.Write(W, ch)
				END;
				last := ch; DEC(avail)
			END;
			Texts.Append(Oberon.Log, W.buf);
			me.time := Oberon.Time()
		ELSE
			me.time := Oberon.Time() + (Input.TimeUnit DIV 20)
		END
	END Poller;

	PROCEDURE GetPar(VAR port, bps, data, parity, stop: LONGINT);
		VAR S: Texts.Scanner;
	BEGIN
		port := V24.COM1; bps := 9600;
		data := 8; stop := V24.Stop1; parity := V24.ParNo;
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
		IF S.class IN {Texts.Name, Texts.String} THEN
			Strings.Lower(S.s, S.s);
			IF Strings.Prefix("com", S.s) & (S.s[3] >= "1") & (S.s[3] <= "9") THEN
				port := ORD(S.s[3]) - ORD("1")
			ELSE
				RETURN
			END
		ELSIF (S.class = Texts.Int) & (S.i >= 0) THEN
			port := S.i
		ELSE
			RETURN		
		END;
		Texts.Scan(S);
		IF S.class = Texts.Int THEN
			bps := S.i; Texts.Scan(S);
			IF (S.class = Texts.Int) & (S.i >= 5) & (S.i <= 8) THEN
				data := S.i; Texts.Scan(S);
				IF S.class IN {Texts.Name, Texts.String} THEN
					IF CAP(S.s[0]) = "N" THEN parity := V24.ParNo
					ELSIF CAP(S.s[0]) = "O" THEN parity := V24.ParOdd
					ELSIF CAP(S.s[0]) = "E" THEN parity := V24.ParEven
					ELSE parity := V24.ParNo
					END;
					Texts.Scan(S);
					IF (S.class = Texts.Int) & (S.i >= 1) & (S.i <= 2) THEN
						IF S.i = 1 THEN stop := V24.Stop1 ELSE stop := V24.Stop2 END
					END
				END
			END
		END
	END GetPar;
	
	PROCEDURE Start*;	(* port bps databits none|even|odd stopbits *)
		VAR errMsg: ARRAY 32 OF CHAR;
			Baud, Data, Parity, StopB: LONGINT;
	BEGIN
		Texts.WriteString(W, "V24Log.Start ");
		IF T = NIL THEN
			GetPar(Port, Baud, Data, Parity, StopB);
			Texts.WriteInt(W, Port, 1); Texts.Write(W, " ");
			Texts.WriteInt(W, Baud, 1); Texts.WriteInt(W, Data, 2);
			CASE Parity OF
				V24.ParNo: Texts.WriteString(W, " none")
				|V24.ParOdd: Texts.WriteString(W, " odd")
				|V24.ParEven: Texts.WriteString(W, " even")
			END;
			Texts.WriteInt(W, StopB, 2); Texts.Write(W, " ");
			V24.Start(Port, Baud, Data, Parity, StopB, res);
			IF res = 0 THEN
				NEW(T); T.handle := Poller; T.time := Oberon.Time(); T.safe := FALSE;
				Oberon.Install(T); last := 0X
			END;
			CASE res OF
				0: errMsg := "ok"
				|1: errMsg := "port in use"
				|2: errMsg := "no such port"
				|3: errMsg := "bad bps"
				|4: errMsg := "bad data"
			ELSE
				errMsg := "failed"
			END
		ELSE
			errMsg := "log in use"
		END;
		Texts.WriteString(W, errMsg);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END Start;

	PROCEDURE *stop();
	BEGIN
		IF T # NIL THEN
			V24.Stop(Port);
			Oberon.Remove(T); T := NIL
		END
	END stop;

	PROCEDURE Stop*;
	BEGIN
		Texts.WriteString(W, "V24Log.Stop ");
		IF T # NIL THEN
			stop();
			Texts.WriteString(W, "ok")
		ELSE
			Texts.WriteString(W, "not started")
		END;
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END Stop;

	PROCEDURE Send*;
		VAR S: Texts.Scanner;
	BEGIN
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		IF S.class IN {Texts.Name, Texts.String} THEN
			V24.SendBytes(Port, S.s, S.len, res)
		END
	END Send;

	PROCEDURE SendLn*;
		VAR str: ARRAY 4 OF CHAR;
	BEGIN
		str[0] := CR; str[1] := LF; str[2] := 0X;
		V24.SendBytes(Port, str, 2, res)
	END SendLn;

	PROCEDURE List*;
		VAR port, n, res: LONGINT; dev: FileDir.FileName;
	BEGIN
		port := 0; n := V24.NumberOfPorts();
		WHILE port < n DO
			V24.GetDeviceName(port, dev, res);
			IF res = V24.Ok THEN
				Texts.WriteInt(W, port, 0); Texts.Write(W, 09X);
				Texts.WriteString(W, "COM"); Texts.WriteInt(W, port+1, 0); Texts.Write(W, 09X);
				Texts.WriteString(W, dev); Texts.WriteLn(W)
			END;
			INC(port)
		END;
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END List;

	PROCEDURE WriteMC(mc: SET);
	BEGIN
		IF V24.DTR IN mc THEN
			Texts.WriteString(W, "DTR ")
		END;
		IF V24.RTS IN mc THEN
			Texts.WriteString(W, "RTS ")
		END;
		IF V24.Break IN mc THEN
			Texts.WriteString(W, "Break ")
		END;
		IF V24.DSR IN mc THEN
			Texts.WriteString(W, "DSR ")
		END;
		IF V24.CTS IN mc THEN
			Texts.WriteString(W, "CTS ")
		END;
		IF V24.RI IN mc THEN
			Texts.WriteString(W, "RI ")
		END;
		IF V24.DCD IN mc THEN
			Texts.WriteString(W, "DCD ")
		END
	END WriteMC;

	PROCEDURE GetMC*;
		VAR mc: SET;
	BEGIN
		V24.GetMC(Port, mc);
		Texts.WriteString(W, "GetMC ");
		WriteMC(mc);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END GetMC;

	PROCEDURE ScanMC(VAR mc: SET);
		VAR S: Texts.Scanner;
	BEGIN
		mc := {};
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		WHILE S.class IN {Texts.Name, Texts.String} DO
			Strings.Lower(S.s, S.s);
			IF S.s = "dtr" THEN
				INCL(mc, V24.DTR)
			ELSIF S.s = "rts" THEN
				INCL(mc, V24.RTS)
			ELSIF S.s = "break" THEN
				INCL(mc, V24.Break)
			END;
			Texts.Scan(S)
		END
	END ScanMC;

	PROCEDURE SetMC*;
		VAR mc: SET;
	BEGIN
		ScanMC(mc);
		Texts.WriteString(W, "SetMC ");
		WriteMC(mc);
		V24.SetMC(Port, mc);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END SetMC;

	PROCEDURE ClearMC*;
		VAR mc: SET;
	BEGIN
		ScanMC(mc);
		Texts.WriteString(W, "ClearMC ");
		WriteMC(mc);
		V24.ClearMC(Port, mc);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END ClearMC;

BEGIN
	Texts.OpenWriter(W); T := NIL;
	Modules.InstallTermHandler(stop)
END V24Log.

V24Log.Start ~
V24Log.Start 0 9600 8 none 1 ~
V24Log.Stop

V24Log.GetMC
V24Log.SetMC RTS ~
V24Log.SetMC DTR ~
V24Log.ClearMC DTR RTS ~

V24Log.Send ATZ
V24Log.SendLn

V24Log.List
BIER  %       <       f 
     C  Oberon10.Scn.Fnt 22.02.2009  15:39:19  TimeStamps.New  