; Boot loader (Turbo Assembler)
; Written by P.J. Muller
; Based on code by Werner Fouch\'e
;
; To compile:
;   tasm gboota.asm
;   tlink gboota
;   exe2bin gboota.exe gboot.bin
;   const gboot.bin boot2.def
; Then compile with Topspeed Modula-2
;
; 1992-02-21  pjm Started
; 1992-02-25  pjm Added 2nd entry point for chip reset
; 1995-03-22  pjm Changes for gboot
; 1997-01-23  pjm Changes for VESA
; 1997-01-27  pjm Kernel above 1Mb
; 1997-02-06  pjm Move 16 bytes at time
; 1997-02-12  pjm rewritten
; 1997-04-02  pjm APM disable option
;

ideal
p386

segment bootcode
assume cs:bootcode,ds:nothing,es:nothing,ss:nothing

; Boot code located in a 4k block (paragraph aligned)
;
; 0000H real mode entry point
; 0800H stack end (grows down)
; 0800H boot table start
; 1000H boot table end
;
; Parameters (all 32-bit)
;
; ofs name    desc
;
; 1C  flags   bit 0 - apm
; 18  table   boot table linear address
; 14  kpar1   kernel parameter 1
; 10  kpar0   kernel parameter 0
; 0C  entry   kernel entry point
; 08  ksize   kernel size in dwords
; 04  kdst    kernel destination linear address
; 00  ksrc    kernel source linear address

entry:  mov ax,0ffffh                   ; patched by Modula-2 code
        mov bp,0ffffh                   ; bp points to parameters
	jmp short entry1
	
align 4
gdt	db 8 dup (0)			; null descriptor
	db 0ffh,0ffh,0,0,0,9ah,0cfh,0	; kernel code segment
	db 0ffh,0ffh,0,0,0,92h,0cfh,0	; kernel data segment
apm32	db 0ffh,0ffh,?,?,?,9ah,0cfh,0	; APM 32-bit code segment
apm16	db 0ffh,0ffh,?,?,?,9ah,000h,0	; APM 16-bit code segment
apmds	db 0ffh,0ffh,?,?,?,92h,0cfh,0	; APM 32-bit data segment
apmofs	dd ?				; APM entry point (directly after GDT)
gdtptr	dw 3*8-1,?,?			; 48-bit pointer to gdt
idtptr	dp 0				; 48-bit null pointer

entry1: cli
        mov ss,ax			; set up stack
        mov sp,bp

	mov ax,0b800h			; for tracing
	mov ds,ax	

; check APM
	test [byte bp+1ch],1		; apm disabled?
	jz short apm0
	
        mov [byte ptr 0],'A'            ; going to check APM
	mov ax,5300h			; APM installation check
	xor bx,bx
	int 15h
	jc short apm0			; no APM
	
	mov ax,5303h			; APM PM 32-bit connect
	xor bx,bx
	int 15h
	jc short apm0
	
	shl eax,4
	mov [word apm32+2],ax		; base 0..15
	shr eax,16
	and al,0fh
	mov [apm32+4],al		; base 16..19
	shl ecx,4
	mov [word apm16+2],cx		; base 0..15
	shr ecx,16
	and cl,0fh
	mov [apm16+4],al		; base 16..19
	shl edx,4
	mov [word apmds+2],dx		; base 0..15
	shr edx,16
	and dl,0fh
	mov [apmds+4],dl		; base 16..19
	mov [apmofs],ebx
	
	mov ax,530eh			; APM driver version 1.1
	xor bx,bx
	mov cx,0101h
	int 15h
	jc short apm0
	
	mov [gdtptr],6*8-1		; 6 segments

apm0:

; Initialise null IDT
        mov [byte ptr 0],'I'            ; going to load IDT
        lidt [cs:idtptr]

; Initialise GDT
        mov [byte ptr 0],'G'            ; going to load GDT
        xor eax,eax
	mov ax,cs
	shl eax,4
	add eax,offset gdt
	mov [dword cs:gdtptr+2],eax
        lgdt [pword ptr cs:gdtptr]

; set up stack
        mov [byte ptr 0],'S'            ; setting up stack
	push large 1*8			; kernel code segment selector
        xor eax,eax
	mov ax,cs
	shl eax,4
	add eax,offset start32
	push eax			; start32 linear address

	xor eax,eax
	xor ebx,ebx
	mov ax,ss
	shl eax,4
	mov bx,sp
	add ebx,eax			; EBX = stack linear address

; enter 80286 protected mode

        mov [byte ptr 0],'P'            ; going to PM
	smsw ax
	or al,1
	lmsw ax
	jmp short pm0			; flush instruction queue

; load segment selectors

pm0:	mov ax,2*8			; kernel data segment selector
	mov ss,ax
	mov ds,ax
	mov es,ax
	mov fs,ax
	mov gs,ax

; jump to 32-bit segment

	mov esp,ebx			; from above
	db 066h
	retf				; to start32

start32:
ends

segment code2 use32 byte		; byte aligned => at offset start32
assume cs:code2, ds:nothing, es:nothing, ss:nothing
	mov ebx,esp
	mov [byte 0b8000h],'2'
	cld				; move the kernel
	mov esi,[ebx+0]
	mov edi,[ebx+4]
	mov ecx,[ebx+8]
	rep movsd
	
	mov [byte 0b8000h],'!'		
	mov esi,[ebx+10h]		; kpar0
	mov edi,[ebx+14h]		; kpar1
	mov eax,[ebx+18h]		; boot table
	xor ebp,ebp
	jmp [dword ebx+0ch]		; to kernel
ends

if 0
segment bootcode
assume cs:bootcode,ds:nothing,es:nothing,ss:nothing

; Entry:
;
; Interrupts off
; The first 2 instructions are patched to set up stack
; The stack is set up as follows:
;
; ofs name    desc
; 00  kto     Segment to which kernel has to be copied
; 02  kfrom   Segment from where kernel has to be copied
; 04  ksize   Number of paragraphs to copy
; 06  sseg    Screen segment (for trace messages)
; 08  gdtptr  6-byte pointer to boot GDT at ofs 1C
; 0E  pad0    2 bytes padding to align next address on 4 bytes
; 10  table   32-bit address of boot table
; 14  ret[0]
; 18  ret[1]
; 1C  kentry  kernel entry point (32-bit address) [14]
; 20  kseg    kernel code segment selector (1*8 = 0008H) [18]
; 22  kdata   kernel data segment selector (2*8 = 0010H) [1A]
; 24  gdt     boot GDT (3 entries, 24 bytes) [1C]
; 3C  kto2    linear address to copy kernel to (if kto=ffff)
; 40  ----
;
; ESP is set to ofs 10 and a pop eax and far ret is executed to jump to the
; kernel in PM

entry:  mov ax,0ffffh                   ; patched by Modula-2 code
        mov bp,0ffffh                   ; ditto
        cli                             ; just make sure
        mov ss,ax
        mov sp,bp

        mov ds,[bp+6]
        mov [byte ptr 0],'M'            ; going to move

; Move the kernel

        cmp [word bp+0],0ffffh          ; protected mode?
        jne short nonpm

p3:     mov cx,40h/2                    ; make BIOS copy GDT
        xor ax,ax
p0:     push ax
        loop p0

        push ss                         ; es:si = GDT
        pop es
        mov si,sp

        mov [word es:si+10h],-1         ; src limit
        mov ax,[bp+2]                   ; bx:ax = kfrom*16
        xor bx,bx
        mov cx,4
p1:     shl ax,1
        rcl bx,1
        loop p1

        mov [es:si+12h],ax              ; src
        mov [es:si+14h],bl
        mov [byte es:si+15h],93h

        mov [word es:si+18h],-1         ; dst limit
        mov ax,[bp+3ch]
        mov [es:si+1ah],ax
        mov ax,[bp+3eh]
        mov [es:si+1ch],al
        mov [byte es:si+1dh],93h

        mov ah,87h                      ; copy
        mov cx,16/2                     ; one paragraph
        int 15h                         ; Note: this disables A20
p2:     jc p2

        add [dword bp+3ch],16        	; INC(kto2, 16)
        inc [word bp+2]              	; INC(kfrom)
        dec [word bp+4]              	; DEC(ksize)
        mov sp,bp
        jnz p3

        jmp short endmove

; empty the 8042 buffer
; mod: al

proc	empty8042
e0:	in al,64h
	and al,2
	jnz e0			; endless loop on error
	ret
endp

nonpm:  cld
        mov ds,[bp+2]                   ; from segment
        mov es,[bp+0]                   ; to segment
        mov bx,[bp+4]                   ; number of paragraphs

L1:     xor si,si                       ; move one paragraph
        mov di,si
        mov cx,8
        rep movsw

        mov ax,ds
        inc ax
        mov ds,ax

        mov ax,es
        inc ax
        mov es,ax

        dec bx
        jnz L1

endmove:
	call empty8042
	mov al,0d1h
	out 64h,al
	call empty8042
	mov al,0dfh
	out 60h,al
	call empty8042

        mov ds,[bp+6]
        mov [byte ptr 0],'I'            ; going to load IDT

; Initialise null IDT
        xor ax,ax
        push ax
        push ax
        push ax
        push bp
        mov bp,sp
        lidt [pword ptr bp+2]
        pop bp
        add sp,6

        mov ds,[bp+6]
        mov [byte ptr 0],'G'            ; going to load GDT

; Initialise GDT
        lgdt [pword ptr bp+8]

        mov ds,[bp+6]
        mov [byte ptr 0],'S'            ; going to set up stack

; Set up stack
	mov bx,[bp+22h]                 ; keep data segment selector in BX
        mov ax,ss
        mov dx,16
        mul dx
        lea cx,[bp+10h]                 ; ESP = bp+10h
        add ax,cx
        adc dx,0
        mov cx,ax                       ; DX:CX = SS*16 + BP + 10h

; Note: preserve BX, DX and CX

        mov ds,[bp+6]
        mov [byte ptr 0],'P'            ; going to PM

; Enter protected mode
        smsw ax
        or al,1
        lmsw ax
        jmp short PM0

; Protected mode segment

PM0:	mov ss,bx                       ; use data segment selector
        mov ds,bx
        mov es,bx

        shl edx,16                      ; EDX' = DX:CX
        mov dx,cx
        mov esp,edx

        pop eax                         ; pop eax (address of table)
        pop esi                         ; esi = ret[0]
        pop edi                         ; edi = ret[1]

        db 066h
        retf                            ; to kernel
ends
endif

end

