/*
 * tclIntPlatDecls.h --
 *
 *	This file contains the declarations for all platform dependent
 *	unsupported functions that are exported by the Tcl library.  These
 *	interfaces are not guaranteed to remain the same between
 *	versions.  Use at your own risk.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 * All rights reserved.
 *
 * RCS: @(#) $Id: tclIntPlatDecls.h,v 1.21 2003/08/25 21:05:16 dkf Exp $
 */

#ifndef _TCLINTPLATDECLS
#define _TCLINTPLATDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tclInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
#ifndef TclGetAndDetachPids_TCL_DECLARED
#define TclGetAndDetachPids_TCL_DECLARED
/* 0 */
EXTERN void		TclGetAndDetachPids _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Channel chan));
#endif
#ifndef TclpCloseFile_TCL_DECLARED
#define TclpCloseFile_TCL_DECLARED
/* 1 */
EXTERN int		TclpCloseFile _ANSI_ARGS_((TclFile file));
#endif
#ifndef TclpCreateCommandChannel_TCL_DECLARED
#define TclpCreateCommandChannel_TCL_DECLARED
/* 2 */
EXTERN Tcl_Channel	TclpCreateCommandChannel _ANSI_ARGS_((
				TclFile readFile, TclFile writeFile, 
				TclFile errorFile, int numPids, 
				Tcl_Pid * pidPtr));
#endif
#ifndef TclpCreatePipe_TCL_DECLARED
#define TclpCreatePipe_TCL_DECLARED
/* 3 */
EXTERN int		TclpCreatePipe _ANSI_ARGS_((TclFile * readPipe, 
				TclFile * writePipe));
#endif
#ifndef TclpCreateProcess_TCL_DECLARED
#define TclpCreateProcess_TCL_DECLARED
/* 4 */
EXTERN int		TclpCreateProcess _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, CONST char ** argv, 
				TclFile inputFile, TclFile outputFile, 
				TclFile errorFile, Tcl_Pid * pidPtr));
#endif
/* Slot 5 is reserved */
#ifndef TclpMakeFile_TCL_DECLARED
#define TclpMakeFile_TCL_DECLARED
/* 6 */
EXTERN TclFile		TclpMakeFile _ANSI_ARGS_((Tcl_Channel channel, 
				int direction));
#endif
#ifndef TclpOpenFile_TCL_DECLARED
#define TclpOpenFile_TCL_DECLARED
/* 7 */
EXTERN TclFile		TclpOpenFile _ANSI_ARGS_((CONST char * fname, 
				int mode));
#endif
#ifndef TclUnixWaitForFile_TCL_DECLARED
#define TclUnixWaitForFile_TCL_DECLARED
/* 8 */
EXTERN int		TclUnixWaitForFile _ANSI_ARGS_((int fd, int mask, 
				int timeout));
#endif
#ifndef TclpCreateTempFile_TCL_DECLARED
#define TclpCreateTempFile_TCL_DECLARED
/* 9 */
EXTERN TclFile		TclpCreateTempFile _ANSI_ARGS_((
				CONST char * contents));
#endif
#ifndef TclpReaddir_TCL_DECLARED
#define TclpReaddir_TCL_DECLARED
/* 10 */
EXTERN Tcl_DirEntry *	TclpReaddir _ANSI_ARGS_((DIR * dir));
#endif
#ifndef TclpLocaltime_TCL_DECLARED
#define TclpLocaltime_TCL_DECLARED
/* 11 */
EXTERN struct tm *	TclpLocaltime _ANSI_ARGS_((time_t * clock));
#endif
#ifndef TclpGmtime_TCL_DECLARED
#define TclpGmtime_TCL_DECLARED
/* 12 */
EXTERN struct tm *	TclpGmtime _ANSI_ARGS_((time_t * clock));
#endif
#ifndef TclpInetNtoa_TCL_DECLARED
#define TclpInetNtoa_TCL_DECLARED
/* 13 */
EXTERN char *		TclpInetNtoa _ANSI_ARGS_((struct in_addr addr));
#endif
#ifndef TclUnixCopyFile_TCL_DECLARED
#define TclUnixCopyFile_TCL_DECLARED
/* 14 */
EXTERN int		TclUnixCopyFile _ANSI_ARGS_((CONST char * src, 
				CONST char * dst, 
				CONST Tcl_StatBuf * statBufPtr, 
				int dontCopyAtts));
#endif
#endif /* UNIX */
#ifdef __WIN32__
#ifndef TclWinConvertError_TCL_DECLARED
#define TclWinConvertError_TCL_DECLARED
/* 0 */
EXTERN void		TclWinConvertError _ANSI_ARGS_((DWORD errCode));
#endif
#ifndef TclWinConvertWSAError_TCL_DECLARED
#define TclWinConvertWSAError_TCL_DECLARED
/* 1 */
EXTERN void		TclWinConvertWSAError _ANSI_ARGS_((DWORD errCode));
#endif
#ifndef TclWinGetServByName_TCL_DECLARED
#define TclWinGetServByName_TCL_DECLARED
/* 2 */
EXTERN struct servent *	 TclWinGetServByName _ANSI_ARGS_((CONST char * nm, 
				CONST char * proto));
#endif
#ifndef TclWinGetSockOpt_TCL_DECLARED
#define TclWinGetSockOpt_TCL_DECLARED
/* 3 */
EXTERN int		TclWinGetSockOpt _ANSI_ARGS_((SOCKET s, int level, 
				int optname, char FAR * optval, 
				int FAR * optlen));
#endif
#ifndef TclWinGetTclInstance_TCL_DECLARED
#define TclWinGetTclInstance_TCL_DECLARED
/* 4 */
EXTERN HINSTANCE	TclWinGetTclInstance _ANSI_ARGS_((void));
#endif
/* Slot 5 is reserved */
#ifndef TclWinNToHS_TCL_DECLARED
#define TclWinNToHS_TCL_DECLARED
/* 6 */
EXTERN u_short		TclWinNToHS _ANSI_ARGS_((u_short ns));
#endif
#ifndef TclWinSetSockOpt_TCL_DECLARED
#define TclWinSetSockOpt_TCL_DECLARED
/* 7 */
EXTERN int		TclWinSetSockOpt _ANSI_ARGS_((SOCKET s, int level, 
				int optname, CONST char FAR * optval, 
				int optlen));
#endif
#ifndef TclpGetPid_TCL_DECLARED
#define TclpGetPid_TCL_DECLARED
/* 8 */
EXTERN unsigned long	TclpGetPid _ANSI_ARGS_((Tcl_Pid pid));
#endif
#ifndef TclWinGetPlatformId_TCL_DECLARED
#define TclWinGetPlatformId_TCL_DECLARED
/* 9 */
EXTERN int		TclWinGetPlatformId _ANSI_ARGS_((void));
#endif
/* Slot 10 is reserved */
#ifndef TclGetAndDetachPids_TCL_DECLARED
#define TclGetAndDetachPids_TCL_DECLARED
/* 11 */
EXTERN void		TclGetAndDetachPids _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Channel chan));
#endif
#ifndef TclpCloseFile_TCL_DECLARED
#define TclpCloseFile_TCL_DECLARED
/* 12 */
EXTERN int		TclpCloseFile _ANSI_ARGS_((TclFile file));
#endif
#ifndef TclpCreateCommandChannel_TCL_DECLARED
#define TclpCreateCommandChannel_TCL_DECLARED
/* 13 */
EXTERN Tcl_Channel	TclpCreateCommandChannel _ANSI_ARGS_((
				TclFile readFile, TclFile writeFile, 
				TclFile errorFile, int numPids, 
				Tcl_Pid * pidPtr));
#endif
#ifndef TclpCreatePipe_TCL_DECLARED
#define TclpCreatePipe_TCL_DECLARED
/* 14 */
EXTERN int		TclpCreatePipe _ANSI_ARGS_((TclFile * readPipe, 
				TclFile * writePipe));
#endif
#ifndef TclpCreateProcess_TCL_DECLARED
#define TclpCreateProcess_TCL_DECLARED
/* 15 */
EXTERN int		TclpCreateProcess _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, CONST char ** argv, 
				TclFile inputFile, TclFile outputFile, 
				TclFile errorFile, Tcl_Pid * pidPtr));
#endif
/* Slot 16 is reserved */
/* Slot 17 is reserved */
#ifndef TclpMakeFile_TCL_DECLARED
#define TclpMakeFile_TCL_DECLARED
/* 18 */
EXTERN TclFile		TclpMakeFile _ANSI_ARGS_((Tcl_Channel channel, 
				int direction));
#endif
#ifndef TclpOpenFile_TCL_DECLARED
#define TclpOpenFile_TCL_DECLARED
/* 19 */
EXTERN TclFile		TclpOpenFile _ANSI_ARGS_((CONST char * fname, 
				int mode));
#endif
#ifndef TclWinAddProcess_TCL_DECLARED
#define TclWinAddProcess_TCL_DECLARED
/* 20 */
EXTERN void		TclWinAddProcess _ANSI_ARGS_((HANDLE hProcess, 
				DWORD id));
#endif
/* Slot 21 is reserved */
#ifndef TclpCreateTempFile_TCL_DECLARED
#define TclpCreateTempFile_TCL_DECLARED
/* 22 */
EXTERN TclFile		TclpCreateTempFile _ANSI_ARGS_((
				CONST char * contents));
#endif
#ifndef TclpGetTZName_TCL_DECLARED
#define TclpGetTZName_TCL_DECLARED
/* 23 */
EXTERN char *		TclpGetTZName _ANSI_ARGS_((int isdst));
#endif
#ifndef TclWinNoBackslash_TCL_DECLARED
#define TclWinNoBackslash_TCL_DECLARED
/* 24 */
EXTERN char *		TclWinNoBackslash _ANSI_ARGS_((char * path));
#endif
#ifndef TclWinGetPlatform_TCL_DECLARED
#define TclWinGetPlatform_TCL_DECLARED
/* 25 */
EXTERN TclPlatformType * TclWinGetPlatform _ANSI_ARGS_((void));
#endif
#ifndef TclWinSetInterfaces_TCL_DECLARED
#define TclWinSetInterfaces_TCL_DECLARED
/* 26 */
EXTERN void		TclWinSetInterfaces _ANSI_ARGS_((int wide));
#endif
#ifndef TclWinFlushDirtyChannels_TCL_DECLARED
#define TclWinFlushDirtyChannels_TCL_DECLARED
/* 27 */
EXTERN void		TclWinFlushDirtyChannels _ANSI_ARGS_((void));
#endif
#ifndef TclWinResetInterfaces_TCL_DECLARED
#define TclWinResetInterfaces_TCL_DECLARED
/* 28 */
EXTERN void		TclWinResetInterfaces _ANSI_ARGS_((void));
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TclpSysAlloc_TCL_DECLARED
#define TclpSysAlloc_TCL_DECLARED
/* 0 */
EXTERN VOID *		TclpSysAlloc _ANSI_ARGS_((long size, int isBin));
#endif
#ifndef TclpSysFree_TCL_DECLARED
#define TclpSysFree_TCL_DECLARED
/* 1 */
EXTERN void		TclpSysFree _ANSI_ARGS_((VOID * ptr));
#endif
#ifndef TclpSysRealloc_TCL_DECLARED
#define TclpSysRealloc_TCL_DECLARED
/* 2 */
EXTERN VOID *		TclpSysRealloc _ANSI_ARGS_((VOID * cp, 
				unsigned int size));
#endif
#ifndef TclpExit_TCL_DECLARED
#define TclpExit_TCL_DECLARED
/* 3 */
EXTERN void		TclpExit _ANSI_ARGS_((int status));
#endif
#ifndef FSpGetDefaultDir_TCL_DECLARED
#define FSpGetDefaultDir_TCL_DECLARED
/* 4 */
EXTERN int		FSpGetDefaultDir _ANSI_ARGS_((FSSpecPtr theSpec));
#endif
#ifndef FSpSetDefaultDir_TCL_DECLARED
#define FSpSetDefaultDir_TCL_DECLARED
/* 5 */
EXTERN int		FSpSetDefaultDir _ANSI_ARGS_((FSSpecPtr theSpec));
#endif
#ifndef FSpFindFolder_TCL_DECLARED
#define FSpFindFolder_TCL_DECLARED
/* 6 */
EXTERN OSErr		FSpFindFolder _ANSI_ARGS_((short vRefNum, 
				OSType folderType, Boolean createFolder, 
				FSSpec * spec));
#endif
#ifndef GetGlobalMouseTcl_TCL_DECLARED
#define GetGlobalMouseTcl_TCL_DECLARED
/* 7 */
EXTERN void		GetGlobalMouseTcl _ANSI_ARGS_((Point * mouse));
#endif
#ifndef FSpGetDirectoryIDTcl_TCL_DECLARED
#define FSpGetDirectoryIDTcl_TCL_DECLARED
/* 8 */
EXTERN pascal OSErr	FSpGetDirectoryIDTcl _ANSI_ARGS_((
				CONST FSSpec * spec, long * theDirID, 
				Boolean * isDirectory));
#endif
#ifndef FSpOpenResFileCompatTcl_TCL_DECLARED
#define FSpOpenResFileCompatTcl_TCL_DECLARED
/* 9 */
EXTERN pascal short	FSpOpenResFileCompatTcl _ANSI_ARGS_((
				CONST FSSpec * spec, SignedByte permission));
#endif
#ifndef FSpCreateResFileCompatTcl_TCL_DECLARED
#define FSpCreateResFileCompatTcl_TCL_DECLARED
/* 10 */
EXTERN pascal void	FSpCreateResFileCompatTcl _ANSI_ARGS_((
				CONST FSSpec * spec, OSType creator, 
				OSType fileType, ScriptCode scriptTag));
#endif
#ifndef FSpLocationFromPath_TCL_DECLARED
#define FSpLocationFromPath_TCL_DECLARED
/* 11 */
EXTERN int		FSpLocationFromPath _ANSI_ARGS_((int length, 
				CONST char * path, FSSpecPtr theSpec));
#endif
#ifndef FSpPathFromLocation_TCL_DECLARED
#define FSpPathFromLocation_TCL_DECLARED
/* 12 */
EXTERN OSErr		FSpPathFromLocation _ANSI_ARGS_((FSSpecPtr theSpec, 
				int * length, Handle * fullPath));
#endif
#ifndef TclMacExitHandler_TCL_DECLARED
#define TclMacExitHandler_TCL_DECLARED
/* 13 */
EXTERN void		TclMacExitHandler _ANSI_ARGS_((void));
#endif
#ifndef TclMacInitExitToShell_TCL_DECLARED
#define TclMacInitExitToShell_TCL_DECLARED
/* 14 */
EXTERN void		TclMacInitExitToShell _ANSI_ARGS_((int usePatch));
#endif
#ifndef TclMacInstallExitToShellPatch_TCL_DECLARED
#define TclMacInstallExitToShellPatch_TCL_DECLARED
/* 15 */
EXTERN OSErr		TclMacInstallExitToShellPatch _ANSI_ARGS_((
				ExitToShellProcPtr newProc));
#endif
#ifndef TclMacOSErrorToPosixError_TCL_DECLARED
#define TclMacOSErrorToPosixError_TCL_DECLARED
/* 16 */
EXTERN int		TclMacOSErrorToPosixError _ANSI_ARGS_((int error));
#endif
#ifndef TclMacRemoveTimer_TCL_DECLARED
#define TclMacRemoveTimer_TCL_DECLARED
/* 17 */
EXTERN void		TclMacRemoveTimer _ANSI_ARGS_((void * timerToken));
#endif
#ifndef TclMacStartTimer_TCL_DECLARED
#define TclMacStartTimer_TCL_DECLARED
/* 18 */
EXTERN void *		TclMacStartTimer _ANSI_ARGS_((long ms));
#endif
#ifndef TclMacTimerExpired_TCL_DECLARED
#define TclMacTimerExpired_TCL_DECLARED
/* 19 */
EXTERN int		TclMacTimerExpired _ANSI_ARGS_((void * timerToken));
#endif
#ifndef TclMacRegisterResourceFork_TCL_DECLARED
#define TclMacRegisterResourceFork_TCL_DECLARED
/* 20 */
EXTERN int		TclMacRegisterResourceFork _ANSI_ARGS_((
				short fileRef, Tcl_Obj * tokenPtr, 
				int insert));
#endif
#ifndef TclMacUnRegisterResourceFork_TCL_DECLARED
#define TclMacUnRegisterResourceFork_TCL_DECLARED
/* 21 */
EXTERN short		TclMacUnRegisterResourceFork _ANSI_ARGS_((
				char * tokenPtr, Tcl_Obj * resultPtr));
#endif
#ifndef TclMacCreateEnv_TCL_DECLARED
#define TclMacCreateEnv_TCL_DECLARED
/* 22 */
EXTERN int		TclMacCreateEnv _ANSI_ARGS_((void));
#endif
#ifndef TclMacFOpenHack_TCL_DECLARED
#define TclMacFOpenHack_TCL_DECLARED
/* 23 */
EXTERN FILE *		TclMacFOpenHack _ANSI_ARGS_((CONST char * path, 
				CONST char * mode));
#endif
#ifndef TclpGetTZName_TCL_DECLARED
#define TclpGetTZName_TCL_DECLARED
/* 24 */
EXTERN char *		TclpGetTZName _ANSI_ARGS_((int isdst));
#endif
#ifndef TclMacChmod_TCL_DECLARED
#define TclMacChmod_TCL_DECLARED
/* 25 */
EXTERN int		TclMacChmod _ANSI_ARGS_((CONST char * path, int mode));
#endif
#ifndef FSpLLocationFromPath_TCL_DECLARED
#define FSpLLocationFromPath_TCL_DECLARED
/* 26 */
EXTERN int		FSpLLocationFromPath _ANSI_ARGS_((int length, 
				CONST char * path, FSSpecPtr theSpec));
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TCL
#ifndef TclMacOSXGetFileAttribute_TCL_DECLARED
#define TclMacOSXGetFileAttribute_TCL_DECLARED
/* 15 */
EXTERN int		TclMacOSXGetFileAttribute _ANSI_ARGS_((
				Tcl_Interp * interp, int objIndex, 
				Tcl_Obj * fileName, 
				Tcl_Obj ** attributePtrPtr));
#endif
#ifndef TclMacOSXSetFileAttribute_TCL_DECLARED
#define TclMacOSXSetFileAttribute_TCL_DECLARED
/* 16 */
EXTERN int		TclMacOSXSetFileAttribute _ANSI_ARGS_((
				Tcl_Interp * interp, int objIndex, 
				Tcl_Obj * fileName, Tcl_Obj * attributePtr));
#endif
#ifndef TclMacOSXCopyFileAttributes_TCL_DECLARED
#define TclMacOSXCopyFileAttributes_TCL_DECLARED
/* 17 */
EXTERN int		TclMacOSXCopyFileAttributes _ANSI_ARGS_((
				CONST char * src, CONST char * dst, 
				CONST Tcl_StatBuf * statBufPtr));
#endif
#endif /* MAC_OSX_TCL */

typedef struct TclIntPlatStubs {
    int magic;
    struct TclIntPlatStubHooks *hooks;

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void (*tclGetAndDetachPids) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan)); /* 0 */
    int (*tclpCloseFile) _ANSI_ARGS_((TclFile file)); /* 1 */
    Tcl_Channel (*tclpCreateCommandChannel) _ANSI_ARGS_((TclFile readFile, TclFile writeFile, TclFile errorFile, int numPids, Tcl_Pid * pidPtr)); /* 2 */
    int (*tclpCreatePipe) _ANSI_ARGS_((TclFile * readPipe, TclFile * writePipe)); /* 3 */
    int (*tclpCreateProcess) _ANSI_ARGS_((Tcl_Interp * interp, int argc, CONST char ** argv, TclFile inputFile, TclFile outputFile, TclFile errorFile, Tcl_Pid * pidPtr)); /* 4 */
    void *reserved5;
    TclFile (*tclpMakeFile) _ANSI_ARGS_((Tcl_Channel channel, int direction)); /* 6 */
    TclFile (*tclpOpenFile) _ANSI_ARGS_((CONST char * fname, int mode)); /* 7 */
    int (*tclUnixWaitForFile) _ANSI_ARGS_((int fd, int mask, int timeout)); /* 8 */
    TclFile (*tclpCreateTempFile) _ANSI_ARGS_((CONST char * contents)); /* 9 */
    Tcl_DirEntry * (*tclpReaddir) _ANSI_ARGS_((DIR * dir)); /* 10 */
    struct tm * (*tclpLocaltime) _ANSI_ARGS_((time_t * clock)); /* 11 */
    struct tm * (*tclpGmtime) _ANSI_ARGS_((time_t * clock)); /* 12 */
    char * (*tclpInetNtoa) _ANSI_ARGS_((struct in_addr addr)); /* 13 */
    int (*tclUnixCopyFile) _ANSI_ARGS_((CONST char * src, CONST char * dst, CONST Tcl_StatBuf * statBufPtr, int dontCopyAtts)); /* 14 */
#endif /* UNIX */
#ifdef __WIN32__
    void (*tclWinConvertError) _ANSI_ARGS_((DWORD errCode)); /* 0 */
    void (*tclWinConvertWSAError) _ANSI_ARGS_((DWORD errCode)); /* 1 */
    struct servent * (*tclWinGetServByName) _ANSI_ARGS_((CONST char * nm, CONST char * proto)); /* 2 */
    int (*tclWinGetSockOpt) _ANSI_ARGS_((SOCKET s, int level, int optname, char FAR * optval, int FAR * optlen)); /* 3 */
    HINSTANCE (*tclWinGetTclInstance) _ANSI_ARGS_((void)); /* 4 */
    void *reserved5;
    u_short (*tclWinNToHS) _ANSI_ARGS_((u_short ns)); /* 6 */
    int (*tclWinSetSockOpt) _ANSI_ARGS_((SOCKET s, int level, int optname, CONST char FAR * optval, int optlen)); /* 7 */
    unsigned long (*tclpGetPid) _ANSI_ARGS_((Tcl_Pid pid)); /* 8 */
    int (*tclWinGetPlatformId) _ANSI_ARGS_((void)); /* 9 */
    void *reserved10;
    void (*tclGetAndDetachPids) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan)); /* 11 */
    int (*tclpCloseFile) _ANSI_ARGS_((TclFile file)); /* 12 */
    Tcl_Channel (*tclpCreateCommandChannel) _ANSI_ARGS_((TclFile readFile, TclFile writeFile, TclFile errorFile, int numPids, Tcl_Pid * pidPtr)); /* 13 */
    int (*tclpCreatePipe) _ANSI_ARGS_((TclFile * readPipe, TclFile * writePipe)); /* 14 */
    int (*tclpCreateProcess) _ANSI_ARGS_((Tcl_Interp * interp, int argc, CONST char ** argv, TclFile inputFile, TclFile outputFile, TclFile errorFile, Tcl_Pid * pidPtr)); /* 15 */
    void *reserved16;
    void *reserved17;
    TclFile (*tclpMakeFile) _ANSI_ARGS_((Tcl_Channel channel, int direction)); /* 18 */
    TclFile (*tclpOpenFile) _ANSI_ARGS_((CONST char * fname, int mode)); /* 19 */
    void (*tclWinAddProcess) _ANSI_ARGS_((HANDLE hProcess, DWORD id)); /* 20 */
    void *reserved21;
    TclFile (*tclpCreateTempFile) _ANSI_ARGS_((CONST char * contents)); /* 22 */
    char * (*tclpGetTZName) _ANSI_ARGS_((int isdst)); /* 23 */
    char * (*tclWinNoBackslash) _ANSI_ARGS_((char * path)); /* 24 */
    TclPlatformType * (*tclWinGetPlatform) _ANSI_ARGS_((void)); /* 25 */
    void (*tclWinSetInterfaces) _ANSI_ARGS_((int wide)); /* 26 */
    void (*tclWinFlushDirtyChannels) _ANSI_ARGS_((void)); /* 27 */
    void (*tclWinResetInterfaces) _ANSI_ARGS_((void)); /* 28 */
#endif /* __WIN32__ */
#ifdef MAC_TCL
    VOID * (*tclpSysAlloc) _ANSI_ARGS_((long size, int isBin)); /* 0 */
    void (*tclpSysFree) _ANSI_ARGS_((VOID * ptr)); /* 1 */
    VOID * (*tclpSysRealloc) _ANSI_ARGS_((VOID * cp, unsigned int size)); /* 2 */
    void (*tclpExit) _ANSI_ARGS_((int status)); /* 3 */
    int (*fSpGetDefaultDir) _ANSI_ARGS_((FSSpecPtr theSpec)); /* 4 */
    int (*fSpSetDefaultDir) _ANSI_ARGS_((FSSpecPtr theSpec)); /* 5 */
    OSErr (*fSpFindFolder) _ANSI_ARGS_((short vRefNum, OSType folderType, Boolean createFolder, FSSpec * spec)); /* 6 */
    void (*getGlobalMouseTcl) _ANSI_ARGS_((Point * mouse)); /* 7 */
    pascal OSErr (*fSpGetDirectoryIDTcl) _ANSI_ARGS_((CONST FSSpec * spec, long * theDirID, Boolean * isDirectory)); /* 8 */
    pascal short (*fSpOpenResFileCompatTcl) _ANSI_ARGS_((CONST FSSpec * spec, SignedByte permission)); /* 9 */
    pascal void (*fSpCreateResFileCompatTcl) _ANSI_ARGS_((CONST FSSpec * spec, OSType creator, OSType fileType, ScriptCode scriptTag)); /* 10 */
    int (*fSpLocationFromPath) _ANSI_ARGS_((int length, CONST char * path, FSSpecPtr theSpec)); /* 11 */
    OSErr (*fSpPathFromLocation) _ANSI_ARGS_((FSSpecPtr theSpec, int * length, Handle * fullPath)); /* 12 */
    void (*tclMacExitHandler) _ANSI_ARGS_((void)); /* 13 */
    void (*tclMacInitExitToShell) _ANSI_ARGS_((int usePatch)); /* 14 */
    OSErr (*tclMacInstallExitToShellPatch) _ANSI_ARGS_((ExitToShellProcPtr newProc)); /* 15 */
    int (*tclMacOSErrorToPosixError) _ANSI_ARGS_((int error)); /* 16 */
    void (*tclMacRemoveTimer) _ANSI_ARGS_((void * timerToken)); /* 17 */
    void * (*tclMacStartTimer) _ANSI_ARGS_((long ms)); /* 18 */
    int (*tclMacTimerExpired) _ANSI_ARGS_((void * timerToken)); /* 19 */
    int (*tclMacRegisterResourceFork) _ANSI_ARGS_((short fileRef, Tcl_Obj * tokenPtr, int insert)); /* 20 */
    short (*tclMacUnRegisterResourceFork) _ANSI_ARGS_((char * tokenPtr, Tcl_Obj * resultPtr)); /* 21 */
    int (*tclMacCreateEnv) _ANSI_ARGS_((void)); /* 22 */
    FILE * (*tclMacFOpenHack) _ANSI_ARGS_((CONST char * path, CONST char * mode)); /* 23 */
    char * (*tclpGetTZName) _ANSI_ARGS_((int isdst)); /* 24 */
    int (*tclMacChmod) _ANSI_ARGS_((CONST char * path, int mode)); /* 25 */
    int (*fSpLLocationFromPath) _ANSI_ARGS_((int length, CONST char * path, FSSpecPtr theSpec)); /* 26 */
#endif /* MAC_TCL */
#ifdef MAC_OSX_TCL
    int (*tclMacOSXGetFileAttribute) _ANSI_ARGS_((Tcl_Interp * interp, int objIndex, Tcl_Obj * fileName, Tcl_Obj ** attributePtrPtr)); /* 15 */
    int (*tclMacOSXSetFileAttribute) _ANSI_ARGS_((Tcl_Interp * interp, int objIndex, Tcl_Obj * fileName, Tcl_Obj * attributePtr)); /* 16 */
    int (*tclMacOSXCopyFileAttributes) _ANSI_ARGS_((CONST char * src, CONST char * dst, CONST Tcl_StatBuf * statBufPtr)); /* 17 */
#endif /* MAC_OSX_TCL */
} TclIntPlatStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern TclIntPlatStubs *tclIntPlatStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
#ifndef TclGetAndDetachPids
#define TclGetAndDetachPids \
	(tclIntPlatStubsPtr->tclGetAndDetachPids) /* 0 */
#endif
#ifndef TclpCloseFile
#define TclpCloseFile \
	(tclIntPlatStubsPtr->tclpCloseFile) /* 1 */
#endif
#ifndef TclpCreateCommandChannel
#define TclpCreateCommandChannel \
	(tclIntPlatStubsPtr->tclpCreateCommandChannel) /* 2 */
#endif
#ifndef TclpCreatePipe
#define TclpCreatePipe \
	(tclIntPlatStubsPtr->tclpCreatePipe) /* 3 */
#endif
#ifndef TclpCreateProcess
#define TclpCreateProcess \
	(tclIntPlatStubsPtr->tclpCreateProcess) /* 4 */
#endif
/* Slot 5 is reserved */
#ifndef TclpMakeFile
#define TclpMakeFile \
	(tclIntPlatStubsPtr->tclpMakeFile) /* 6 */
#endif
#ifndef TclpOpenFile
#define TclpOpenFile \
	(tclIntPlatStubsPtr->tclpOpenFile) /* 7 */
#endif
#ifndef TclUnixWaitForFile
#define TclUnixWaitForFile \
	(tclIntPlatStubsPtr->tclUnixWaitForFile) /* 8 */
#endif
#ifndef TclpCreateTempFile
#define TclpCreateTempFile \
	(tclIntPlatStubsPtr->tclpCreateTempFile) /* 9 */
#endif
#ifndef TclpReaddir
#define TclpReaddir \
	(tclIntPlatStubsPtr->tclpReaddir) /* 10 */
#endif
#ifndef TclpLocaltime
#define TclpLocaltime \
	(tclIntPlatStubsPtr->tclpLocaltime) /* 11 */
#endif
#ifndef TclpGmtime
#define TclpGmtime \
	(tclIntPlatStubsPtr->tclpGmtime) /* 12 */
#endif
#ifndef TclpInetNtoa
#define TclpInetNtoa \
	(tclIntPlatStubsPtr->tclpInetNtoa) /* 13 */
#endif
#ifndef TclUnixCopyFile
#define TclUnixCopyFile \
	(tclIntPlatStubsPtr->tclUnixCopyFile) /* 14 */
#endif
#endif /* UNIX */
#ifdef __WIN32__
#ifndef TclWinConvertError
#define TclWinConvertError \
	(tclIntPlatStubsPtr->tclWinConvertError) /* 0 */
#endif
#ifndef TclWinConvertWSAError
#define TclWinConvertWSAError \
	(tclIntPlatStubsPtr->tclWinConvertWSAError) /* 1 */
#endif
#ifndef TclWinGetServByName
#define TclWinGetServByName \
	(tclIntPlatStubsPtr->tclWinGetServByName) /* 2 */
#endif
#ifndef TclWinGetSockOpt
#define TclWinGetSockOpt \
	(tclIntPlatStubsPtr->tclWinGetSockOpt) /* 3 */
#endif
#ifndef TclWinGetTclInstance
#define TclWinGetTclInstance \
	(tclIntPlatStubsPtr->tclWinGetTclInstance) /* 4 */
#endif
/* Slot 5 is reserved */
#ifndef TclWinNToHS
#define TclWinNToHS \
	(tclIntPlatStubsPtr->tclWinNToHS) /* 6 */
#endif
#ifndef TclWinSetSockOpt
#define TclWinSetSockOpt \
	(tclIntPlatStubsPtr->tclWinSetSockOpt) /* 7 */
#endif
#ifndef TclpGetPid
#define TclpGetPid \
	(tclIntPlatStubsPtr->tclpGetPid) /* 8 */
#endif
#ifndef TclWinGetPlatformId
#define TclWinGetPlatformId \
	(tclIntPlatStubsPtr->tclWinGetPlatformId) /* 9 */
#endif
/* Slot 10 is reserved */
#ifndef TclGetAndDetachPids
#define TclGetAndDetachPids \
	(tclIntPlatStubsPtr->tclGetAndDetachPids) /* 11 */
#endif
#ifndef TclpCloseFile
#define TclpCloseFile \
	(tclIntPlatStubsPtr->tclpCloseFile) /* 12 */
#endif
#ifndef TclpCreateCommandChannel
#define TclpCreateCommandChannel \
	(tclIntPlatStubsPtr->tclpCreateCommandChannel) /* 13 */
#endif
#ifndef TclpCreatePipe
#define TclpCreatePipe \
	(tclIntPlatStubsPtr->tclpCreatePipe) /* 14 */
#endif
#ifndef TclpCreateProcess
#define TclpCreateProcess \
	(tclIntPlatStubsPtr->tclpCreateProcess) /* 15 */
#endif
/* Slot 16 is reserved */
/* Slot 17 is reserved */
#ifndef TclpMakeFile
#define TclpMakeFile \
	(tclIntPlatStubsPtr->tclpMakeFile) /* 18 */
#endif
#ifndef TclpOpenFile
#define TclpOpenFile \
	(tclIntPlatStubsPtr->tclpOpenFile) /* 19 */
#endif
#ifndef TclWinAddProcess
#define TclWinAddProcess \
	(tclIntPlatStubsPtr->tclWinAddProcess) /* 20 */
#endif
/* Slot 21 is reserved */
#ifndef TclpCreateTempFile
#define TclpCreateTempFile \
	(tclIntPlatStubsPtr->tclpCreateTempFile) /* 22 */
#endif
#ifndef TclpGetTZName
#define TclpGetTZName \
	(tclIntPlatStubsPtr->tclpGetTZName) /* 23 */
#endif
#ifndef TclWinNoBackslash
#define TclWinNoBackslash \
	(tclIntPlatStubsPtr->tclWinNoBackslash) /* 24 */
#endif
#ifndef TclWinGetPlatform
#define TclWinGetPlatform \
	(tclIntPlatStubsPtr->tclWinGetPlatform) /* 25 */
#endif
#ifndef TclWinSetInterfaces
#define TclWinSetInterfaces \
	(tclIntPlatStubsPtr->tclWinSetInterfaces) /* 26 */
#endif
#ifndef TclWinFlushDirtyChannels
#define TclWinFlushDirtyChannels \
	(tclIntPlatStubsPtr->tclWinFlushDirtyChannels) /* 27 */
#endif
#ifndef TclWinResetInterfaces
#define TclWinResetInterfaces \
	(tclIntPlatStubsPtr->tclWinResetInterfaces) /* 28 */
#endif
#endif /* __WIN32__ */
#ifdef MAC_TCL
#ifndef TclpSysAlloc
#define TclpSysAlloc \
	(tclIntPlatStubsPtr->tclpSysAlloc) /* 0 */
#endif
#ifndef TclpSysFree
#define TclpSysFree \
	(tclIntPlatStubsPtr->tclpSysFree) /* 1 */
#endif
#ifndef TclpSysRealloc
#define TclpSysRealloc \
	(tclIntPlatStubsPtr->tclpSysRealloc) /* 2 */
#endif
#ifndef TclpExit
#define TclpExit \
	(tclIntPlatStubsPtr->tclpExit) /* 3 */
#endif
#ifndef FSpGetDefaultDir
#define FSpGetDefaultDir \
	(tclIntPlatStubsPtr->fSpGetDefaultDir) /* 4 */
#endif
#ifndef FSpSetDefaultDir
#define FSpSetDefaultDir \
	(tclIntPlatStubsPtr->fSpSetDefaultDir) /* 5 */
#endif
#ifndef FSpFindFolder
#define FSpFindFolder \
	(tclIntPlatStubsPtr->fSpFindFolder) /* 6 */
#endif
#ifndef GetGlobalMouseTcl
#define GetGlobalMouseTcl \
	(tclIntPlatStubsPtr->getGlobalMouseTcl) /* 7 */
#endif
#ifndef FSpGetDirectoryIDTcl
#define FSpGetDirectoryIDTcl \
	(tclIntPlatStubsPtr->fSpGetDirectoryIDTcl) /* 8 */
#endif
#ifndef FSpOpenResFileCompatTcl
#define FSpOpenResFileCompatTcl \
	(tclIntPlatStubsPtr->fSpOpenResFileCompatTcl) /* 9 */
#endif
#ifndef FSpCreateResFileCompatTcl
#define FSpCreateResFileCompatTcl \
	(tclIntPlatStubsPtr->fSpCreateResFileCompatTcl) /* 10 */
#endif
#ifndef FSpLocationFromPath
#define FSpLocationFromPath \
	(tclIntPlatStubsPtr->fSpLocationFromPath) /* 11 */
#endif
#ifndef FSpPathFromLocation
#define FSpPathFromLocation \
	(tclIntPlatStubsPtr->fSpPathFromLocation) /* 12 */
#endif
#ifndef TclMacExitHandler
#define TclMacExitHandler \
	(tclIntPlatStubsPtr->tclMacExitHandler) /* 13 */
#endif
#ifndef TclMacInitExitToShell
#define TclMacInitExitToShell \
	(tclIntPlatStubsPtr->tclMacInitExitToShell) /* 14 */
#endif
#ifndef TclMacInstallExitToShellPatch
#define TclMacInstallExitToShellPatch \
	(tclIntPlatStubsPtr->tclMacInstallExitToShellPatch) /* 15 */
#endif
#ifndef TclMacOSErrorToPosixError
#define TclMacOSErrorToPosixError \
	(tclIntPlatStubsPtr->tclMacOSErrorToPosixError) /* 16 */
#endif
#ifndef TclMacRemoveTimer
#define TclMacRemoveTimer \
	(tclIntPlatStubsPtr->tclMacRemoveTimer) /* 17 */
#endif
#ifndef TclMacStartTimer
#define TclMacStartTimer \
	(tclIntPlatStubsPtr->tclMacStartTimer) /* 18 */
#endif
#ifndef TclMacTimerExpired
#define TclMacTimerExpired \
	(tclIntPlatStubsPtr->tclMacTimerExpired) /* 19 */
#endif
#ifndef TclMacRegisterResourceFork
#define TclMacRegisterResourceFork \
	(tclIntPlatStubsPtr->tclMacRegisterResourceFork) /* 20 */
#endif
#ifndef TclMacUnRegisterResourceFork
#define TclMacUnRegisterResourceFork \
	(tclIntPlatStubsPtr->tclMacUnRegisterResourceFork) /* 21 */
#endif
#ifndef TclMacCreateEnv
#define TclMacCreateEnv \
	(tclIntPlatStubsPtr->tclMacCreateEnv) /* 22 */
#endif
#ifndef TclMacFOpenHack
#define TclMacFOpenHack \
	(tclIntPlatStubsPtr->tclMacFOpenHack) /* 23 */
#endif
#ifndef TclpGetTZName
#define TclpGetTZName \
	(tclIntPlatStubsPtr->tclpGetTZName) /* 24 */
#endif
#ifndef TclMacChmod
#define TclMacChmod \
	(tclIntPlatStubsPtr->tclMacChmod) /* 25 */
#endif
#ifndef FSpLLocationFromPath
#define FSpLLocationFromPath \
	(tclIntPlatStubsPtr->fSpLLocationFromPath) /* 26 */
#endif
#endif /* MAC_TCL */
#ifdef MAC_OSX_TCL
#ifndef TclMacOSXGetFileAttribute
#define TclMacOSXGetFileAttribute \
	(tclIntPlatStubsPtr->tclMacOSXGetFileAttribute) /* 15 */
#endif
#ifndef TclMacOSXSetFileAttribute
#define TclMacOSXSetFileAttribute \
	(tclIntPlatStubsPtr->tclMacOSXSetFileAttribute) /* 16 */
#endif
#ifndef TclMacOSXCopyFileAttributes
#define TclMacOSXCopyFileAttributes \
	(tclIntPlatStubsPtr->tclMacOSXCopyFileAttributes) /* 17 */
#endif
#endif /* MAC_OSX_TCL */

#endif /* defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TCLINTPLATDECLS */
