' Internal Speaker Waveplayer 1.0
' Copyright 2002 Sebastian Mate
' ---------------------------------------------------------------------------

DECLARE SUB FFIX
FFIX

InitSpeed = 10          ' You don't have to change it, the program will do
                        ' this for you. The problem is, that you can't use
                        ' something like DMA to play on the speaker,
                        ' it's done by the CPU. Some of them are to fast
                        ' and you have to add a delay. See below.
FILE$ = COMMAND$        ' Hmmm, what does that mean?
SampleRate% = 22050     ' Bytes(Herz)/Second. If your PC's to slow to play
                        ' the file, resample it. To speed up the program:
                        ' Remove all empty lines and comments, and, if
                        ' required, the Delay (FOR A% ... NEXT A%) and
                        ' the "Speed"-calculator.
DIM Buffer AS STRING

  PRINT " Internal Speaker Waveplayer 1.00    (C) 2002 Sebastian Mate"
  LOCATE , 1: PRINT " Playing "; FILE$; " ..."

'---- Set up the internal speaker for 6-Bit mode. ---------------------------
  OUT &H43, &HB6
  OUT &H42, &HFF
  OUT &H42, 0
  OUT &H43, &H90
  R = INP(&H61) OR 3
  OUT &H61, R

'---- Open the file ---------------------------------------------------------

'a = INP(&H61)
'pon = a OR 2           'set bit 2
'poff = a AND 253       'unset bit 2

OPEN FILE$ FOR BINARY AS #1

z! = TIMER        ' Set the TIMER. The Program uses it to set the value
                  ' to slow down the CPU (OK, the Program :-)
Speed& = InitSpeed

S$ = DIR$("PLAY.CFG")

IF S$ = "" THEN
 OPEN "PLAY.CFG" FOR OUTPUT AS #2
 PRINT #2, Speed&
 CLOSE #2
ELSE
 OPEN "PLAY.CFG" FOR INPUT AS #2
 INPUT #2, Speed&
 CLOSE #2
END IF

DO

 IF Pointer% = 0 THEN
  IF NOT EOF(1) THEN Buffer = INPUT$(20001, #1)
  IF EOF(1) OR INKEY$ <> "" THEN GOTO E:
 END IF

 FOR a& = 1 TO Speed&
 NEXT a&
 
 Pointer% = Pointer% + 1
 Vol% = ((ASC(MID$(Buffer, Pointer%, 1)) - 128) / 2) + 32
 IF Vol% > 59 THEN Vol% = 59
 IF Vol% < 4 THEN Vol% = 4

 OUT &H42, Vol%
 IF Pointer% = 20001 THEN Pointer% = 0
 Byte& = Byte& + 1

 IF z! + .2 < TIMER THEN
   z! = TIMER
   Speed& = Speed& * (Byte& / (SampleRate% / 5))
   Byte& = 0
   LOCATE , 1: PRINT " CPU slow-down:"; Speed&;
   IF Speed& < 2 THEN GOTO FAST:
 END IF

LOOP WHILE NOT EOF(1)

GOTO E:

FAST:
PRINT
PRINT "CPU too slow. Using 'Fast Mode'..."
DO
 S$ = INPUT$(1, #1)
 IF S$ <> "" THEN Vol% = ASC(S$) / 4: Byte& = Byte& + 1
 OUT &H42, Vol%
LOOP WHILE NOT EOF(1)


'---- Reset the Speaker -----------------------------------------------------
E:

OUT &H43, &HB6
R = INP(&H61) AND &HFC
OUT &H61, R

OPEN "PLAY.CFG" FOR OUTPUT AS #2
PRINT #2, Speed&
CLOSE #2

