;=============================================================================
; scancode.inc:	keyboard scancodes.
;
; Copyright (c) 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	---
;
; Macros:
;	---
;
; Used global variables:
;	---
;
; Used global constants:
;	---
;=============================================================================


;=============================================================================
; INT 16 / FN 0 returns the following scan/ascii codes
;=============================================================================
KEY_ESC		equ	011bh		;
KEY_F1		equ	3b00h		;
KEY_F2		equ	3c00h		;
KEY_F3		equ	3d00h		;
KEY_F4		equ	3e00h		;
KEY_F5		equ	3f00h		;
KEY_F6		equ	4000h		;
KEY_F7		equ	4100h		;
KEY_F8		equ	4200h		;
KEY_F9		equ	4300h		;
KEY_F10		equ	4400h		;
;=============================================================================
KEY_REV_QUOTE	equ	2960h		;
KEY_1		equ	0231h		;
KEY_2		equ	0332h		;
KEY_3		equ	0433h		;
KEY_4		equ	0534h		;
KEY_5		equ	0635h		;
KEY_6		equ	0736h		;
KEY_7		equ	0837h		;
KEY_8		equ	0938h		;
KEY_9		equ	0a39h		;
KEY_0		equ	0b30h		;
KEY_MINUS	equ	0c2dh		;
KEY_EQU		equ	0d3dh		;
KEY_BACKSLASH	equ	2b5ch		;
KEY_BACKSPACE	equ	0e08h		;
;=============================================================================
KEY_TAB		equ	0f09h		;
KEY_Q		equ	1071h		;
KEY_W		equ	1177h		;
KEY_E		equ	1265h		;
KEY_R		equ	1372h		;
KEY_T		equ	1474h		;
KEY_Y		equ	1579h		;
KEY_U		equ	1675h		;
KEY_I		equ	1769h		;
KEY_O		equ	186fh		;
KEY_P		equ	1970h		;
KEY_LB		equ	1a5bh		;
KEY_RB		equ	1b5dh		;
KEY_ENTER	equ	1c0dh		;
;=============================================================================
KEY_A		equ	1e61h		;
KEY_S		equ	1f73h		;
KEY_D		equ	2064h		;
KEY_F		equ	2166h		;
KEY_G		equ	2267h		;
KEY_H		equ	2368h		;
KEY_J		equ	246ah		;
KEY_K		equ	256bh		;
KEY_L		equ	266ch		;
KEY_SEMICOLON	equ	273bh		;
KEY_APOSTR	equ	2827h		;
;=============================================================================
KEY_Z		equ	2c7ah		;
KEY_X		equ	2d78h		;
KEY_C		equ	2e63h		;
KEY_V		equ	2f76h		;
KEY_B		equ	3062h		;
KEY_N		equ	316eh		;
KEY_M		equ	326dh		;
KEY_COMMA	equ	332ch		;
KEY_DOT		equ	342eh		;
KEY_SLASH	equ	352fh		;
KEY_SPACE	equ	3920h		;
;=============================================================================
KEY_INSERT	equ	5200h		;
KEY_DELETE	equ	5300h		;
KEY_HOME	equ	4700h		;
KEY_END		equ	4f00h		;
KEY_PG_UP	equ	4900h		;
KEY_PG_DN	equ	5100h		;
;=============================================================================
KEY_LEFT	equ	4b00h		;
KEY_RIGHT	equ	4d00h		;
KEY_UP		equ	4800h		;
KEY_DOWN	equ	5000h		;
;=============================================================================
KEY_GR_SLASH	equ	352fh		;
KEY_ASTERISK	equ	372ah		;
KEY_GR_MINUS	equ	4a2dh		;
KEY_GR_PLUS	equ	4e2bh		;
;=============================================================================
KEY_CTRL_F1	equ	5e00h		;
KEY_CTRL_F2	equ	5f00h		;
KEY_CTRL_F3	equ	6000h		;
KEY_CTRL_F4	equ	6100h		;
KEY_CTRL_F5	equ	6200h		;
KEY_CTRL_F6	equ	6300h		;
KEY_CTRL_F7	equ	6400h		;
KEY_CTRL_F8	equ	6500h		;
KEY_CTRL_F9	equ	6600h		;
KEY_CTRL_F10	equ	6700h		;
;=============================================================================
KEY_CTRL_2	equ	0300h		;
KEY_CTRL_6	equ	071eh		;
KEY_CTRL_MIN	equ	0c1fh		;
KEY_CTRL_BKSLSH	equ	2b1ch		;
KEY_CTRL_BKSPC	equ	0e7fh		;
;=============================================================================
KEY_CTRL_Q	equ	1011h		;
KEY_CTRL_W	equ	1117h		;
KEY_CTRL_E	equ	1205h		;
KEY_CTRL_R	equ	1312h		;
KEY_CTRL_T	equ	1414h		;
KEY_CTRL_Y	equ	1519h		;
KEY_CTRL_U	equ	1615h		;
KEY_CTRL_I	equ	1709h		;
KEY_CTRL_O	equ	180fh		;
KEY_CTRL_P	equ	1910h		;
KEY_CTRL_LB	equ	1a1bh		;
KEY_CTRL_RB	equ	1b1dh		;
KEY_CTRL_ENTER	equ	1c0ah		;
;-----------------------------------------------------------------------------
KEY_CTRL_A	equ	1e01h		;
KEY_CTRL_S	equ	1f13h		;
KEY_CTRL_D	equ	2004h		;
KEY_CTRL_F	equ	2106h		;
KEY_CTRL_G	equ	2207h		;
KEY_CTRL_H	equ	2308h		;
KEY_CTRL_J	equ	240ah		;
KEY_CTRL_K	equ	250bh		;
KEY_CTRL_L	equ	260ch		;
;-----------------------------------------------------------------------------
KEY_CTRL_Z	equ	2c1ah		;
KEY_CTRL_X	equ	2d18h		;
KEY_CTRL_C	equ	2e03h		;
KEY_CTRL_V	equ	2f16h		;
KEY_CTRL_B	equ	3002h		;
KEY_CTRL_N	equ	310eh		;
KEY_CTRL_M	equ	320dh		;
;=============================================================================
KEY_ALT_F1	equ	6800h		;
KEY_ALT_F2	equ	6900h		;
KEY_ALT_F3	equ	6a00h		;
KEY_ALT_F4	equ	6b00h		;
KEY_ALT_F5	equ	6c00h		;
KEY_ALT_F6	equ	6d00h		;
KEY_ALT_F7	equ	6e00h		;
KEY_ALT_F8	equ	6f00h		;
KEY_ALT_F9	equ	7000h		;
KEY_ALT_F10	equ	7100h		;
;-----------------------------------------------------------------------------
KEY_ALT_1	equ	7800h		;
KEY_ALT_2	equ	7900h		;
KEY_ALT_3	equ	7a00h		;
KEY_ALT_4	equ	7b00h		;
KEY_ALT_5	equ	7c00h		;
KEY_ALT_6	equ	7d00h		;
KEY_ALT_7	equ	7e00h		;
KEY_ALT_8	equ	7f00h		;
KEY_ALT_9	equ	8000h		;
KEY_ALT_0	equ	8100h		;
KEY_ALT_MIN	equ	8200h		;
KEY_ALT_EQU	equ	8300h		;
;-----------------------------------------------------------------------------
KEY_ALT_Q	equ	1000h		;
KEY_ALT_W	equ	1100h		;
KEY_ALT_E	equ	1200h		;
KEY_ALT_R	equ	1300h		;
KEY_ALT_T	equ	1400h		;
KEY_ALT_Y	equ	1500h		;
KEY_ALT_U	equ	1600h		;
KEY_ALT_I	equ	1700h		;
KEY_ALT_O	equ	1800h		;
KEY_ALT_P	equ	1900h		;
;-----------------------------------------------------------------------------
KEY_ALT_A	equ	1e00h		;
KEY_ALT_S	equ	1f00h		;
KEY_ALT_D	equ	2000h		;
KEY_ALT_F	equ	2100h		;
KEY_ALT_G	equ	2200h		;
KEY_ALT_H	equ	2300h		;
KEY_ALT_J	equ	2400h		;
KEY_ALT_K	equ	2500h		;
KEY_ALT_L	equ	2600h		;
;-----------------------------------------------------------------------------
KEY_ALT_Z	equ	2c00h		;
KEY_ALT_X	equ	2d00h		;
KEY_ALT_C	equ	2e00h		;
KEY_ALT_V	equ	2f00h		;
KEY_ALT_B	equ	3000h		;
KEY_ALT_N	equ	3100h		;
KEY_ALT_M	equ	3200h		;
;=============================================================================
KEY_SHIFT_F1	equ	5400h		;
KEY_SHIFT_F2	equ	5500h		;
KEY_SHIFT_F3	equ	5600h		;
KEY_SHIFT_F4	equ	5700h		;
KEY_SHIFT_F5	equ	5800h		;
KEY_SHIFT_F6	equ	5900h		;
KEY_SHIFT_F7	equ	5a00h		;
KEY_SHIFT_F8	equ	5b00h		;
KEY_SHIFT_F9	equ	5c00h		;
KEY_SHIFT_F10	equ	5d00h		;
;=============================================================================

;KEY_		equ	h		;
;KEY_ALT_	equ	00h		;
;KEY_CTRL_	equ	h		;

;=============================================================================
; E0F
;=============================================================================


