;=============================================================================
; dos.inc:	DOS constants.
;
; Copyright (c) 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	---
;
; Macros:
;	---
;
; Used global variables:
;	---
;
; Used global constants:
;	---
;=============================================================================


;=============================================================================
; DOS constants
;-----------------------------------------------------------------------------

STDOUT			equ	1	;STDOUT's handle
STDERR			equ	2	;STDERR's handle

;=============================================================================
; DOS functions
;-----------------------------------------------------------------------------

DOS_DISPLAY_CHAR	equ	02h	;Write char to STDOUT.
;In: DL: char; Out: AL: last char output.

DOS_SET_DEF_DISK	equ	0eh	;Set default drive.
;In: DL: new def. disk (0==A, 1==B...); Out: AL: number of valid drv letters.

DOS_GET_DEF_DISK	equ	19h	;Get current default drive.
;In: ---; Out: AL: current def. disk (0==A, 1==B...).

DOS_SET_DTA		equ	1ah	;Set disk transfer area address.
;In: DS:DX -> DTA; Out: ---.

DOS_SET_INT_VECT	equ	25h	;Set interrupt vector.
;In: AL: int number, DS:DX -> new handler; Out: ---.

DOS_TSR			equ	31h	;Terminate and stay resident.
;In: AL: return code, DX: number of paragraphs to keep resident; Out: ---.

DOS_GET_INT_VECT	equ	35h	;Get interrupt vector.
;In: AL: int number; Out: ES:BX -> handler.

DOS_CHDIR		equ	3bh	;Set current directory.
;In: DS:DX -> ASCIIZ pathname; Out: NC: all Ok, CY: AX: error code (03h).

DOS_OPEN_FILE		equ	3dh	;Open existing file.
;In: AL: access mode, DS:DX -> ASCIIZ filename; Out: NC: AX: handle,
;CY: AX: error code (01h..05h, 0ch, 56h).

DOS_CLOSE_FILE		equ	3eh	;Close file.
;In: BX: handle; Out: NC: all Ok, CY: AX: error code (06h).

DOS_READ_FILE		equ	3fh	;Read from file or device.
;In: BX: handle, CX: number of bytes to read, DS:DX -> buffer; Out: NC:
;AX: number of bytes actually read (0 if at EOF before call), CY: AX:
;error code (05h, 06h).

DOS_WRITE_FILE		equ	40h	;Write to file or device.
;In: BX: handle, CX: number of bytes to write, DS:DX -> buffer; Out: NC:
;AX: number of bytes actually written, CY: AX: error code (05h, 06h).

DOS_GET_DEF_DIR		equ	47h	;Get current directory.
;In: DL: drive (0==default, 1==A...), DS:SI -> buffer (64 bytes);
;Out: NC: AX: 0100h (undoc.), CY: AX: error code (0fh).

DOS_MEM_ALLOC		equ	48h	;Allocate memory.
;In: BX: number of paragraphs to alloc.; Out: NC: AX: segment of block,
;CY: AX: error code (07h, 08h), BX: size of largest available block.

DOS_MEM_FREE		equ	49h	;Free memory.
;In: ES: seg of block to free; Out: NC: all Ok, CY: AX: error code (07h, 09h).

DOS_MEM_RESIZE		equ	4ah	;Resize memory block.
;In: ES: seg of block, BX: new size in paragr.; Out: NC: all Ok, CY: AX:
;error code (07h..09h), BX: largest size for specified block.

DOS_EXEC		equ	4bh	;Load and/or execute program.
;In: AL: type, DS:DX -> ASCIIZ prm name, ES:BX -> parameter block; Out: NC:
;all Ok, CY: AX: error code (01h, 02h, 05h, 08h, 0ah, 0bh).

DOS_TERMINATE		equ	4ch	;Terminate program.
;In: AL: return code; Out: ---.

DOS_GET_RC		equ	4dh	;Get return code (errorlevel).
;In: ---; Out: AH: term. type, AL: return code, NC.

DOS_GET_ALLOC		equ	5800h	;Get memory allocation strategy.
;In: ---; Out: NC: AX: current alloc. strat., CY: AX: error code (01h).

DOS_SET_ALLOC		equ	5801h	;Set memory allocation strategy.
;In: BX: new alloc. strat.; Out: NC: all Ok, CY: AX: error code (01h).

DOS_GET_UMB_LINK	equ	5802h	;Get UMB link state.
;In: ---; Out: NC: AL: UMB link state, CY: AX: error code (01h).

DOS_SET_UMB_LINK	equ	5803h	;Set UMB link state.
;In: BX: new UMB link state; Out: NC: all Ok, CY: AX: error code (01h).


;=============================================================================
; Constants for DOS functions
;-----------------------------------------------------------------------------

;For DOS_EXEC

LOAD_AND_EXEC		equ	00h	;Load and execute.
LOAD_ONLY		equ	01h	;Load only.
LOAD_OVERLAY		equ	03h	;Load overlay.

;For DOS_OPEN_FILE

O_RDONLY		equ	00h	;Open for reading only.
O_WRONLY		equ	01h	;Open for writing only.
O_RDWR			equ	02h	;Open for reading and writing.


;=============================================================================
; E0F
;=============================================================================


