;=============================================================================
; bios_var.inc:	addresses of BIOS variables.
;
; Copyright (c) 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	---
;
; Macros:
;	---
;
; Used global variables:
;	---
;
; Used global constants:
;	---
;=============================================================================


BIOS_KBD_FLAGS		equ	0417h	;b; Keyboard flags
BIOS_VIDEO_MODE		equ	0449h	;b; Current video mode
BIOS_SCR_WIDTH		equ	044ah	;w; Number of columns on screen
BIOS_PAGE_OFFSET	equ	044eh	;w; Offset of active video page
BIOS_VIDEO_PAGE		equ	0462h	;b; Number of active video page
BIOS_TIMER		equ	046ch	;d; Number of timer ticks since midnight
BIOS_SCR_HEIGHT		equ	0484h	;b; (Number of rows on screen) - 1

BIOS_KBD_HEAD		equ	041ah	;w; Ptr to head of kbd buffer
BIOS_KBD_TAIL		equ	041ch	;w; Ptr to tail of kbd buffer
BIOS_KBD_BUF_START	equ	0480h	;w; Start offset of kbd buffer
BIOS_KBD_BUF_END	equ	0482h	;w; End offset of kbd buffer

BIOS_KBD_HEAD_		equ	001ah	;w; Ptr to head of kbd buffer
BIOS_KBD_TAIL_		equ	001ch	;w; Ptr to tail of kbd buffer
BIOS_KBD_BUF_START_	equ	0080h	;w; Start offset of kbd buffer
BIOS_KBD_BUF_END_	equ	0082h	;w; End offset of kbd buffer


;=============================================================================
; E0F
;=============================================================================


