/*
 *      fdav_tui.c
 *
 *      Copyright 2009 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#include "fdav.h"

struct tui_listitem av_options[] = {
    { "        Quick Scan       ", 0 },
    { "        Auto Save        ", 1 },
    { " Only Detect the Viruses ", 0 },
    { "     Check All Files     ", 1 },
    { "    Anti-Stealth Mode    ", 1 },
    { " Prompt When Virus Found ", 1 },
    { "   Create a Report File  ", 0 },
    { "    Quarantine Viruses   ", 0 },
    { "   Disable Alarm Sound   ", 0 },
    { " Make Checksums on Floppy", 0 },
    { "    Make New Checksums   ", 0 },
    { "     Verify Integrity    ", 0 },
    { "  Do Not Use Temp Files  ", 0 }
};

/* The various button arrays used */
const char *tui_buttons[] = {
    "      Detect      ",
    " dEtect and Clean ",
    " Select New Drive ",
    "     Options      ",
    "       eXit       ",
    NULL
};

/* Information for all of the main buttons */
const char *tui_info[] = {
    "Scan the selected drive or directory for viruses without removing them.",
    "Scan the selected drive or directory for viruses, removing them and taking any other specified action.",
    "Select a new drive or directory to scan.",
    "Opens a dialog box from which you can choose various scanning options. The options can be auto-saved on exit.",
    "Exit FreeDOS Anti-Virus to DOS."
};

/* These symbols are in conio.h, but it can't be included with ncurses.h */
extern void _set_screen_lines( int nlines );
static int av_rows;

static glob_t *ftw_glob;
static long long bytes_to_scan;

static int ftw_handler( const char *path, struct stat *stbuf, int flag )
{
    char **fv = ftw_glob->gl_pathv;
    int nf = ftw_glob->gl_pathc;
    char *tmp;

    if( flag != FTW_F ) return( 0 );
    if( !TUI_OPTION( TUI_ALLF ) && !has_ext( path ) ) return( 0 );

    if( fv ) fv = realloc( fv, sizeof( char * ) * ( nf + 1 ) );
    else fv = malloc( sizeof( char * ) * 2 );
    if( fv == NULL ) return( -1 );
    tmp = strdup( path );
    if( !tmp ) return( -1 );
    dos_filename( tmp );
    fv[ nf ] = tmp;
    ftw_glob->gl_pathv = fv;
    ftw_glob->gl_pathc++;
    bytes_to_scan += stbuf->st_size;

    return( 0 );
}

size_t get_filesize( const char *path )
{
    struct stat stbuf;

    if( stat( path, &stbuf ) != 0 ) return( 0 );
    return( stbuf.st_size );
}

glob_t *tui_get_files( const char *path, int recurse )
{
    static glob_t fv;
    static int need_free = 0;
    int len, flags = GLOB_MARK | GLOB_NOESCAPE;
    char withwildcard[ PATH_MAX ], dot[ PATH_MAX ], dotdot[ PATH_MAX ];

    if( need_free ) {
        globfree( &fv );
        need_free = 0;
    }

    if( !strcmp( path, "-/" ) ) {
        fv.gl_pathv = get_drive_array( DRIVE_ALL, &len );
        if( !fv.gl_pathv ) return( NULL );
        need_free = 1;
        fv.gl_pathc = len;
        return( &fv );
    }

    strcpy( withwildcard, path );
    dos_filename( withwildcard );
    len = strlen( withwildcard ) - 1;
    if( withwildcard[ len ] == '\\' ) withwildcard[ len ] = '\0';
    if( !recurse ) {
        sprintf( dot, "%s\\.", withwildcard );
        sprintf( dotdot, "%s\\..", withwildcard );
        dos_filename( dot );
        dos_filename( dotdot );
        flags |= GLOB_DOOFFS;
        fv.gl_offs = 2;
        sprintf( withwildcard, "%s\\%s", withwildcard, "*" );
    }
    dos_filename( withwildcard );

    if( recurse ) {
        struct stat tmpstbuf;
        ftw_glob = &fv;
        bytes_to_scan = 0LL;
        if( withwildcard[ len ] == '\0' ) withwildcard[ len ] = '\\';
        fv.gl_pathv = NULL;
        fv.gl_pathc = 0;
        if( access( withwildcard, D_OK ) ) {
            tmpstbuf.st_size = get_filesize( withwildcard );
            len = ftw_handler( withwildcard, &tmpstbuf, FTW_F );
        } else len = ftw( withwildcard, ftw_handler, 0 );

        if( len ) return( NULL );
    } else {
        if( glob( withwildcard, flags, NULL, &fv ) ) return( NULL );
        fv.gl_pathv[ 0 ] = strdup( dot );
        fv.gl_pathv[ 1 ] = strdup( dotdot );
    }
    need_free = 1;

    return( &fv );
}

static char *pad_message( char *msg, size_t len )
{
    static char padded[ 512 ]; /* Should be big enough */

    memset( padded, ' ', len );
    padded[ len ] = '\0';
    memcpy( padded, msg, strlen( msg ) );

    return( padded );
}

void tui_do_scan( int want_cleaned ) {
    int i, j, r;
    newtComponent form, msg, progress, bcancel;
    glob_t *files_to_scan;
    char *tmp;
    const char *vname;
    long long bytes_scanned;
    int action;
    struct newtExitStruct einf;

    for( i = 0; i < files; i++ ) {
        newtCenteredWindow( 40, 18, "Scanning" );
        form = newtForm( NULL, NULL, 0 );
        msg = newtTextbox( 0, 0, 40, 2, NEWT_FLAG_WRAP );
        newtFormAddComponent( form, msg );
        newtTextboxSetText( msg, "Reading File/Directory Information" );
        newtDrawForm( form );
        newtRefresh();
        files_to_scan = tui_get_files( filev[ i ], 1 );
        if( files_to_scan == NULL ) {
            newtWinMessage( "Error", "OK", "Could not read \"%s\"", filev[ i ] );
            newtFormDestroy( form );
            newtPopWindow();
            continue;
        }

        newtTextboxSetText( msg, "Loading the virus database..." );
        newtRefresh();
        if( load_database() != 0 ) {
            newtWinMessage( "Error", "OK", "Could not load virus database" );
            newtPopWindow();
            continue;
        }

        bytes_scanned = 0LL;

        newtFormDestroy( form );
        form = newtForm( NULL, NULL, 0 );
        progress = newtScale( 0, 12, 40, bytes_to_scan );
        msg = newtTextbox( 0, 0, 40, 7, NEWT_FLAG_WRAP );
        bcancel = newtButton( 15, 14, "Cancel" );
        newtFormAddComponents( form, msg, bcancel, progress, NULL );
        newtFormSetTimer( form, 50 );
        newtFormAddHotKey( form, NEWT_KEY_ESCAPE );
        newtDrawForm( form );
        newtRefresh();

        for( j = 0; j < files_to_scan->gl_pathc; j++ ) {
            tmp = files_to_scan->gl_pathv[ j ];
            newtTextboxSetText( msg, pad_message( tmp, PATH_MAX ) );
            newtRefresh();
            logprintf( "Scanning \"%s\".\n", tmp );

            newtFormRun( form, &einf );
            if( einf.reason != NEWT_EXIT_TIMER && newtWinChoice( "Abort", "No", "Yes", "Really Abort?" ) == 2 ) break;

            r = cl_scanfile( tmp, &vname, &scanned, scan_engine, scan_opts );
            switch( r ) {
                case CL_VIRUS:
                    if( !TUI_OPTION( TUI_NALARM ) ) newtBell();
                    logprintf( "Found the virus \"%s\" in \"%s\"\n", vname, tmp );
                    if( TUI_OPTION( TUI_PROMPT ) ) {
                        switch( newtWinTernary( "Virus", "Ignore", "Quarrantine", "Clean",
                                                "\"%s\" is infected with \"%s\".  What action should be taken?", tmp, vname ) ) {
                            case 2:
                                action = ACTION_BACKUP;
                                break;
                            case 3:
                                action = ACTION_CLEAN;
                                break;
                            default:
                                action = ACTION_IGNORE;
                                break;
                        }
                    } else if( TUI_OPTION( TUI_BACKUP ) || opts & FDAV_QUTINE ) action = ACTION_BACKUP;
                    else if( opts & FDAV_REMOVE || want_cleaned ) action = ACTION_CLEAN;
                    else action = ACTION_IGNORE;

                    switch( action ) {
                        case ACTION_BACKUP:
                            logprintf( "Attempting to quarrantine \"%s\"\n", tmp );
                            if( backup_file( tmp ) ) {
                                newtWinMessage( "Error", "OK", "Could not quarrantine \"%s\"", tmp );
                                break;
                            }
                        case ACTION_CLEAN:
                            logprintf( "Attempting to remove \"%s\"\n", tmp );
                            if( unlink( tmp ) ) {
                                newtWinMessage( "Error", "OK", "Could not clean \"%s\"", tmp );
                            }
                            logprintf( "Removed \"%s\"\n", tmp );
                            break;
                        case ACTION_IGNORE:
                            if( !TUI_OPTION( TUI_PROMPT ) ) newtWinMessage( "Virus", "OK", "\"%s\" is infected with \"%s\"", tmp, vname );
                            break;
                    }
                    break;
                case CL_CLEAN:
                    break;
                default:
                    switch( newtWinChoice( "Error", "Yes", "No", "An error occured while scanning \"%s\".  Continue Scanning?", tmp ) ) {
                        case 1:
                            break;
                        case 2:
                        default:
                            bytes_scanned = -1LL;
                            break;
                    }
                    break;
            }
            files_checked++;
            if( bytes_scanned == -1LL ) break;
            bytes_scanned += get_filesize( tmp );
            newtScaleSet( progress, bytes_scanned );
            newtRefresh();
        }
        newtFormDestroy( form );
        newtPopWindow();
    }
}

newtComponent tui_get_listbox( newtComponent uselist, char **paths, int npaths )
{
    newtComponent list = NULL;
    char *tmp, *tmp2;
    int i, len;

    if( uselist ) {
        list = uselist;
        newtListboxClear( list );
    }
    else list = newtListbox( 3, 2, 12, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER );

    for( i = 0; i < npaths; i++ ) {
        tmp = strdup( paths[ i ] );
        dos_filename( tmp );
        len = strlen( tmp ) - 1;
        if( tmp[ len ] == '\\' ) tmp[ len ] = '\0';
        tmp2 = basename( tmp );
        if( tmp2 == NULL || !*tmp2 ) tmp2 = tmp;
        if( tmp[ len ] == '\0' ) tmp[ len ] = '\\';
        newtListboxAppendEntry( list, tmp2, ( void * )i );
        free( tmp );
    }
    newtListboxSetWidth( list, 54 );

    return( list );
}

char *get_normal_path( const char *in_path )
{
    char temp[ PATH_MAX ];

    if( !strcmp( &in_path[ 1 ], ":\\.." ) ) return( strdup( "-/" ) );

    realpath( in_path, temp );
    dos_filename( temp );

    return( strdup( temp ) );
}

void tui_select_drive( void )
{
    int last_sel = -1, i;
    char *sel_dir = strdup( "-/" ), *tmp;
    const char *input_line;
    newtComponent form, list, bselect, bok, bcancel, input;
    struct newtExitStruct einf;
    glob_t *sel_files = NULL;

    newtCenteredWindow( 60, 18, "Select a File/Directory" );
    form = newtForm( NULL, NULL, 0 );
    list = newtListbox( 3, 2, 12, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT | NEWT_FLAG_BORDER );
    bselect = newtButton( 3, 14, "Select" );
    bok = newtButton( 28, 14, "OK" );
    bcancel = newtButton( 47, 14, "Cancel" );
    input = newtEntry( 3, 1, NULL, 54, &input_line, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT );
    newtFormAddComponents( form, list, bselect, bok, bcancel, input, NULL );

    newtFormSetTimer( form, 50 );
    newtFormAddHotKey( form, NEWT_KEY_ESCAPE );

    do {
        if( !sel_files ) {
            sel_files = tui_get_files( sel_dir, 0 );
            if( sel_files == NULL ) {
                newtWinMessage( "Error", "OK", "Could not retrieve directory information" );
                goto finish;
            }
            tui_get_listbox( list, sel_files->gl_pathv, sel_files->gl_pathc );
            last_sel = -1;
        }
        if( ( i = ( int )newtListboxGetCurrent( list ) ) != last_sel ) {
            tmp = get_normal_path( sel_files->gl_pathv[ i ] );
            if( !strcmp( tmp, "-/" ) ) tmp = strdup( ".." );
            newtEntrySet( input, tmp, 1 );
            free( tmp );
            last_sel = i;
        }

        newtFormRun( form, &einf );

        if( einf.reason == NEWT_EXIT_COMPONENT ) {
            if( einf.u.co == input ) {
                if( access( input_line, F_OK ) ) {
                    newtWinMessage( "Error", "OK", "No such file" );
                    last_sel = -1;
                    break;
                }
                free( sel_dir );
                sel_dir = get_normal_path( input_line );
                goto finish_sel;
            }
            if( einf.u.co == bok || einf.u.co == list ) {
                tmp = get_normal_path( sel_files->gl_pathv[ ( int )newtListboxGetCurrent( list ) ] );
                if( !strcmp( sel_dir, tmp ) ) {
                    free( tmp );
                    goto finish_sel;
                }
                free( sel_dir );
                sel_dir = tmp;
                if( strcmp( sel_dir, "." ) && ( !access( sel_dir, D_OK ) || !strcmp( sel_dir, "-/" ) ) ) {
                    sel_files = NULL;
                    continue;
                }
                goto finish_sel;
            }
            if( einf.u.co == bselect ) {
                free( sel_dir );
                sel_dir = get_normal_path( sel_files->gl_pathv[ ( int )newtListboxGetCurrent( list ) ] );
                if( !strcmp( sel_dir, "-/" ) ) {
                    sel_files = NULL;
                    einf.reason = NEWT_EXIT_TIMER;
                }
            }
            if( einf.u.co == bcancel ) goto finish;
        }
        if( einf.reason == NEWT_EXIT_HOTKEY ) goto finish;
    } while( einf.reason != NEWT_EXIT_COMPONENT || einf.u.co != bselect );

finish_sel:
    free( filev[ 0 ] );
    filev[ 0 ] = get_normal_path( sel_dir );
    free( sel_dir );

finish:
    newtFormDestroy( form );
    newtPopWindow();
}

void tui_get_options( void )
{
    int i, half = TUI_MAX_OPTS, left = 1, top = 1;
    newtComponent form, bok, bcancel, opts[ TUI_MAX_OPTS ];
    struct newtExitStruct einf;
    char results[ TUI_MAX_OPTS ];

    i = half % 2;
    half = TUI_MAX_OPTS / 2 + i - 1;

    newtCenteredWindow( 60, 13, "Options" );
    form = newtForm( NULL, NULL, 0 );
    newtFormAddHotKey( form, NEWT_KEY_ESCAPE );

    for( i = 0; i < TUI_MAX_OPTS; i++ ) {
        if( left == 1 && i > half ) {
            left = 30;
            top = 1;
        }
        opts[ i ] = newtCheckbox( left, top, av_options[ i ].name, TUI_OPTION( i ) ? 'X' : ' ', " X", &results[ i ] );
        newtFormAddComponent( form, opts[ i ] );
        top++;
    }
    bok = newtButton( 10, 9, "OK" );
    bcancel = newtButton( 40, 9, "Cancel" );
    newtFormAddComponents( form, bok, bcancel, NULL );

    newtFormRun( form, &einf );
    if( einf.reason == NEWT_EXIT_COMPONENT && einf.u.co == bok )
        for( i = 0; i < TUI_MAX_OPTS; i++ ) TUI_OPTION( i ) = results[ i ] == ' ' ? 0 : 1;

    newtFormDestroy( form );
    newtPopWindow();
}

int tui_main( void )
{
    int i;
    newtComponent form, desc, file, msg, buttons[ TUI_BUTTON_MAX ];
    struct newtExitStruct einf;

    newtDrawRootText( 0, 0, "FreeDOS Anti-Virus " FDAV_VERSION_STRING );
    newtCenteredWindow( 70, 20, "Main Menu" );
    form = newtForm( NULL, NULL, 0 );
    for( i = 0; i < TUI_BUTTON_MAX; i++ ) {
        buttons[ i ] = newtButton( 5, 0 + ( i * 4 ), tui_buttons[ i ] );
        newtFormAddComponent( form, buttons[ i ] );
    }
    desc = newtTextbox( 40, 5, 20, 12, NEWT_FLAG_WRAP | NEWT_FLAG_BORDER );
    file = newtTextbox( 30, 15, 35, 4, NEWT_FLAG_WRAP | NEWT_FLAG_BORDER );
    msg  = newtTextbox( 30, 14, 35, 1, 0 );
    newtTextboxSetText( msg, "Current File/Directory" );
    newtTextboxSetText( file, filev[ 0 ] );
    newtFormAddComponents( form, desc, file, msg, NULL );
    newtFormSetTimer( form, 50 );
    newtFormAddHotKey( form, NEWT_KEY_F10 );
    newtFormAddHotKey( form, NEWT_KEY_F1 );
    newtFormAddHotKey( form, NEWT_KEY_ESCAPE );

    do {
        for( i = 0; i < TUI_BUTTON_MAX; i++ ) if( newtFormGetCurrent( form ) == buttons[ i ] ) newtTextboxSetText( desc, tui_info[ i ] );
        newtFormRun( form, &einf );
        if( einf.reason == NEWT_EXIT_HOTKEY ) {
            switch( einf.u.key ) {
                case NEWT_KEY_F12:
                case NEWT_KEY_F10:
                case NEWT_KEY_ESCAPE:
                    break;
                case NEWT_KEY_F1:
                    tui_view_help( 0 );
                    einf.reason = NEWT_EXIT_TIMER;
                    break;
            }
        }
        if( einf.reason == NEWT_EXIT_COMPONENT ) {
            for( i = 0; i < TUI_BUTTON_MAX; i++ ) if( buttons[ i ] == einf.u.co ) break;
            switch( i ) {
                case TUI_BUTTON_DETECT:
                    tui_do_scan( 0 );
                    einf.reason = NEWT_EXIT_TIMER;
                    break;
                case TUI_BUTTON_DCLEAN:
                    tui_do_scan( 1 );
                    einf.reason = NEWT_EXIT_TIMER;
                    break;
                case TUI_BUTTON_NDRIVE:
                    tui_select_drive();
                    newtTextboxSetText( file, filev[ 0 ] );
                    einf.reason = NEWT_EXIT_TIMER;
                    break;
                case TUI_BUTTON_OPTION:
                    tui_get_options();
                    einf.reason = NEWT_EXIT_TIMER;
                    break;
                case TUI_BUTTON_AVEXIT:
                    break;
                default:
                    einf.reason = NEWT_EXIT_TIMER;
                    continue;
            }
        }
    } while( einf.reason == NEWT_EXIT_TIMER );
    newtFormDestroy( form );

    return( 0 );
}

void tui_cleanup( void )
{
    newtFinished();
    _set_screen_lines( av_rows );
}

extern void *__libc_write_termios_hook;

int fdav_tui( void )
{
    int        lines = 25;

    av_rows = ScreenRows();

    if( opts & VIDEO_BIOS ) putenv( "TTY_SCREEN_INTFACE=BIOS" );
    if( opts & VIDEO_LINES ) {
        if( opts & VIDEO_28 ) lines = 28;
        if( opts & VIDEO_43 ) lines = 43;
        if( opts & VIDEO_50 ) lines = 50;
        if( opts & VIDEO_60 ) lines = 60;

        _set_screen_lines( lines );
    }

    atexit( tui_cleanup );
    newtInit();
    newtCls();
    if( opts & VIDEO_ANSI ) {
        __libc_write_termios_hook = NULL;
    }

    tui_main();

    return( 0 );
}
