
PG 1.09                                                 PG 1.09


NAME
        PG -- PaGer
        A text file viewer presented by FreeDOS

SYNOPSIS
        PG [/? | filename]
            /?       - display a brief help screen
            filename - page through filename on the PC screen
                     - filename maybe in wildcard format
            if filename is omitted, read data from <stdin>

DESCRIPTION
        PG is a text file viewer presented by the FreeDOS.
        It browses any text file and with more useful features now.
        Read this manual carefully to get the most from PG.

COMMAND
        Control is intuitive, Keys defined as:

        PG Key      Meaning
        ======      =======
        Esc,Q       Exit program
        B           Toggle bit 7 on/off
        H           Hex view
        W           Wrap long lines
        Up          Scroll down 1 line
        Down,Enter  Scroll up 1 line
        Page Up     Scroll down 1 page
        Page Down   Scroll up 1 page
        Home        First page
        End         Last page
        Left        Pan view left 30 columns (1..256)
        Right       Pan view right 30 columns (1..256)
        1..5        Save current position to boomark #1..5
        Alt-1..5    Jump to saved bookmark
        Alt-D       Jump to DOS shell
        Backspace   Jump to a line as far as possible
        F1          Online help
        F2          Continue to search backward (Case Insensitive) (CI)
        F3          Continue to search forward  (CI)
        F4          Enter search mode and input search string (CI)
        S-F2        Continue to search backward (Case Sensitive) (CS)
        S-F3        Continue to search forward  (CS)
        F5          Save 1 screenful of text to "PG.SAV"
        C-PageUp    View previous file
        C-PageDn    View next file

All single character commands require uppercase letter.

        Bookmarks #1..5
            As you're viewing a text file, press any of the numeric
            keys 1..5 (under the Function keys), for instance, pressing
            '1' will save the top position of the file you're viewing to
            bookmark #1. Later on, when you want to return to the place
            where you left bookmark #1, just press 'Alt' and '1' brings
            you back no matter how far you've been.
            Bookmark #1 can be updated whenever you press '1' again.
            The same is true to other bookmark keys.

 Backspace  Jump to line
            Prompt you to enter a line number, then jump as far
            as possible.  Line number will be the top line and
            displayed at the end of the top status line.

        F1  Show you this manual by plugin

        F2  continues case insensitive search backward for the next
            occurrence, the line number appears at the bottom status
            line if the search is successful. It disappears if the
            search failed.

        F3  continues to search forward for the next occurrence,
            the line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F4  Search text
            Press F4 to enter search mode, you're prompted to input
            a string. The search start from the top line of your screen,
            then to next line and so on. Follow by
            F3 to search forward (CI);
            F2 to search backward (CI);
            Shift+F3 to search forward (CS);
            Shift+F2 to search backward (CS);
            If the string is found, the
            line number of the string found appears behind the
            search string.  If it is not found, nothing happens.
            Press F4 again to start a new search.


        F5  Save screen to "PG.SAV"
            When we're are viewing a file, sometimes, we want to get
            an extract from the source instead of retyping. PG helps
            us to save a screenful of text as we press the F5 key,
            a message looks "!!! copy from filename line # !!!" will
            prepend the text we want to copy, and the file "PG.SAV",
            we need to tell PG which drive to save, just once.

    C-PgUp  Previous file
            To view the previous file from the list.

    C-PgDn  Next file
            To view the next file from the list.


COPYING
        This file and other related programs stored in PG108.ZIP are
        distributed under the terms of the GNU General Public License.
        See the file COPYING for details. And read the author's
        "Legal stuff" as written in the comments of the program
        source file.


What's new is version 1.09
        - Replace cloning with C's spawnlp()
        - Display pancolumn;
        - Binary files included again

Features
        - view very large file (262,144 lines);
        - multiple files viewing (256 in 1 directory);
        - top line is restored as viewing multiple files;
        - forward / reverse search (both sensitive and insensitive)
        - save screens to a save file;
        - view panning (max. 256 columns)
        - online help;
        - wrap long line
        - hex view
        - piping
        - 5 bookmarks
        - bit 7 on / off
        - jump to line;
        - jump to DOS shell
        - exclude file formats considered binary;
        - cursor appear over searched line;
        - simple user interface

        Read the news file for development details


Portability
        Operating Systems
        1. Linux DOSEMU 1.2.0
        2. FreeDOS native mode
        3. M$DOS Windows box
        4. M$DOS native mode
        Hardwares
        VGA, CGA, MONO


PACKAGE (version 1.09) PG109.ZIP
        PG.C        - C source program
        PG.H        - C header
        PG.MAN      - Manual (this file)
        PG.EXE      - the program
        PGASM.ASM   - assembly subroutines
        PG.MAK      - make file for Turbo C 2.01
        NEWS        - anouncement
        TO_DO       - job list
        COPYING     - copyright
        SVHEX.ASM   - Plugin source file (hex)
        SVTXT.ASM   - Plugin source file (text)
        SVHEX.COM   - Plugin binary (hex)
        SVTXT.COM   - Plugin binary (text)


INSTALL PG (version 1.09)

        To compile PG you need:
        1. Borland Turbo C 2.01
        2. Nasm 0.98.xx

        Type:
            tcc -c pg.c
            nasm -f obj pgasm.asm -o pgasm.obj
            tlink lib\c0s pg pgasm,pg,,lib\cs

        This will generate the PG.EXE program.


        or
            d:\>make -fpg.mak -Dtc=Turbo_C_Directory


        Should you get any error, check if the path is correct
        in "PG.MAK".  Also read message from previous maintainer
        at the last section of this manual.


Programming Resources

        PG 1.09 -- Turbo C with Nasm
          Borland Turbo C 2.01
          NASM 0.98
          Insight 1.10

        Turbo C 2.01 is available at the Borland Software Museum.
          http://community.borland.com/museum/

        Nasm 0.98.xx is available at
          http://nasm.sourceforge.net/

        Insight 1.10
          http://www.freedos.org/


Limitations
        PLUGINS cannot handle file size > 64K


Author  Bill Weinmen
        E-mail: wew@bearnet.com
        BAHCL (plugin)

Maintainer  BAHCL
        version : 1.09  1.08  1.07  1.06  1.05  1.04  1.03  1.02
        E-mail: freedos_pg@yahoo.com.hk


Messages from the maintainer:

        PG has gone a long way to reincarnate itself. It looks
        like it used to be, but do not judge it by appearance.
        PG has the power, features, abilities that rivals similar
        text browser in the market, even the M$ realm.

        Previous messages has been moved to the news file.

        I want to express my thanks to the authors of HELPPC, INSIGHT,
        TURBO C, NASM, IBM Tiny Editor. Without their contribution, PG
        may not have made possible.


BAHCL



Messages from previous PG maintainer(s):

============================================================
I have made a few changes to the source, but didn't (technically)
delete anything.  I removed the verbose GNU License statement in the
usage() function.  To put it back in, add this to the code:

   #define SHOW_GNU_COPYING

or, compile like this:

  cc pg.c -fop SHOW_GNU_COPYING=1

============================================================
I have set the default behavior of the program to operate in
mono-mode only.  This is a color scheme that should work well on all
monitors, even a mono display.  To build using Bill's original
colors, add this to the code:

   #define USE_COLOR_MODE

or, compile like this:

  cc pg.c -fop USE_COLOR_MODE=1



============================================================
(Jim Hall, jhall1@isd.net)


