/*
  pg.c    1.07

  (c) 1995-1998 Bill Weinman, wew@bearnet.com

  Generic Screen Pager for FreeDOS

  This program was coded particularly for use with my FreeDOS help
  system.  I am making it available as a module for general use because
  it's generally useful.  It is not intended to be the pager-to-beat-
  all-pagers because I don't need that.  If you do, you can either 
  suggest enhancements--and if I think they're really kewl and feel
  like coding them I will--or you can code them yourself and submit
  them to me; but please, if you want me to continue to support this
  code then please don't enhance the code without letting me know.
                      --BearHeart, Phoenix, AZ
                        wew@bearnet.com

  Maintainer: BAHCL   freedos_pg@yahoo.com.hk


  Programming Environment:
    Please read pg.man section "INSTALL PG"


  Legal Stuff
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include "pg.h"

#define setattr(attr) (curatt = attr)

/* Globals */

char *stat[] =
{ 
  "     ", 
  "<top>", 
  "<end>" 
};

struct {                                        /* file list */
  char filename[12];                            /* file name */
  unsigned long start;                          /* display line */
  unsigned long offset;                         /* display offset */
} *filelist, *fl;

char searchstr[20];                             /* search string */
char buffer[128];                               /* scratch buffer */
int  groupid;                                   /* active group id */
int lpg = LINEADDRS;                            /* Lines per group */
unsigned long lineaddr[LINEADDRS];              /* offset of a line in file */
unsigned long groups[GROUPS];                   /* offset of the first line in the group */
unsigned long bookmark[5];                      /* BAHCL add 5 bookmarks */
unsigned long searchline;                       /* search line number */
unsigned long numlines;                         /* num of lines in the file */
int Color = false;                              /* color flag */
unsigned int  VideoRegen;                       /* video regen pointer */
unsigned int  RegenSize;                        /* in words  */
unsigned char DispMode;                         /* display adapter mode */
unsigned char DispRows;                         /* display rows (from BIOS) */
unsigned int  DispCols;                         /* display cols (from BIOS) */
unsigned char curatt;                           /* current attribute */
unsigned char attr_status, attr_lo_status, attr_text;
char linebuf[MAXSIZELINE];                      /* buffer for reading lines */
int  tabstops = TABSTOPS;                       /* should be run-time switch */
int  filenum, maxfile;                          /* infile number, max. files */
char *infilename;                               /* input file name */
FILE *infile;                                   /* input file pointer */
FILE *pgsav=NULL;                               /* save file */
unsigned long showline;                         /* show top line */
unsigned long offset;                           /* infile offset */

/* Local Functions */
void InitVideo(void);                           /* call this first */
/* replaced with read_infile() for speed */
/* unsigned long readlines(FILE *); */               /* read in the line addresses */
int  getline(long);                             /* get a line from infile */
void exptabs(void);                             /* expand tabstop */
void display(long, int);                        /* display file content */
int  pagefile(long);                            /* user interface */
void save_screen(long, long);                   /* save screen to disk */
void mvaddnstr(int,int,int,char *);             /* print at only n char from str */
void usage(void);                               /* tell 'em how ta use it */
void errorexit(int, char *);                    /* error!! bail out! */
void headline(long);                            /* program head line */
void clearline(int, char);                      /* clear a line */
char *strfind(char *, char *);                  /* find substring */
char *strrfind(char *, char *);                 /* find substr backward */
void line2offset(long);                         /* convert line # to offset */
void load_grp_li_addr(int);                     /* reload the line addresses of a group */
int  accept(char *);                            /* accept files not blacklisted */

/* Global Assembly language functions */
extern mvaddch(int, int, int, int);             /* row,col,vidchar,attr */
extern getbiosinfo(void);                       /* get BIOS information */
extern getstr(char *);                          /* Get a string */
extern kbget(void);                             /* get keyboard scancode */
extern setup_help(void);                        /* setup help information */
extern on_line_help(void);                      /* On line help */
extern read_infile(void);

int
main(int argc, char **argv)
{
  int pathlen, i;
  struct ffblk ffblk;

  infilename = buffer+20;
  fnsplit(argv[1], buffer+20, buffer+23, buffer+90, buffer+100);
  InitVideo();                                      /* Init & get screen info */
  if (argc == 1)                                    /* no file name */
    {
      usage();                                      /* show usage */
    }
  else if (strcmp(argv[1], "/?") == 0)              /* basic help */
    {
      usage();
    }
  else                                              /* get ready */
    {
      filelist = malloc(5120);                      /* allocate mem. for */
                                                    /* about 256 filenames */
      fl = filelist;
      maxfile  = 0;
      filenum = findfirst(argv[1],&ffblk,0);        /* find # of files */
      while(!filenum)
        {
          if (accept(ffblk.ff_name))                /* checks file extension */
            {
              strncpy(fl->filename, ffblk.ff_name, 12);
              fl->start = 1L;
              fl->offset = 0L;                      /* each file starts line 1 */
              ++fl;                                 /* offset 0 */
              ++maxfile;
            }
          filenum = findnext(&ffblk);
        }
      free(filelist);
      if (maxfile == 0)                             /* No file */
        {
          errorexit(1, strcat("pg: cannot open file ", argv[1]));
        }
    }

/*  adjust the actual memory required */
  filelist = malloc(maxfile * sizeof(*filelist));
  setup_help();                                     /* Setup on-line help */
  filenum = 1;
  strcat(infilename, infilename+3);
  pathlen = strlen(infilename);
  while (filenum <= maxfile)                        /* process individual file */
    {
      fl = filelist+filenum-1;
      strncpy(infilename + pathlen, fl->filename, 12);

      infilename[pathlen + 12] = '\0';
      numlines = 1;
      groupid = 0;
      for (i = 0; i < 5; i++)
        {
          bookmark[i] = 0L;
        }

      read_infile();                                /* assembly routines */
      infile = fopen(infilename, "rb");
      clrscr();
      showline = fl->start;
      offset = fl->offset;

      display(showline,0);                          /* instant display file content */
/* replaced by read_infile() */
/*    numlines = readlines(infile); */              /* read all the line addresses */
      filenum = pagefile(showline);                 /* page thru the file */

      fl->start = showline;
      fl->offset = offset;
      if (filenum < 1)  filenum = 1;
      setattr(attr_text);                           /* reset video attribute */
      fclose(infile);
    }
  free(filelist);
  clrscr();
  return(0);
}

/*
   readlines() - Read the whole file and extract the address of the
   beginnng of each line.
   BAHCL : These addresses stored in groups[] and lineaddress[]
*/
/* replaced by read_infile()
unsigned long
readlines(FILE *infile)
{
  unsigned long linenum, address;
  int i, j;
  char *ptr;

  i = 0;
  j = 0;
  linenum = 0;
  rewind(infile);
  do
    {
      address = ftell(infile);
      if ((linenum % LINEADDRS) == 0)
        {
          i = 0;
          groups[j++] = address;
        }
      lineaddr[i++] = address;
      ptr =  fgets(linebuf, MAXSIZELINE - 1, infile);
      ++linenum;
    } while (ptr);
  groupid = --j;
  return (linenum);
}
*/

/*
   getline() -  Find a line of text from the line buffer. Returns
   pointer to linebuf or zero if cannot find
*/
int
getline(long linenum)
{
  unsigned long tmpoffset;
  linebuf[0] = NULL;
  if (linenum >= numlines)
    {
      return 0;                                 /* error */
    }
  else
    {
      line2offset(linenum);
      fseek(infile, offset, SEEK_SET);
      fgets(linebuf, MAXSIZELINE - 1, infile);
      return 1;
    }
}

/*
   exptabs() -  Expand tabs in the line buffer.
   (Added 21 aug 98, wew)
   BAHCL : handles LF,CR as Turbo C 'gets' does not remove them;
           also SPACE => space
*/
void
exptabs(void)
{
  register i;
  register o;
  char out[MAXSIZELINE];
  char *in;
  char space;

  in = linebuf;
  memset(out, 0, MAXSIZELINE);
  space = '\x20';
  for(i = o = 0; o < (MAXSIZELINE - 1) && in[i]; i++, o++)
    { 
      switch(in[i])
        {
          case TAB:
            out[o] = space;
            while((o+1) % tabstops && (o < (MAXSIZELINE - 1)))
              {
                out[++o] = space;
              }
            break;
          case '\xD':                               /* replace linefeed */
            out[o] = space;
            break;
          case '\xA':                               /* replace return */
            out[o] = NULL;
            break;
          default:
            out[o] = in[i];
            break;
        }
    }
  memcpy(linebuf, out, MAXSIZELINE);
}

/* display lines to screen */
void display(long line, int pancolumn)
{

  long lineno;                  /* current line number */
  long topline;                 /* top screen line */
  int botline;                  /* bottom screen line */
  int screenline;               /* current screenline */
  int pagesize;                 /* vert size of display area */
  int pageoffset;               /* offset into page */
  char *str;

  /* Initialize variables */
  topline    = line;
  botline    = DispRows - 2;
  pagesize   = DispRows - 2;
  pageoffset = 0;

  if (numlines < (pagesize))
    {
      pagesize = numlines - 1;
    }

  headline(topline);                        /* show file information */
  setattr(attr_status);

  fseek(infile, offset, SEEK_SET);
  lineno = topline;
  while((lineno - topline) < botline)       /* display loop */
    {
      screenline = lineno - topline + 1;    /* where are we on the screen? */
      str = fgets(linebuf, MAXSIZELINE - 1, infile);
      lineno++;
      if(str)
        {
          exptabs();                            /* expand the tabs (21 aug 98 wew) */
          clearline(screenline, attr_text);
          setattr(attr_text);
          mvaddnstr(screenline, pageoffset, DispCols, linebuf+pancolumn);
        }
    } /* while */
  setattr(attr_status);
}

/* user interface here */
int
pagefile(long line)
{
  long topline;                 /* top screen line */
  int screenline;               /* current screenline */
  int pagesize;                 /* vert size of display area */
  int quit;                     /* (jh) flag, for the exit condition */
  int pancolumn;                /* pan columns */
  char sdf;                     /* search direction flag */

  /* Initialize variables */
  pancolumn  = 0;
  searchline = 0;
  topline    = line;
  pagesize   = DispRows - 2;
  quit       = 0;               /* (jh) */
  sdf        = 'F';             /* assume forward */

  headline(topline);                        /* show file information */
  clearline(DispRows - 1, attr_status);

  while (!quit)
    {
      switch(kbget())
        {
          case PG_UP:
            topline -= pagesize;
            break;
          case SPACE:                   /* (jh) */
          case PG_DN:                   /* scroll down by one screen */
            if (topline + pagesize < numlines)
              {
                topline +=  pagesize;
              }
            break;
          case KEY_HOME:
            topline = 1;
            break;
          case KEY_END:
            topline = numlines - pagesize;
            break;
          case KEY_UP:
            if(topline > 1)
              {
                --topline;
              }
            break;
          case RETURN:                          /* scroll down one line only */
          case KEY_DN:
            if((topline + pagesize) < numlines)
              {
                topline++;
              }
            break;
          case KEY_F9:                              /* F9 Prev file */
            quit = 1;
            --filenum;
            break;
          case KEY_F10:                             /* F10 Next file */
            quit = 1;
            ++filenum;
            break;
          case ESC:                                 /* Quit */
          case KEY_Q:
          case KEY_q:
            quit = 1;
            filenum = maxfile + 1;
            break;
          case SEARCH:                              /* Begin a search */
            clearline((int) DispRows-1, attr_status);
            mvaddnstr((int) DispRows-1, 0, 9, "Search:  ");
            searchstr[0]=19;
            getstr(searchstr);
            if (searchstr[1])
            {
              searchline = topline;
              if (strfind(linebuf, searchstr+2))
                {
                  ltoa(searchline-1, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  topline = searchline-1;
                }
              sdf = 'F';
            }
            break;
          case KEY_JMP:                              /* ? Jump to line */
            clearline((int) DispRows - 1, attr_status);
            mvaddnstr((int) DispRows - 1, 0, 10, "Jump to:  ");
            buffer[0]=19;
            getstr(buffer);
            if (buffer[1])
              {
                topline = atol(buffer + 2);
              }
            clearline((int) DispRows - 1, attr_status);
            break;
          case KEY_1:                               /* set Bookmark #1 */
            bookmark[0] = topline;
            break;
          case KEY_2:
            bookmark[1] = topline;
            break;
          case KEY_3:
            bookmark[2] = topline;
            break;
          case KEY_4:
            bookmark[3] = topline;
            break;
          case KEY_5:
            bookmark[4] = topline;
            break;
          case KEY_A1:                              /* Back to bookmark #1 */
            topline = bookmark[0];
            break;
          case KEY_A2:
            topline = bookmark[1];
            break;
          case KEY_A3:
            topline = bookmark[2];
            break;
          case KEY_A4:
            topline = bookmark[3];
            break;
          case KEY_A5:
            topline = bookmark[4];
            break;
          case KEY_F1:                                /* On-line help */
            on_line_help();
            break;
          case KEY_F2:                                /* cont. search backward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        "); /* clear result area */
            if (searchstr[1])
            {
              if (sdf == 'F')
                {
                  searchline -= 2;
                }
              if (strrfind(linebuf, searchstr+2))
                {
                  ltoa(searchline+1, buffer, 10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  topline = searchline+1;
                }
              sdf = 'R';                            /* reverse search */
            }
            break;
          case KEY_F3:                              /* cont. search forward */
            mvaddnstr((int) DispRows-1, DispCols-9, 8, "        ");
            if (searchstr[1])
            {
              if (sdf == 'R')
                {
                  searchline += 2;
                }
              if (strfind(linebuf, searchstr+2))
                {
                  ltoa(searchline-1,buffer,10);
                  mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
                  topline = searchline-1;
                }
              sdf = 'F';                            /* forward search */
            }
            break;
          case KEY_F4:                              /* save screen to file */
            save_screen(topline, topline + DispRows - 2);
            break;
          case KEY_LT:                              /* Left key */
            pancolumn -= 20;                        /* pan left */
            if (pancolumn < 0) pancolumn = 0;
            break;
          case KEY_RT:                              /* Right key */
            pancolumn += 20;                        /* pan right */
            if (pancolumn > PANLIMIT) pancolumn = 0;
            break;
          case BK_SPACE:
          default:
            break;
         } /* switch */
       if (topline < 1)          /* alert top of file? */
         {
           topline = 1;
         }
       else if (topline > (numlines - pagesize)) /* alert bot of file? */
         {
           topline = numlines - pagesize;
         }
       if (quit != 1)
         {
           line2offset(topline);
           display(topline, pancolumn);
         }
    }   /* !Quit */
    showline = topline;
    return filenum;
}

/* save screen to a save file */
void
save_screen(long saveline, long toline)
{
  long seekpos, pos1, pos2;
  char *savefile = "C:\\PG.SAV";

  clearline((int) DispRows-1, attr_status);
  mvaddnstr((int) DispRows-1, 0, 10, "Save to...");
  if (pgsav == NULL)                            /* if not open yet */
    {
      buffer[0]=2;                              /* get the drive letter only */
      getstr(buffer);
      savefile[0] = buffer[2];
    }

  if ((pgsav = fopen(savefile, "ab")) == NULL)  /* append data */
    {
      return;
    }
  strcpy(linebuf, "!!! Copy from ");            /* indentify copy info */
  strcat(linebuf, infilename);
  strcat(linebuf, " line ");
  strcat(linebuf, ltoa(saveline, buffer,10));
  strcat(linebuf, " !!! ");
  fwrite(linebuf, strlen(linebuf), 1, pgsav);

  if (toline >= numlines)
    toline = numlines;
  line2offset(saveline);
  fseek(infile, offset, SEEK_SET);
  pos1 = ftell(infile);
  while (--toline - (saveline-1))
    {
      fgets(linebuf, MAXSIZELINE - 1, infile);
      pos2 = ftell(infile);
      fwrite(linebuf, pos2 - pos1, 1, pgsav);
      pos1 = pos2;
    }
  fclose(pgsav);
  mvaddnstr((int) DispRows-1, 9, 10, savefile);
}

/* Get display adaptor info. and initialize */
void
InitVideo(void)
{
  getbiosinfo();
  RegenSize = DispRows * DispCols;     /* for use in asm functions */
  VideoRegen = (DispMode == MONO ? 0xb000 : 0xb800);
  Color = (DispMode == MONO ? false : true);

/* BAHCL moved from main() */
#ifdef USE_COLOR_MODE                   /* (jh) */
  if(Color)
    {
      attr_status    = CO_STATUS;
      attr_lo_status = CO_LO_STATUS;
      attr_text      = CO_TEXT;
    }
  else
    {
      attr_status    = MO_STATUS;
      attr_lo_status = MO_LO_STATUS;
      attr_text      = MO_TEXT;
    }
#else
  attr_status    = ATTR (BLACK, WHITE);			/* (jh) */
  attr_lo_status = ATTR (BLACK, WHITE);			/* (jh) */
  attr_text      = ATTR (WHITE, BLACK);			/* (jh) */
#endif /* USE_COLOR_MODE */

  setattr(attr_text);

}

/* BAHCL: useful as the one in Linux ncurses */
void
mvaddnstr(int prow, int pcol, int n, char *s)
{
  int i;
  i = 0;
  while (s[i] && (i < n))
    {
      mvaddch(prow, pcol++, s[i++], curatt);
    }
}

/* error exit */
void
errorexit(int pcode, char *args)
{
    mvaddnstr((int) DispRows-1,0,80,args);
    exit(pcode);
}

/* program usage */
void
usage(void)
{
  /* (jh) I moved all the usage text here so that the text wasn't
     separated from the usage() function */

  /* (jh) I moved the VERSION text here, since it is not used
     anywhere else. */

  /* (jh) Most DOS programs just show the name and usage, but you can
     build with the GNU 'copying' statement anyway by using
     -DSHOW_GNU_COPYING */
  int i;
  i = 0;
  clrscr();   /* BAHCL */
  mvaddnstr(0,0,80,"PG, version 1.0 (c) 1995-1998 Bill Weinman, wew@bearnet.com");
  mvaddnstr(1,0,80,"PG, version 1.07 2003 Maintainer BAHCL, freedos_pg@yahoo.com.hk");

#ifdef SHOW_GNU_COPYING
  mvaddnstr(2,0,80,"Distributed under the terms of the GNU General Public License.");
  mvaddnstr(3,0,80,"See the file COPYING for details.");
  i = 2;
#endif

  mvaddnstr(3+i,0,80,"usage:  PG [/?] [filename]");
  mvaddnstr(4+i,0,80,"  /?       - display this help screen.");
  mvaddnstr(5+i,0,80,"  filename - page through filename on the PC screen");
  mvaddnstr(6+i,0,80,"             filename maybe in wildcard format");
  mvaddnstr(7+i,0,80,"             if filename is omitted, shows this help screen");
  mvaddnstr(8+i,0,80,"  Read pg.man for details.");

  exit(0);
}

/* Just a blank line with status attribute */
void
clearline(int lin, char attr)
{
  int i;

  setattr(attr);
  for (i = 0; i < DispCols; i++)
    {
      mvaddnstr(lin, i, 1, " ");
    }
}

/* PG -- headline of file information */
void
headline(long line)
{
  int pgstat;

  clearline(0, attr_status);
  mvaddnstr(0, 1, 6, "PG -- ");
  mvaddnstr(0, 7, 40, infilename);
  pgstat = STATOK;

  if (line <= 1)
    {
      pgstat = STATTOP;
    }

  if ((line + DispRows - 2) >= numlines)
    {
      pgstat = STATBOT;
    }

  mvaddnstr(0, 50, 5, stat[pgstat]);
  ltoa(numlines-1, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-10, 6, buffer);      /* total lines */
  ltoa(line, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-1, 6, buffer);       /* top line */
}

/* find sub-string in forward manner */
char *strfind(char *str1, char *str2)
{
  char *ptr;

  if (searchline == numlines)
    {
      searchline = 1;
    }
  do
  {
    getline(searchline++);
    ptr = strstr(str1, str2);
  } while((searchline < numlines) && (ptr == NULL));
  return ptr;
}

/* find sub-string in backward manner */
char *strrfind(char *str1, char *str2)
{
  char *ptr;
  if (searchline > numlines)
    {
      searchline = numlines;
    }
  do
  {
    getline(searchline--);
    ptr = strstr(str1, str2);
  } while((searchline < numlines) && (ptr == NULL));
  return ptr;
}

/* convert from line number to line address and the group  */
void line2offset(long line)
{
  int linenum, group;

  --line;                                           /* adjust for zero based */
  linenum = line % LINEADDRS;
  group   = line / GROUPS;
  if (groupid != group)                             /* not in current group */
    {
      load_grp_li_addr(group);
      groupid = group;
    }
  offset = lineaddr[linenum];
}

/* load line addresses within a group */
void load_grp_li_addr(int group)
{
  int  i;
  char *str;

  offset = groups[group];
  fseek(infile, offset, SEEK_SET);
  for (i = 0; i < LINEADDRS; i++)
  {
    lineaddr[i] = offset;
    str = fgets(linebuf, MAXSIZELINE - 1, infile);
    if (str == NULL) break;                         /* end of file */
    offset = ftell(infile);
  }
}

/* only accept files with file extension not binary format */
int accept(char *src)
{
  char *blacklist="BINCOMDLLDRVEXEOBJSYSVXDZIP";    /* file extensions */
  char *ptr;
  int i, j, k;

  k = 1;                                            /* accept */
  ptr = strchr(src,'.');
  if (ptr)
  {
    for (i=0, j=0; j < (strlen(blacklist) / 3); j++)
      {
        if (strncmp(blacklist + i, ptr + 1, 3) == 0)
          {
            k = 0;                                  /* reject */
            break;
          }
        i += 3;
      }
  }
  return k;
}
