{ Programm: fenster.pas
  Funktion: Anzeige eines GEM-Fensters
  Sprache:  Turbo Pascal ab 5.0
  Autor:    Jan Willamowius
  (C) 1991 DMV Widuch GmbH & Co KG }

(*$M 16384, 0, 10000*)
program fenster;

uses Gembind;

var foo,
    handle,
    event,
    x, y, w, h,
    xold, yold, hold, wold: Integer;
    msg: Message_Buffer;
    fulled: Boolean;
    wname,
    winfo: Window_Title;

procedure Draw_Window;
begin
  Paint_Style(Solid);
  Paint_Color(White);
  Work_Rect(handle, x, y, w, h);
  Paint_Rect(x, y, w, h);
  Line_Color(Black);
  Pline(x+(w DIV 2),y, x, y+(h DIV 2));
  Pline(x, y+(h DIV 2), x+(w DIV 2), y+h);
  Pline(x+(w DIV 2),y+h,x+w,y+(h DIV 2));
  Pline(x+w, y+(h DIV 2), x+(w DIV 2), y);
end;

procedure Redraw(xr, yr, wr, hr : Integer);
begin
  Hide_Mouse;
  First_Rect(handle, x, y, w, h);
  while (w <> 0) OR (h <> 0) DO
  begin
    if Rect_Intersect(xr, yr, wr, hr, x,
                      y, w, h) then
    begin
      Set_Clip(x, y, w, h);
      Draw_Window;
    end;
    Next_Rect(handle, x, y, w, h);
  end;
  Show_Mouse;
end;

begin
  if Init_Gem >= 0 then
  begin
    Init_Mouse;
    wname:= ' Beispiel 2 ';
    winfo:= ' Infozeile ';
    handle:= New_Window(
      G_Size OR G_Move OR G_Full OR
      G_Close OR G_Name OR G_Info,
      wname, 0, 0, 0, 0);
    Set_Winfo(handle, winfo);
    Open_Window(handle, 30, 30, 200, 100);
    fulled:= false;
    repeat
      event:=
          Get_Event(E_Message, 0, 0, 0, 0,
                        false, 0, 0, 0, 0,
                        false, 0, 0, 0, 0,
                        msg, foo, foo, foo,
                        foo, foo, foo);
      Begin_Update;
      if event AND E_Message <> 0 then
        case msg[0] of
          WM_Redraw :
            Redraw(msg[4], msg[5],
                   msg[6], msg[7]);
          WM_Sized,
          WM_Moved  :
            begin
              Set_WSize(handle, msg[4],
                msg[5], msg[6], msg[7]);
              Redraw(msg[4], msg[5],
                   msg[6], msg[7]);
            end;
          WM_Fulled :
            begin
              if fulled then
                Set_WSize(handle, xold,
                          yold, wold, hold)
              else begin
                Border_Rect(handle, xold,
                       yold, wold, hold);
                Work_Rect(0, x, y, w, h);
                Set_WSize(handle, x,
                          y, w, h);
              end;
              fulled:= NOT fulled;
            end;
        end;
      End_Update;
    until (event AND E_Message <> 0) AND
          (msg[0] = WM_Closed);
    Close_Window(handle);
    Delete_Window(handle);
    Exit_Gem;
  end
  else WriteLn('Fehler beim'+
       'Initialisieren des GEM!');
end.