;
; File:
;                         procsupt.asm
; Description:
;     Assembly support routines for process handling, etc.
;
;                     Copyright (c) 1995,1998
;                       Pasquale J. Villani
;                       All Rights Reserved
;
; This file is part of DOS-C.
;
; DOS-C is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version
; 2, or (at your option) any later version.
;
; DOS-C is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
; the GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public
; License along with DOS-C; see the file COPYING.  If not,
; write to the Free Software Foundation, 675 Mass Ave,
; Cambridge, MA 02139, USA.
;
; $Logfile:   C:/usr/patv/dos-c/src/kernel/procsupt.asv  $
;
; $Id: PROCSUPT.ASM,v 1.2 1999/04/16 12:21:22 jprice Exp $
;
; $Log: PROCSUPT.ASM,v $
; Revision 1.2  1999/04/16 12:21:22  jprice
; Steffen c-break handler changes
;
; Revision 1.1.1.1  1999/03/29 15:41:27  jprice
; New version without IPL.SYS
;
; Revision 1.4  1999/02/08 05:55:57  jprice
; Added Pat's 1937 kernel patches
;
; Revision 1.3  1999/02/01 01:48:41  jprice
; Clean up; Now you can use hex numbers in config.sys. added config.sys screen function to change screen mode (28 or 43/50 lines)
;
; Revision 1.2  1999/01/22 04:13:27  jprice
; Formating
;
; Revision 1.1.1.1  1999/01/20 05:51:01  jprice
; Imported sources
;
;   Rev 1.4   06 Dec 1998  8:46:44   patv
;Bug fixes.
;
;   Rev 1.3   07 Feb 1998 20:42:08   patv
;Modified stack fram to match DOS standard
;
;   Rev 1.2   29 May 1996 21:03:36   patv
;bug fixes for v0.91a
;
;   Rev 1.1   01 Sep 1995 17:54:24   patv
;First GPL release.
;
;   Rev 1.0   02 Jul 1995  9:05:58   patv
;Initial revision.
; $EndLog$
;

                page    60,132
                title   Assembly support routines for process handling, etc.

		include	segs.inc

                extrn   _api_sp:word            ; api stacks - for context
                extrn   _api_ss:word            ; switching
                extrn   _usr_sp:word            ; user stacks
                extrn   _usr_ss:word

                extrn   _kstackp:near           ; kernel stack
                extrn   _ustackp:near           ; new task stack

                extrn   _break_flg:byte         ; break detected flag
                extrn   _int21_handler:far        ; far call system services

                include stacks.inc

_TEXT           segment

;
;       Special call for switching processes
;
;       void interrupt far exec_user(irp)
;       iregs far *irp;
;
                public  _exec_user
_exec_user      proc far

                PUSH$ALL
                mov     ax,DGROUP
                mov     ds,ax
                mov     bp,sp
                cld
                cli
;
;
;
                mov     ax,WORD PTR [bp.irp_low]        ; irp (user ss:sp)
                mov     dx,WORD PTR [bp.irp_hi]
                mov     sp,ax                   ; set-up user stack
                mov     ss,dx
                sti
;
                POP$ALL
                iret

_exec_user              endp



;; Called whenever the BIOS detects a ^Break state
                public  _got_cbreak
_got_cbreak		PROC FAR
	push ds
	push ax
	mov ax, 40h
	mov ds, ax
	or byte ptr ds:[71h], 80h	;; set the ^Break flag
	pop ax
	pop ds
_got_cbreak		ENDP


;
;       Special call for switching processes during break handling
;
;       void interrupt far spawn_int23()
;
;
;       +---------------+
;       |     flags     |       22
;       +---------------+
;       |       cs      |       20
;       +---------------+
;       |       ip      |       18
;       +---------------+
;       |       es      |       16
;       +---------------+
;       |       ds      |       14
;       +---------------+
;       |       bp      |       12
;       +---------------+
;       |       di      |       10
;       +---------------+
;       |       si      |       8
;       +---------------+
;       |       dx      |       6
;       +---------------+
;       |       cx      |       4
;       +---------------+
;       |       bx      |       2
;       +---------------+
;       |       ax      |       0       <--- bp & sp after mov bp,sp
;       +---------------+
;
                public  _spawn_int23
_spawn_int23   proc far

;; 1999/03/27 ska - comments: see cmt1.txt
				mov ax, DGROUP		;; Make sure DS is OK
				mov ds, ax
				ASSUME DS:DGROUP

                ; restore to user stack
                cli					;; Pre-8086 don't disable INT autom.
                mov     ss,_usr_ss
                mov     sp,_usr_sp
                sti
                ASSUME DS:NOTHING

                ; get all the user registers back
                POP$ALL

                ;; Construct the piece of code into the stack

		;; stack frame:		during generation of code piece
		;; <higher address>
		;; BP | SP | Meaning
		;;  7 | 11 | offset CALL FAR will push onto stack
		;;  5 |  9 | CALL FAR segment
		;;  3 |  7 | CALL FAR offset
		;;  2 |  6 | CALL FAR ??regain_control_int23  | instruction byte
		;;  0 |  4 | INT 23 <<should-be value of SP upon return>>
		;; -2 |  2 | segment of address of INT-23	\ To jump to INT 23
		;; -4 |  0 | offset of address of INT-23	/ via RETF
		;; Upon return from INT-23 the CALL FAR pushes the address of
		;; the byte immediately following the CALL FAR onto the stack.
		;; This value POPed and decremented by 7 is the value SP must
		;; contain, if the INT-23 was returned with RETF2/IRET.

				sub sp, 8		;; code piece needs 7 bytes --> 4 words
				push ss			;; prepare jump to INT-23 via RETF
				push bp			;; will be offset / temp: saved BP
				mov bp, sp
				add bp, 4		;; position BP onto INT-23
				mov word ptr [bp], 23cdh		;; INT 23h
				mov byte ptr 2[bp], 9ah			;; CALL FAR immediate
				mov word ptr 3[bp], OFFSET ??regain_control_int23
				mov word ptr 5[bp], cs

				;; complete the jump to INT-23 via RETF and restore BP
				xchg word ptr -4[bp], bp

                stc			;; set default action --> terminate
                ; invoke the int 23 handler its address has been constructed
                ;; on the stack
                retf

??regain_control_int23:

		;; stack frame:		constructed on entry to INT-23
		;; <higher address>
		; BP | SP | Meaning
		;;  7 | 11 | offset CALL FAR will push onto stack
		;;  5 |  9 | CALL FAR segment
		;;  3 |  7 | CALL FAR offset
		;;  2 |  6 | CALL FAR ??regain_control_int23  | instruction byte
		;;  0 |  4 | INT 23 <<should-be value of SP upon return>>
		;; -2 |  2 | segment of address of INT-23	\ To jump to INT 23
		;; -4 |  0 | offset of address of INT-23	/ via RETF
		;; Upon return from INT-23 the CALL FAR pushes the address of
		;; the byte immediately following the CALL FAR onto the stack.
		;; This value POPed and decremented by 7 is the value SP must
		;; contain, if the INT-23 was returned with RETF2/IRET.

		;; stack frame:		used during recovering from INT-23
		;; <higher address>
		;; BP | Meaning
		;;  1 | <<next word onto stack, or value SP has to become>>
		;;  0 | <<return address from CALL FAR>>
		;; -1 | saved BP
		;; -3 | saved AX
		;; -7 | INT 23 <<should-be value of SP upon return>>

		;; Somewhere on stack:
		;; SP | Meaning
		;;  4 | segment of return address of CALL FAR
		;;  2 | offset of return address of CALL FAR
		;;  0 | saved BP

				push bp
				mov bp, sp
				mov bp, 2[bp]		;; get should-be address + 7
				mov word ptr -3[bp], ax		;; save AX
				pop ax				;; old BP
				mov word ptr -1[bp], ax		;; preserve saved BP
				mov ax, bp
				dec ax			;; last used word of stack
				dec ax			;; Don't use SUB to keep Carry flag
				dec ax
				xchg ax, sp		;; AX := current stack; SP corrected
				;; Currently: BP - 7 == address of INT-23
				;; should be  AX + 4 --> IRET or RETF 2
				;; ==> Test if BP - 7 == AX + 4
				;; ==> Test if AX + 4 - BP + 7 == 0
				pushf			;; preserve Carry flag
				add ax, 4 + 7
				sub ax, bp		;; AX := SP + 4 
				pop ax			;; saved Carry flag
				jz ??int23_ign_carry ;; equal -> IRET --> ignore Carry
									;; Carry is already cleared
				push ax
				popf			;; restore Carry flag

??int23_ign_carry:
				pop ax					;; Restore the original register
				jnc ??int23_respawn
				;; The user returned via RETF 0, Carry is set
				;; --> terminate program
				;; This is done by set the _break_flg and modify the
				;; AH value, which is passed to the _respawn_ call
				;; into 0, which is "Terminate program".
				push ds			;; we need DGROUP
				mov bp, DGROUP
				mov ds, bp
				ASSUME DS:DGROUP
				inc _break_flg
				pop ds
				ASSUME DS:NOTHING

				xor ah, ah		;; clear ah --> perform DOS-00 --> terminate

??int23_respawn:
				pop bp					;; Restore the original register
                jmp 	_int21_handler

_spawn_int23   endp


;
; interrupt enable and disable routines
;
                public  _enable
_enable         proc near
                sti
                ret
_enable         endp

                public  _disable
_disable        proc near
                cli
                ret
_disable        endp

_TEXT           ends

                end


