### Name: mas5
### Title: MAS 5.0 Expression Measure
### Aliases: mas5 xpsMAS5-methods xpsMAS5
### Keywords: manip

### ** Examples

## first, load ROOT scheme file and ROOT data file
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
data.test3 <- root.data(scheme.test3, paste(.path.package("xps"),"rootdata/DataTest3_cel.root",sep="/"))

data.mas5 <- mas5(data.test3,"tmp_Test3MAS5",tmpdir="",normalize=TRUE,sc=500,update=TRUE,verbose=FALSE)

## get data.frame
expr.mas5 <- validData(data.mas5)
head(expr.mas5)

## plot results
if (interactive()) {
boxplot(data.mas5)
boxplot(log2(expr.mas5))
}

rm(scheme.test3, data.test3)
gc()



