### Name: root.merge.data
### Title: Create class DataTreeSet by merging ROOT data files
### Aliases: root.merge.data
### Keywords: manip

### ** Examples

## get scheme and import CEL-files from package
scheme.test3 <- root.scheme(paste(.path.package("xps"),"schemes/SchemeTest3.root",sep="/"))
data.test3 <- import.data(scheme.test3,"tmp_datatest3",celdir=paste(.path.package("xps"),"raw",sep="/"),verbose=FALSE)

## get subset of CEL-files
subdataA <- root.data(scheme.test3,"tmp_datatest3_cel.root", celnames=c("TestA1.cel","TestA2.cel"))
subdataB <- root.data(scheme.test3,"tmp_datatest3_cel.root", celnames=c("TestB1.cel","TestB2.cel"))

## merge data
dataAB <- root.merge.data(scheme.test3,c(rootFile(subdataA),rootFile(subdataB)), celnames=c("TestB1.cel","TestA2.cel","TestB2.cel"))



