###################################################
### chunk number 1: 
###################################################
library(golubEsets)
oldopt <- options(digits=3)
on.exit( {options(oldopt)} )
options(width=70)
if (interactive()) { 
    options(error=recover)
}
set.seed(123)


###################################################
### chunk number 2: 
###################################################
library(stam) 


###################################################
### chunk number 3: 
###################################################
library(golubEsets) 
data(Golub_Merge) 
golubTrain <- Golub_Merge[,1:38] 
golubTest <- Golub_Merge[,39:72] 


###################################################
### chunk number 4: 
###################################################
net <- stam.net(chip="hu6800", root="GO:0005576", probes=rownames(exprs(Golub_Merge))) 


###################################################
### chunk number 5: 
###################################################
print(net) 
print(net@nodes[[31]])
print(net@nodes[["GO:0005579"]])


###################################################
### chunk number 6: 
###################################################
golubTrain.cv <- stam.cv(golubTrain, "ALL.AML", chip="hu6800",
                         root="GO:0005576", ndeltas=10)


###################################################
### chunk number 7: 
###################################################
print(golubTrain.cv) 
plot(golubTrain.cv, delta=0.6) 


###################################################
### chunk number 8: 
###################################################
plot(golubTrain.cv, delta=0.6, which=1)


###################################################
### chunk number 9: 
###################################################
plot(golubTrain.cv, delta=0.6, which=2)


###################################################
### chunk number 10: 
###################################################
golubTrain.fit <- stam.fit(golubTrain.cv, golubTrain, alpha=seq(0, 1, 0.1))


###################################################
### chunk number 11: 
###################################################
print(golubTrain.fit)
plot(golubTrain.fit)


###################################################
### chunk number 12: 
###################################################
plot(golubTrain.fit, which=1)


###################################################
### chunk number 13: 
###################################################
plot(golubTrain.fit, which=2)


###################################################
### chunk number 14: 
###################################################
golubTest.pred <- stam.predict(golubTrain.fit, golubTest, 
                               pData(golubTest)[,"ALL.AML"])
golubMerge.pred <- stam.predict(golubTrain.fit, Golub_Merge, 
                                pData(Golub_Merge)[,"ALL.AML"], testset=39:72)


###################################################
### chunk number 15: 
###################################################
print(golubTest.pred)
plot(golubTest.pred, outfile="golubTest")
image(golubMerge.pred, outfile="golubMerge")


