### Name: qvalue.cal
### Title: Computation of the q-value
### Aliases: qvalue.cal
### Keywords: htest

### ** Examples
## Not run: 
##D   # Load the package multtest and the data of Golub et al. (1999)
##D   # contained in multtest.
##D   library(multtest)
##D   data(golub)
##D 
##D   # Perform a SAM analysis.
##D   sam.out<-sam(golub, golub.cl, B=100, rand=123)
##D 
##D   # Estimate the prior probability that a gene is not significant.
##D   pi0 <- pi0.est(sam.out@p.value)$p0
##D   
##D   # Compute the q-values of the genes.
##D   q.value <- qvalue.cal(sam.out@p.value, pi0)
## End(Not run)


