### Name: plot.ProbBin.FCS
### Title: Plots a ProbBin.FCS object
### Aliases: plot.ProbBin.FCS
### Keywords: hplot

### ** Examples


if (require(rfcdmin)){

if (!( is.element("st.1829", objects()) & is.element("unst.1829",
objects()) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}

## This only serves as an example.
## Gating/subsetting should precede this analysis
IFN.gamma.1<-unst.1829@data[1:2000,4]
IFN.gamma.2<-st.1829@data[1:2000,4]

#Probability binning using the control dataset to determine the breaks
PB1<-ProbBin.FCS(IFN.gamma.1, IFN.gamma.2, 200,
varname=colnames(unst.1829@data)[4], PBspec="by.control",MY.DEBUG=FALSE)

## Probability Binning using the combined dataset (control and stimulated)
## to determing the breaks
PB2<-ProbBin.FCS(IFN.gamma.1, IFN.gamma.2, 200,
varname=colnames(unst.1829@data)[4], PBspec="combined",MY.DEBUG=FALSE)

if (interactive()){
par(mfrow=c(2,2))
## plots both plots
plot(PB1, ylim=c(0,500),main="Prob Binning using the Control dataset")

## plots only the unstimulated
plot(PB2, main="Prob Binning using the Combined Dataset", plots.made="unstimulated")

## plots only the stimulated
plot(PB2, main="Prob Binning using the Combined Dataset", plots.made="stimulated")
}

}




