### Name: qpPrecisionRecall
### Title: Calculation of precision-recall curves
### Aliases: qpPrecisionRecall
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

nrr.estimates <- qpNrr(X, q=5, verbose=FALSE) # NRR !

pcc.estimates <- qpPCC(X) # PCC !

# calculate area under the precision-recall curve

nrr.prerec <- qpPrecisionRecall(nrr.estimates, refI=K!=0, decreasing=FALSE,
                                recallSteps=seq(0, 1, 0.1))
f <- approxfun(nrr.prerec[, c("Recall", "Precision")])
integrate(f, 0, 1)$value

pcc.prerec <- qpPrecisionRecall(abs(pcc.estimates$R), refI=K!=0,
                                recallSteps=seq(0, 1, 0.1))
f <- approxfun(pcc.prerec[, c("Recall", "Precision")])
integrate(f, 0, 1)$value



