### Name: qpPRscoreThreshold
### Title: Calculation of scores thresholds attaining nominal precision or
###   recall levels
### Aliases: qpPRscoreThreshold
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

nrr.estimates <- qpNrr(X, q=1, verbose=FALSE)

nrr.prerec <- qpPrecisionRecall(nrr.estimates, K!=0, decreasing=FALSE, recallSteps=seq(0,1,0.1))

qpPRscoreThreshold(nrr.prerec, level=0.5, recall.level=TRUE, max.score=0)

qpPRscoreThreshold(nrr.prerec, level=0.5, recall.level=FALSE, max.score=0)



