### Name: qpK2R
### Title: Partial correlation coefficients
### Aliases: qpK2R
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

R <- qpK2R(K)

# true partial correlation coefficients of the present edges
summary(abs(R[upper.tri(R) & I]))

# true partial correlation coefficients of the missing edges
summary(abs(R[upper.tri(R) & !I]))




