### Name: logitT
### Title: logit-t and t-test by row
### Aliases: logitTTransform logitTStat studenttTTest
### Keywords: univar manip

### ** Examples

# ------------------------------------------
# Example analyzing the 6 arrays in the 
# AffySpikeU95Subset data set

# Loading the data
data(AffySpikeU95Subset)

# Vector with groups assignment 
group<-factor(rep(1:2,each=3))

# logit-T statistic
logitT<-logitTStat(AffySpikeU95Subset,
                   as.numeric(group))

# Computing RMA expression index
data.rma<-exprs(rma(AffySpikeU95Subset))

# Ordinary t-test by row/gene
studentT<-studenttTTest(data.rma, as.numeric(group))

# Comparing genes ranked top-20
logitTTop20  <- rank(-abs(logitT)) < 21
studentTTop20<- rank(-abs(studentT)) < 21
table(logitTTop20,studentTTop20)




