### Name: nem
### Title: Nested Effects Models - main function
### Aliases: nem print.nem print.nem.greedy print.nem.greedyMAP
###   print.pairwise print.triples print.ModuleNetwork print.score
###   print.nem.BN
### Keywords: graphs models

### ** Examples

   data("BoutrosRNAi2002")
   D <- BoutrosRNAiDiscrete[,9:16]
   control = set.default.parameters(unique(colnames(D)), para=c(0.13, 0.05))   
   res1 <- nem(D,inference="search", control=control)
   res2 <- nem(D,inference="pairwise", control=control)
   res3 <- nem(D,inference="triples", control=control)
   res4 <- nem(D,inference="ModuleNetwork", control=control)
   res5 <- nem(D,inference="nem.greedy", control=control)        
   res6 = nem(BoutrosRNAiLods, inference="nem.greedyMAP", control=control)
   

   par(mfrow=c(2,3))
   plot.nem(res1,main="exhaustive search")
   plot.nem(res2,main="pairs")
   plot.nem(res3,main="triples")
   plot.nem(res4,main="module network")
   plot.nem(res5,main="greedy hillclimber")      
   plot.nem(res6,main="alternating MAP optimization")



