### Name: evalScoring
### Title: Score differential expression, assess significance, and smooth
###   scores along the chromosome
### Aliases: evalScoring
### Keywords: manip

### ** Examples

    data(stjd) # load example data

    # if you have the data package 'stjudem' installed,
    #  you should work on the full data therein, of which
    #  the provided example data, is just a piece
    #loaddatapkg("stjudem")

    # T-lymphocyte versus B-lymphocyte on chromosome 1, 
    #  smoothed with k-Nearest-Neighbours kernel(k=15), 
    #  few permutations for higher speed
    chrom1Tknn <- evalScoring(stjd,"T",chromosome="1",permute="labels",
    nperms=100,kernel=kNN,kernelparams=list(k=15),step.width=100000)

    # plotting on x11:
    if (interactive())
       plot(chrom1Tknn)

    # plotting on HTML:
    if (interactive())
       plot(chrom1Tknn,"html")



