### Name: getGffAttribute
### Title: Pull one or more key/value pairs from gffAttributes strings
### Aliases: getGffAttribute


### ** Examples


# Get file path
libPath <- installed.packages()["genomeIntervals", "LibPath"]
filePath <- file.path(
                   libPath,
                   "genomeIntervals",
                   "example_files"
                   )

# Load gff
gff <- readGff3( file.path( filePath, "sgd_simple.gff"), isRightOpen=FALSE)

## head of full gff annotations
head(annotation(gff))

# extract ID and Parent attributes
idpa = getGffAttribute( gff, c( "ID", "Parent" ) )

head(idpa)




