### Name: densityplot
### Title: One-dimensional density plots for flow data
### Aliases: densityplot densityplot,formula,flowSet-method
###   densityplot,formula,view-method densityplot,view,missing-method
###   panel.densityplot.flowset prepanel.densityplot.flowset
### Keywords: methods dplot

### ** Examples


data(GvHD)
GvHD <- GvHD[pData(GvHD)$Patient %in% 6:7]

densityplot(~ `FSC-H`, GvHD)

densityplot(~ `FSC-H` + `SSC-H`, GvHD)

densityplot(~ ., GvHD[1:3])

## include a filter
densityplot(~ `FSC-H`, GvHD, filter=curv1Filter("FSC-H"))




