### Name: lymphFilter-class
### Title: Automated gating of elliptical cell populations in 2D.
### Aliases: lymphFilter-class %in%,flowFrame,lymphFilter-method lymphGate
###   lymphFilter
### Keywords: misc classes

### ** Examples


data(GvHD)
dat <- GvHD[pData(GvHD)$Patient==10]
dat <- transform(dat, "FL4-H"=asinh(`FL4-H`))
lg <- lymphGate(dat, channels=c("FSC-H", "SSC-H"), preselection="FL4-H",scale=1.5)

if(require(flowViz))
xyplot(`SSC-H`~`FSC-H`, dat, filter=lg$n2gate)

## This is using the abstract lymphFilter class instead
lf <- lymphFilter(channels=c("FSC-H", "SSC-H"), preselection="FL4-H")
filter(dat, lf)




