### Name: addAMDISPeaks
### Title: Add AMDIS peak detection results
### Aliases: addAMDISPeaks
### Keywords: manip

### ** Examples

# need access to CDF (raw data) and ELU files 
require(gcspikelite)
gcmsPath<-paste(.find.package("gcspikelite"),"data",sep="/")

# full paths to file names
cdfFiles<-dir(gcmsPath,"CDF",full=TRUE)
eluFiles<-dir(gcmsPath,"ELU",full=TRUE)

# create a 'peaksDataset' object and add AMDIS peaks to it
pd<-peaksDataset(cdfFiles[1],mz=seq(50,550),rtrange=c(7.5,8.5))
pd<-addAMDISPeaks(pd,eluFiles[1])



