### Name: dyebias.monotonicity
### Title: Calculate the degree of monotonicity of the dye bias across the
###   slides.
### Aliases: dyebias.monotonicity
### Keywords: misc htest

### ** Examples

  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                                 is.balanced=TRUE,
                                                 verbose=FALSE)

     ### choose the estimators and which spots to correct:
     estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

     application.subset <- maW(data.norm) == 1 &
                   dyebias.application.subset(data.raw=data.raw, use.background=TRUE)

     ### do the correction:
     correction <- dyebias.apply.correction(data.norm=data.norm,
                                            iGSDBs = iGSDBs.estimated,
                                            estimator.subset=estimator.subset,
                                            application.subset = application.subset,
                                            verbose=FALSE)
  ## End Don't show                                     

  cat("monotonicity before correction")
  monotonicity <- dyebias.monotonicity(data=data.norm,
                                       iGSDBs=iGSDBs.estimated, 
                                       order=NULL)
  monotonicity

  cat("monotonicity after correction")

  dyebias.monotonicity(data=correction$data.corrected,
                                       iGSDBs=iGSDBs.estimated, 
                                       order= monotonicity$order)




