### Name: dyebias.apply.correction
### Title: Perform dye bias correction using the GASSCO method
### Aliases: dyebias.apply.correction
### Keywords: misc

### ** Examples

  ## First load data and estimate the iGSDBs
  ## (see dyebias.estimate.iGSDBs)

  ## Don't show: 
     options(stringsAsFactors = FALSE)

     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                              is.balanced=TRUE,
                                              verbose=FALSE)

  ## End Don't show                                    

  ### choose the estimators and which spots to correct:
  estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

  ### choose which genes to dye bias correct:
  application.subset <- (maW(data.norm) == 1 &
               dyebias.application.subset(data.raw=data.raw, use.background=TRUE))

  ### do the correction:
  correction <- dyebias.apply.correction(data.norm=data.norm,
                                         iGSDBs = iGSDBs.estimated,
                                         estimator.subset=estimator.subset,
                                         application.subset = application.subset,
                                         verbose=FALSE)
  
  ## Not run: 
##D      edit(correction$summary)
##D   
## End(Not run)

  ## give overview:
  correction$summary[,c("slide", "file", "reduction.perc", "p.value")]

  ## and summary:
  summary(as.numeric(correction$summary[, "reduction.perc"]))



