### Name: readPlateList
### Title: Read a collection of plate reader data files
### Aliases: readPlateList
### Keywords: manip

### ** Examples

datadir <- system.file("KcViabSmall", package = "cellHTS2")
x <- readPlateList("Platelist.txt", "KcViabSmall", path=datadir)

## To read data files obtained from an EnVision plate reader:
datadir <- system.file("EnVisionExample", package = "cellHTS2")
x <- readPlateList("platelist.txt", name="EnVisionEx",
          importFun=getEnVisionRawData, path=datadir)

## to get the cross talk corrected data:
y <- readPlateList("platelist.txt", name="EnVisionEx",
          importFun=getEnVisionCrosstalkCorrectedData, path=datadir)




