###################################################
### chunk number 1: annotate
###################################################
## library("annotate")
options(width=120)


###################################################
### chunk number 2: biomaRt
###################################################
library("biomaRt")
listMarts()


###################################################
### chunk number 3: ensembl1
###################################################
ensembl=useMart("ensembl")


###################################################
### chunk number 4: listDatasets
###################################################
listDatasets(ensembl)


###################################################
### chunk number 5: ensembl2
###################################################
ensembl = useMart("ensembl",dataset="hsapiens_gene_ensembl")


###################################################
### chunk number 6: filters
###################################################
filters = listFilters(ensembl)
filters[1:5,]


###################################################
### chunk number 7: attributes
###################################################
attributes = listAttributes(ensembl)
attributes[1:5,]


###################################################
### chunk number 8: affyids
###################################################
affyids=c("202763_at","209310_s_at","207500_at")
getBM(attributes=c('affy_hg_u133_plus_2', 'entrezgene'), filters = 'affy_hg_u133_plus_2', values = affyids, mart = ensembl)


###################################################
### chunk number 9: 
###################################################
affyids=c("202763_at","209310_s_at","207500_at")
getBM(attributes=c('affy_hg_u133_plus_2', 'hgnc_symbol', 'chromosome_name','start_position','end_position', 'band'),
 filters = 'affy_hg_u133_plus_2', values = affyids, mart = ensembl)


###################################################
### chunk number 10: 
###################################################
entrez=c("673","837")
getBM(attributes=c('entrezgene','go_biological_process_id'), filters='entrezgene', values=entrez, mart=ensembl)


###################################################
### chunk number 11:  eval=FALSE
###################################################
## refseqids = c("NM_005359","NM_000546")
## ipro = getBM(attributes=c("refseq_dna","interpro","interpro_description"), filters="refseq_dna",values=refseqids, mart=ensembl)


###################################################
### chunk number 12: 
###################################################
getBM(c('affy_hg_u133_plus_2','ensembl_gene_id'), filters = c('chromosome_name','start','end'),
 values=list(16,1100000,1250000), mart=ensembl)


###################################################
### chunk number 13: 
###################################################
getBM(c('entrezgene','hgnc_symbol'), filters='go', values='GO:0004707', mart=ensembl)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## entrez=c("673","7157","837")
## getSequence(id = entrez, type="entrezgene",seqType="coding_gene_flank",upstream=100, mart=ensembl) 


###################################################
### chunk number 15:  eval=FALSE
###################################################
## utr5 = getSequence(chromosome=3, start=185514033, end=185535839,
##                       type="entrezgene",seqType="5utr", mart=ensembl)
## utr5


###################################################
### chunk number 16:  eval=FALSE
###################################################
## protein = getSequence(id=c(100, 5728),type="entrezgene",
##                         seqType="peptide", mart=ensembl)
## protein


###################################################
### chunk number 17:  eval=FALSE
###################################################
## snpmart = useMart("snp", dataset="hsapiens_snp")


###################################################
### chunk number 18:  eval=FALSE
###################################################
## getBM(c('refsnp_id','allele','chrom_start','chrom_strand'), filters = c('chr_name','chrom_start','chrom_end'), values = list(8,148350,148612), mart = snpmart)


###################################################
### chunk number 19: 
###################################################
listMarts(archive=TRUE)


###################################################
### chunk number 20:  eval=FALSE
###################################################
## ensembl = useMart("ensembl_mart_46", dataset="hsapiens_gene_ensembl", archive = TRUE)


###################################################
### chunk number 21:  eval=FALSE
###################################################
## wormbase=useMart("wormbase_current",dataset="wormbase_gene")
## listFilters(wormbase)
## listAttributes(wormbase)
## getBM(attributes=c("name","rnai","rnai_phenotype","phenotype_desc"),
##                      filters="gene_name", values=c("unc-26","his-33"),
##                      mart=wormbase)
##      


###################################################
### chunk number 22: 
###################################################
filterType("with_affy_hg_u133_plus_2",ensembl)


###################################################
### chunk number 23: 
###################################################
filterOptions("biotype",ensembl)


###################################################
### chunk number 24: 
###################################################
pages = attributePages(ensembl)
pages


###################################################
### chunk number 25: 
###################################################
listAttributes(ensembl, page="feature_page")


###################################################
### chunk number 26: 
###################################################
sessionInfo()
warnings()


