### Name: congruence
### Title: Calculate congruence score between pairs of of genes sharing
###   pattern of synthetic genetic interactions (Ye et al. (2005)).
### Aliases: congruence
### Keywords: methods

### ** Examples

intM <- matrix(c(0,1,0,0,1,1,1,0,1,1,1,1,1,0,1,1),
                nrow=4, ncol=4, 
                dimnames=list(c("p1","p2","p3","p4"),
                  c("p1","p3","p5","p7")))
sharedInt <- getSharedInteraction(intM)
score <- congruence(intM, sharedInt, mode="query", universe=15, padjust=FALSE)



