### Name: setDataset-methods
### Title: getDataset<- Method to modify the attributes of a dataset from
###   an assessment
### Aliases: getDataset<- getDataset<--methods
###   getDataset<-,assessment-method
### Keywords: methods

### ** Examples


## Not run: 
##D aDataset <- new("dataset", dataId="vantVeer_70", dataPath="pathToFile")
##D aDataset <- loadData(aDataset)
##D 
##D expeOfInterest <- new("assessment", dataset=aDataset,
##D                                    noFolds1stLayer=10,
##D                                    noFolds2ndLayer=9,
##D                                    classifierName="svm",
##D                                    typeFoldCreation="original",
##D                                    svmKernel="linear",
##D                                    noOfRepeat=2,
##D                                    featureSelectionOptions=new("geneSubsets", optionValues=c(1,2,3,4,5,6)))
##D 
##D # Modify the dataId
##D getDataset(expeOfInterest, topic='dataId') <- "khan"
##D getDataset(expeOfInterest, 'dataId')
##D 
##D # Replace the dataset
##D getDataset(expeOfInterest) <- aDataset
##D getDataset(expeOfInterest, 'dataId')
## End(Not run)



