###################################################
### chunk number 1: loadlibs
###################################################
library("Rintact")
library("graph")
library("Rgraphviz")
#library("ppiStats")
library("RBGL")
library("apComplex")
library("xtable")


###################################################
### chunk number 2: psi25int
###################################################
url <- system.file("PSI25XML", "interactionSample.xml", package="Rintact")
ewing <- psi25interaction(url)


###################################################
### chunk number 3: ewingStruc
###################################################
class(ewing)


###################################################
### chunk number 4: slotEntries
###################################################
slotNames(ewing)


###################################################
### chunk number 5: simpleSlots
###################################################
ewing@organismName
ewing@taxId
ewing@releaseDate


###################################################
### chunk number 6: interactionSlot
###################################################
length(interactions(ewing))
class(interactions(ewing)[[1]])
interactions(ewing)[[1]]
slotNames(interactions(ewing)[[1]])


###################################################
### chunk number 7: getBaitPrey
###################################################
ewbait <- sapply(interactions(ewing), bait)
ewprey <- sapply(interactions(ewing), prey)


###################################################
### chunk number 8: baitVec
###################################################
ewbait
ewprey


###################################################
### chunk number 9: interactors
###################################################
interactors(ewing)


###################################################
### chunk number 10: translateEG
###################################################
wh = ewbait[3:4]


###################################################
### chunk number 11: lookUP
###################################################
interactors(ewing)[wh, "geneName"]


###################################################
### chunk number 12: psi25complex
###################################################
url2 <- system.file("PSI25XML/complexSample.xml", package="Rintact")
comps <- psi25complex(url2)
slotNames(comps)


###################################################
### chunk number 13: complex1
###################################################
length(complexes(comps))
class(complexes(comps)[[1]])
slotNames(complexes(comps)[[1]])


###################################################
### chunk number 14: check
###################################################
stopifnot(all(c("fullName", "attributes", "members")%in%slotNames(complexes(comps)[[1]])))


###################################################
### chunk number 15: showComplex1
###################################################
complexes(comps)[[1]]


###################################################
### chunk number 16: sessionInfo
###################################################
toLatex(sessionInfo())


