### Name: findChersOnSmoothed
### Title: Find ChIP-enriched regions on smoothed ExpressionSet
### Aliases: findChersOnSmoothed
### Keywords: manip

### ** Examples

  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
       modColumn = "Cy5", allChr = "9", winHalfSize = 400)
  chersX <- findChersOnSmoothed(smoothX, probeAnno=exProbeAnno,
       thresholds=0.45, allChr="9", distCutOff=600, cellType="human")
  if (interactive())
    plot(chersX[[1]], smoothX, probeAnno=exProbeAnno, gff=exGFF)
  chersX <- relateChers(chersX, exGFF)
  as.data.frame.cherList(chersX)



