###################################################
### chunk number 1: 
###################################################
require("AnnotationDbi", quietly = TRUE)
require("Resourcerer", quietly = TRUE)


###################################################
### chunk number 2: 
###################################################
agilent <- getResourcerer("Agilent_Human1_cDNA.zip", organism = "human",
destDir = file.path(.path.package("Resourcerer"), "temp"), baseUrl =
            "ftp://occams.dfci.harvard.edu/pub/bio/tgi/data/Resourcerer",
            clean = TRUE )


###################################################
### chunk number 3: 
###################################################
agilent[1:5, 1:4]


###################################################
### chunk number 4: 
###################################################
as.vector(colnames(agilent))


###################################################
### chunk number 5: 
###################################################

if(interactive()) {
    resourcerer2BioC("Agilent_Human1_cDNA.zip", organism = "human",
       destDir =  file.path(.path.package("Resourcerer"), "temp"),
       pkgName = "AgilentHsa1",
       srcUrls = getSrcUrl("all", "Homo sapiens"),
       pkgPath =  file.path(.path.package("Resourcerer"), "temp"),
       otherSrc = NULL, baseMapType = "gb",
       version = "1.1.0", fromWeb = TRUE,
       baseUrl = "ftp://occams.dfci.harvard.edu/pub/bio/tgi/data/Resourcerer",
               check = TRUE, author = list(authors = "Anonymous",
                              maintainer = "Anonymous <anonimous@email.com>"))
   }else{
       print("Code is executed only when invoked interactively")
   }


