mfuzz.plot               package:Mfuzz               R Documentation

_P_l_o_t_t_i_n_g _r_e_s_u_l_t_s _f_o_r _s_o_f_t _c_l_u_s_t_e_r_i_n_g

_D_e_s_c_r_i_p_t_i_o_n:

     This function visualises the clusters produced by 'mfuzz'.

_U_s_a_g_e:

     mfuzz.plot(eset,cl,mfrow=c(1,1),colo,min.mem=0,time.labels,new.window=TRUE)

_A_r_g_u_m_e_n_t_s:

    eset: object of the class_ExpressionSet_.

      cl: object of class _flclust_.

   mfrow: determines splitting of graphic window.

    colo: color palette to be used for plotting. If the color argument
          remains empty, the default palette is used.

 min.mem: Genes with membership values below 'min.mem' will not be
          displayed.

time.labels: labels can be given for the time axis.

new.window: should a new window be opened for graphics.

_V_a_l_u_e:

     The function generates plots where the membership of genes is
     color-encoded.

_A_u_t_h_o_r(_s):

     Matthias E. Futschik  (<URL:
     http://itb.biologie.hu-berlin.de/~futschik>)

_E_x_a_m_p_l_e_s:

     if (interactive()){
     data(yeast)
     # Data pre-processing
     yeastF <- filter.NA(yeast)
     yeastF <- fill.NA(yeastF)
     yeastF <- standardise(yeastF)

     # Soft clustering and visualisation
     cl <- mfuzz(yeastF,c=20,m=1.25)
     mfuzz.plot(yeastF,cl=cl,mfrow=c(2,2))

     # display of cluster cores with alpha = 0.5
     mfuzz.plot(yeastF,cl=cl,mfrow=c(2,2),min.mem=0.5)

     # display of cluster cores with alpha = 0.7
     mfuzz.plot(yeastF,cl=cl,mfrow=c(2,2),min.mem=0.7)
     }

