### Name: coverage
### Title: Coverage across a set of ranges
### Aliases: coverage.isCalledWithStartEndInterface
###   coverage.getShift0FromStartEnd coverage.getWidthFromStartEnd
###   coverage.normargWidth coverage coverage,numeric-method
###   coverage,IRanges-method coverage,Views-method
###   coverage,MaskCollection-method
### Keywords: methods

### ** Examples

  x <- IRanges(start=c(-2L, 6L, 9L, -4L, 1L, 0L, -6L, 10L),
               width=c( 5L, 0L, 6L,  1L, 4L, 3L,  2L,  3L))
  coverage(x)
  coverage(x, shift=7)
  coverage(x, shift=7, width=27)
  coverage(restrict(x, 1, 10))
  coverage(reduce(x), shift=7)
  coverage(gaps(shift(x, 7), start=1, end=27))

  mask1 <- Mask(mask.width=29, start=c(11, 25, 28), width=c(5, 2, 2))
  mask2 <- Mask(mask.width=29, start=c(3, 10, 27), width=c(5, 8, 1))
  mask3 <- Mask(mask.width=29, start=c(7, 12), width=c(2, 4))
  mymasks <- append(append(mask1, mask2), mask3)
  coverage(mymasks)



