### Name: IRanges-class
### Title: IRanges and NormalIRanges objects
### Aliases: class:IRanges IRanges-class start,IRanges-method
###   width,IRanges-method names,IRanges-method start<-,IRanges-method
###   width<-,IRanges-method end<-,IRanges-method names<-,IRanges-method
###   update,IRanges-method [,IRanges-method c,IRanges-method
###   class:NormalIRanges NormalIRanges-class NormalIRanges
###   isEmpty,NormalIRanges-method max,NormalIRanges-method
###   min,NormalIRanges-method coerce,logical,IRanges-method
###   coerce,logical,NormalIRanges-method
### Keywords: methods classes

### ** Examples

  showClass("IRanges")  # shows (some of) the known subclasses

  ## ---------------------------------------------------------------------
  ## A. MANIPULATING IRanges OBJECTS
  ## ---------------------------------------------------------------------
  ## All the methods defined for Ranges objects work on IRanges objects.
  ## See ?Ranges for some examples.
  ## Also see ?`IRanges-utils` and ?`IRanges-setops` for additional
  ## operations on IRanges objects.

  ## ---------------------------------------------------------------------
  ## B. A NOTE ABOUT PERFORMANCE
  ## ---------------------------------------------------------------------
  ## Using an IRanges object for storing a big set of ranges is more
  ## efficient than using a standard R data frame:
  N <- 2000000L  # nb of ranges
  W <- 180L      # width of each range
  start <- 1L
  end <- 50000000L
  set.seed(777)
  range_starts <- sort(sample(end-W+1L, N))
  range_widths <- rep.int(W, N)
  ## Instantiation is faster
  system.time(x <- IRanges(start=range_starts, width=range_widths))
  system.time(y <- data.frame(start=range_starts, width=range_widths))
  ## Subsetting is faster
  system.time(x16 <- x[c(TRUE, rep.int(FALSE, 15))])
  system.time(y16 <- y[c(TRUE, rep.int(FALSE, 15)), ])
  ## Internal representation is more compact
  object.size(x16)
  object.size(y16)



