### Name: Ranges-class
### Title: Ranges objects
### Aliases: class:Ranges Ranges-class RangesORmissing-class Ranges
###   length,Ranges-method width start,Ranges-method width,Ranges-method
###   end,Ranges-method mid mid,Ranges-method start<- width<- end<-
###   isEmpty,Ranges-method isDisjoint isDisjoint,Ranges-method
###   as.matrix,Ranges-method as.data.frame,Ranges-method
###   as.integer,Ranges-method show,Ranges-method [<-,Ranges-method
###   rep,Ranges-method isNormal isNormal,Ranges-method whichFirstNotNormal
###   whichFirstNotNormal,Ranges-method first first,Ranges-method last
###   last,Ranges-method
### Keywords: methods classes

### ** Examples

  x <- IRanges(start=c(2:-1, 13:15), width=c(0:3, 2:0))
  x
  length(x)
  start(x)
  width(x)
  end(x)
  isEmpty(x)
  as.matrix(x)
  as.data.frame(x)

  ## Subsetting:
  x[4:2]                  # 3 ranges
  x[-1]                   # 6 ranges
  x[FALSE]                # 0 range
  x0 <- x[width(x) == 0]  # 2 ranges
  isEmpty(x0)

  ## Use the replacement methods to resize the ranges:
  width(x) <- width(x) * 2 + 1
  x
  end(x) <- start(x)            # equivalent to width(x) <- 0
  x
  width(x) <- c(2, 0, 4) 
  x
  start(x)[3] <- end(x)[3] - 2  # resize the 3rd range
  x

  ## Name the elements:
  names(x)
  names(x) <- c("range1", "range2")
  x
  x[is.na(names(x))]  # 5 ranges
  x[!is.na(names(x))]  # 2 ranges

  ## Check for disjointedness
  isDisjoint(IRanges(c(2,5,1), c(3,7,3))) ## FALSE
  isDisjoint(IRanges(c(2,9,5), c(3,9,6))) ## TRUE
  isDisjoint(IRanges(1, 5)) ## TRUE

  ir <- IRanges(c(1,5), c(3,10))
  ir*1 # no change
  ir*c(1,2) # zoom second range by 2X
  ir*-2 # zoom out 2X  



